/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.json.JsonSerializer;

@Bean(properties="description,type,format,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf")
public class HeaderInfo {
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String description;
    private String type;
    private String format;
    private Items items;
    private String collectionFormat;
    private Object _default;
    private Number maximum;
    private Boolean exclusiveMaximum;
    private Number minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private List<Object> _enum;
    private Number multipleOf;
    private boolean strict;

    public static HeaderInfo create(String type) {
        return new HeaderInfo().setType(type);
    }

    public static HeaderInfo createStrict(String type) {
        return new HeaderInfo().setStrict().setType(type);
    }

    private HeaderInfo setStrict() {
        this.strict = true;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public HeaderInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public HeaderInfo setType(String type) {
        if (this.strict && !ArrayUtils.contains(type, VALID_TYPES)) {
            throw new RuntimeException("Invalid value passed in to setType(String).  Value='" + type + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_TYPES));
        }
        this.type = type;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public HeaderInfo setFormat(String format) {
        this.format = format;
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public HeaderInfo setItems(Items items) {
        this.items = items;
        return this;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public HeaderInfo setCollectionFormat(String collectionFormat) {
        if (this.strict && !ArrayUtils.contains(collectionFormat, VALID_COLLECTION_FORMATS)) {
            throw new RuntimeException("Invalid value passed in to setCollectionFormat(String).  Value='" + collectionFormat + "', valid values=" + JsonSerializer.DEFAULT_LAX.toString(VALID_COLLECTION_FORMATS));
        }
        this.collectionFormat = collectionFormat;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public HeaderInfo setDefault(Object _default) {
        this._default = _default;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public HeaderInfo setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public HeaderInfo setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public HeaderInfo setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public HeaderInfo setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public HeaderInfo setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public HeaderInfo setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public HeaderInfo setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public HeaderInfo setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public HeaderInfo setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public HeaderInfo setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public HeaderInfo setEnum(List<Object> _enum) {
        this._enum = _enum;
        return this;
    }

    public HeaderInfo addEnum(Object ... _enum) {
        return this.addEnum(Arrays.asList(_enum));
    }

    public HeaderInfo addEnum(Collection<Object> _enum) {
        if (this._enum == null) {
            this._enum = new LinkedList<Object>();
        }
        this._enum.addAll(_enum);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public HeaderInfo setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }
}

