/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.net.URI;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.dto.atom.Common;
import org.apache.juneau.xml.XmlContentHandler;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class Text
extends Common {
    private String type;
    String text;

    public Text(String type, String text) {
        this.type = type;
        this.text = text;
    }

    public Text(String text) {
        this.text = text;
    }

    public Text() {
    }

    @Xml(format=XmlFormat.ATTR)
    public String getType() {
        return this.type;
    }

    public Text setType(String type) {
        this.type = type;
        return this;
    }

    @Xml(format=XmlFormat.CONTENT, contentHandler=TextContentHandler.class)
    public String getText() {
        return this.text;
    }

    public Text setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public Text setBase(URI base) {
        super.setBase(base);
        return this;
    }

    @Override
    public Text setLang(String lang) {
        super.setLang(lang);
        return this;
    }

    public static class TextContentHandler
    implements XmlContentHandler<Text> {
        @Override
        public void parse(XMLStreamReader r, Text text) throws Exception {
            String type = text.type;
            text.text = type != null && type.equals("xhtml") ? XmlUtils.decode(XmlUtils.readXmlContents(r).trim()) : XmlUtils.decode(r.getElementText().trim());
        }

        @Override
        public void serialize(XmlWriter w, Text text) throws Exception {
            String type = text.type;
            String content = text.text;
            if (type != null && type.equals("xhtml")) {
                w.encodeTextInvalidChars(content);
            } else {
                w.encodeText(content);
            }
        }
    }
}

