/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.CommonEntry;
import org.apache.juneau.dto.atom.Entry;
import org.apache.juneau.dto.atom.Generator;
import org.apache.juneau.dto.atom.Icon;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Logo;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@Bean(typeName="feed")
public class Feed
extends CommonEntry {
    private Generator generator;
    private Icon icon;
    private Logo logo;
    private Text subtitle;
    private List<Entry> entries;

    public Feed(Id id, Text title, Calendar updated) {
        super(id, title, updated);
    }

    public Feed() {
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Feed setGenerator(Generator generator) {
        this.generator = generator;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Feed setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public Logo getLogo() {
        return this.logo;
    }

    public Feed setLogo(Logo logo) {
        this.logo = logo;
        return this;
    }

    @BeanProperty(name="subtitle")
    public Text getSubTitle() {
        return this.subtitle;
    }

    @BeanProperty(name="subtitle")
    public Feed setSubTitle(Text subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public List<Entry> getEntries() {
        return this.entries;
    }

    public Feed setEntries(List<Entry> entries) {
        this.entries = entries;
        return this;
    }

    public Feed addEntries(Entry ... entries) {
        if (this.entries == null) {
            this.entries = new LinkedList<Entry>();
        }
        this.entries.addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public Feed setAuthors(List<Person> authors) {
        super.setAuthors(authors);
        return this;
    }

    @Override
    public Feed addAuthors(Person ... authors) {
        super.addAuthors(authors);
        return this;
    }

    @Override
    public Feed setCategories(List<Category> categories) {
        super.setCategories(categories);
        return this;
    }

    @Override
    public Feed addCategories(Category ... categories) {
        super.addCategories(categories);
        return this;
    }

    @Override
    public Feed setContributors(List<Person> contributors) {
        super.setContributors(contributors);
        return this;
    }

    @Override
    public Feed addContributors(Person ... contributors) {
        super.addContributors(contributors);
        return this;
    }

    @Override
    public Feed setId(Id id) {
        super.setId(id);
        return this;
    }

    @Override
    public Feed setLinks(List<Link> links) {
        super.setLinks(links);
        return this;
    }

    @Override
    public Feed addLinks(Link ... links) {
        super.addLinks(links);
        return this;
    }

    @Override
    public Feed setRights(Text rights) {
        super.setRights(rights);
        return this;
    }

    @Override
    public Feed setTitle(Text title) {
        super.setTitle(title);
        return this;
    }

    @Override
    public Feed setUpdated(Calendar updated) {
        super.setUpdated(updated);
        return this;
    }

    @Override
    public Feed setBase(URI base) {
        super.setBase(base);
        return this;
    }

    @Override
    public Feed setLang(String lang) {
        super.setLang(lang);
        return this;
    }
}

