/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.Common;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.transforms.CalendarSwap;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class CommonEntry
extends Common {
    private List<Person> authors;
    private List<Category> categories;
    private List<Person> contributors;
    private Id id;
    private List<Link> links;
    private Text rights;
    private Text title;
    private Calendar updated;

    public CommonEntry(Id id, Text title, Calendar updated) {
        this.id = id;
        this.title = title;
        this.updated = updated;
    }

    public CommonEntry() {
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="author")
    public List<Person> getAuthors() {
        return this.authors;
    }

    public CommonEntry setAuthors(List<Person> authors) {
        this.authors = authors;
        return this;
    }

    public CommonEntry addAuthors(Person ... authors) {
        if (this.authors == null) {
            this.authors = new LinkedList<Person>();
        }
        this.authors.addAll(Arrays.asList(authors));
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="category")
    public List<Category> getCatetories() {
        return this.categories;
    }

    public CommonEntry setCategories(List<Category> categories) {
        this.categories = categories;
        return this;
    }

    public CommonEntry addCategories(Category ... categories) {
        if (this.categories == null) {
            this.categories = new LinkedList<Category>();
        }
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="contributor")
    public List<Person> getContributors() {
        return this.contributors;
    }

    public CommonEntry setContributors(List<Person> contributors) {
        this.contributors = contributors;
        return this;
    }

    public CommonEntry addContributors(Person ... contributors) {
        if (this.contributors == null) {
            this.contributors = new LinkedList<Person>();
        }
        this.contributors.addAll(Arrays.asList(contributors));
        return this;
    }

    public Id getId() {
        return this.id;
    }

    public CommonEntry setId(Id id) {
        this.id = id;
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public List<Link> getLinks() {
        return this.links;
    }

    public CommonEntry setLinks(List<Link> links) {
        this.links = links;
        return this;
    }

    public CommonEntry addLinks(Link ... links) {
        if (this.links == null) {
            this.links = new LinkedList<Link>();
        }
        this.links.addAll(Arrays.asList(links));
        return this;
    }

    public Text getRights() {
        return this.rights;
    }

    public CommonEntry setRights(Text rights) {
        this.rights = rights;
        return this;
    }

    public Text getTitle() {
        return this.title;
    }

    public CommonEntry setTitle(Text title) {
        this.title = title;
        return this;
    }

    @BeanProperty(swap=CalendarSwap.ISO8601DT.class)
    public Calendar getUpdated() {
        return this.updated;
    }

    public CommonEntry setUpdated(Calendar updated) {
        this.updated = updated;
        return this;
    }
}

