/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.client;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class SimpleX509TrustManager
implements X509TrustManager {
    private X509TrustManager baseTrustManager;

    public SimpleX509TrustManager(boolean lax) throws KeyStoreException, NoSuchAlgorithmException {
        if (!lax) {
            KeyStore ks = KeyStore.getInstance("jks");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(ks);
            for (TrustManager tm : factory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.baseTrustManager = (X509TrustManager)tm;
                return;
            }
            throw new IllegalStateException("Couldn't find JRE's X509TrustManager");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.baseTrustManager == null ? new X509Certificate[]{} : this.baseTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.baseTrustManager != null) {
            this.baseTrustManager.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.baseTrustManager != null) {
            this.baseTrustManager.checkServerTrusted(chain, authType);
        }
    }
}

