/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.client;

import java.io.StringWriter;
import org.apache.http.NameValuePair;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;

public final class SerializedNameValuePair
implements NameValuePair {
    private String name;
    private Object value;
    private UrlEncodingSerializer serializer;
    private static final ObjectMap op = new ObjectMap().append("UonSerializer.encodeChars", false);

    public SerializedNameValuePair(String name, Object value, UrlEncodingSerializer serializer) {
        this.name = name;
        this.value = value;
        this.serializer = serializer;
    }

    public String getName() {
        char c;
        if (this.name != null && this.name.length() > 0 && ((c = this.name.charAt(0)) == '$' || c == '(')) {
            try {
                UrlEncodingSerializerSession s = this.serializer.createSession(new StringWriter(), op, null);
                this.serializer.serialize(s, (Object)this.name);
                return s.getWriter().toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.name;
    }

    public String getValue() {
        try {
            UrlEncodingSerializerSession s = this.serializer.createSession(new StringWriter(), op, null);
            this.serializer.serialize(s, this.value);
            return s.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

