/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.http.Header;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.juneau.client.RestCallException;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.IOPipe;

public final class RestRequestEntity
extends BasicHttpEntity {
    final Object output;
    final Serializer serializer;
    byte[] outputBytes;

    public RestRequestEntity(Object input, Serializer serializer) {
        this.output = input;
        this.serializer = serializer;
        if (serializer != null) {
            this.setContentType((Header)new BasicHeader("Content-Type", serializer.getResponseContentType()));
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.output instanceof InputStream) {
            IOPipe.create(this.output, os).closeOut().run();
        } else if (this.output instanceof Reader) {
            IOPipe.create(this.output, new OutputStreamWriter(os, IOUtils.UTF8)).closeOut().run();
        } else {
            try {
                if (this.serializer == null) {
                    os.close();
                } else if (!this.serializer.isWriterSerializer()) {
                    OutputStreamSerializer s2 = (OutputStreamSerializer)this.serializer;
                    s2.serialize(this.output, (Object)os);
                    os.close();
                } else {
                    OutputStreamWriter w = new OutputStreamWriter(os, IOUtils.UTF8);
                    WriterSerializer s2 = (WriterSerializer)this.serializer;
                    s2.serialize(this.output, (Object)w);
                    ((Writer)w).close();
                }
            }
            catch (SerializeException e) {
                throw new RestCallException(e);
            }
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public InputStream getContent() {
        if (this.outputBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.writeTo(baos);
                this.outputBytes = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new ByteArrayInputStream(this.outputBytes);
    }
}

