/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.CoreApi;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.client.AllowAllRedirects;
import org.apache.juneau.client.HttpMethod;
import org.apache.juneau.client.RestCall;
import org.apache.juneau.client.RestCallException;
import org.apache.juneau.client.RestCallInterceptor;
import org.apache.juneau.client.RestCallLogger;
import org.apache.juneau.client.RestRequestEntity;
import org.apache.juneau.client.SSLOpts;
import org.apache.juneau.client.SimpleX509TrustManager;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class RestClient
extends CoreApi {
    Map<String, Object> headers = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    volatile CloseableHttpClient httpClient;
    HttpClientConnectionManager httpClientConnectionManager;
    Serializer serializer;
    UrlEncodingSerializer urlEncodingSerializer = new UrlEncodingSerializer();
    Parser parser;
    String accept;
    String contentType;
    List<RestCallInterceptor> interceptors = new ArrayList<RestCallInterceptor>();
    String remoteableServletUri;
    private Map<Method, String> remoteableServiceUriMap = new ConcurrentHashMap<Method, String>();
    private String rootUrl;
    private SSLOpts sslOpts;
    private boolean pooled;
    private volatile boolean isClosed = false;
    private StackTraceElement[] creationStack;
    protected HttpClientBuilder httpClientBuilder;
    private Pattern absUrlPattern = Pattern.compile("^\\w+\\:\\/\\/.*");

    public RestClient() {
        this.httpClientBuilder = this.createHttpClientBuilder();
        if (Boolean.getBoolean("org.apache.juneau.client.RestClient.trackCreation")) {
            this.creationStack = Thread.currentThread().getStackTrace();
        }
    }

    public RestClient(CloseableHttpClient httpClient) {
        this();
        this.setHttpClient(httpClient);
    }

    public RestClient(Serializer s, Parser p) {
        this();
        this.setSerializer(s);
        this.setParser(p);
    }

    public RestClient(CloseableHttpClient httpClient, Serializer s, Parser p) {
        this();
        this.setHttpClient(httpClient);
        this.setSerializer(s);
        this.setParser(p);
    }

    public RestClient(Class<? extends Serializer> s, Class<? extends Parser> p) throws InstantiationException {
        this();
        this.setSerializer(s);
        this.setParser(p);
    }

    public RestClient(CloseableHttpClient httpClient, Class<? extends Serializer> s, Class<? extends Parser> p) throws InstantiationException {
        this();
        this.setHttpClient(httpClient);
        this.setSerializer(s);
        this.setParser(p);
    }

    protected CloseableHttpClient createHttpClient() throws Exception {
        if (this.httpClientConnectionManager == null) {
            this.httpClientBuilder.setConnectionManager(this.createConnectionManager());
        }
        return this.httpClientBuilder.build();
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder b = HttpClientBuilder.create();
        b.setRedirectStrategy((RedirectStrategy)new AllowAllRedirects());
        return b;
    }

    protected HttpClientConnectionManager createConnectionManager() {
        if (this.sslOpts != null) {
            NoopHostnameVerifier hv = null;
            switch (this.sslOpts.getHostVerify()) {
                case LAX: {
                    hv = new NoopHostnameVerifier();
                    break;
                }
                case DEFAULT: {
                    hv = new DefaultHostnameVerifier();
                }
            }
            for (String p : StringUtils.split(this.sslOpts.getProtocols(), ',')) {
                try {
                    SimpleX509TrustManager tm = new SimpleX509TrustManager(this.sslOpts.getCertValidate() == SSLOpts.CertValidate.LAX);
                    SSLContext ctx = SSLContext.getInstance(p);
                    ctx.init(null, new TrustManager[]{tm}, null);
                    ctx.getSocketFactory().createSocket().close();
                    SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)hv);
                    this.setSSLSocketFactory((LayeredConnectionSocketFactory)sf);
                    Registry r = RegistryBuilder.create().register("https", (Object)sf).build();
                    return (HttpClientConnectionManager)(this.pooled ? new PoolingHttpClientConnectionManager(r) : new BasicHttpClientConnectionManager((Lookup)r));
                }
                catch (Throwable throwable) {
                }
            }
        }
        return (HttpClientConnectionManager)(this.pooled ? new PoolingHttpClientConnectionManager() : new BasicHttpClientConnectionManager());
    }

    public RestClient setBasicAuth(String host, int port, String user, String pw) {
        AuthScope scope = new AuthScope(host, port);
        UsernamePasswordCredentials up = new UsernamePasswordCredentials(user, pw);
        BasicCredentialsProvider p = new BasicCredentialsProvider();
        p.setCredentials(scope, (Credentials)up);
        this.setDefaultCredentialsProvider((CredentialsProvider)p);
        return this;
    }

    public RestClient setPooled() {
        this.pooled = true;
        return this;
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void closeQuietly() {
        this.isClosed = true;
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public RestClient setHeader(String name, Object value) {
        this.headers.put(name, value);
        return this;
    }

    public RestClient setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestClient setSerializer(Class<? extends Serializer> c) throws InstantiationException {
        try {
            return this.setSerializer(c.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.getLocalizedMessage());
        }
    }

    public RestClient setParser(Parser parser) {
        this.parser = parser;
        this.accept = parser.getMediaTypes()[0];
        return this;
    }

    public RestClient setParser(Class<? extends Parser> c) throws InstantiationException {
        try {
            return this.setParser(c.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException(e.getLocalizedMessage());
        }
    }

    public RestClient setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public RestClient setClientVersion(String version) {
        return this.setHeader("X-Client-Version", version);
    }

    public RestClient addInterceptor(RestCallInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public RestClient logTo(Level level, Logger log) {
        this.addInterceptor(new RestCallLogger(level, log));
        return this;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public Parser getParser() {
        return this.parser;
    }

    public HttpClient getHttpClient() throws Exception {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    protected HttpResponse execute(HttpUriRequest req) throws Exception {
        return this.getHttpClient().execute(req);
    }

    public RestClient setAccept(String accept) {
        this.accept = accept;
        return this;
    }

    public RestClient setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RestClient setRemoteableServletUri(String remoteableServletUri) {
        this.remoteableServletUri = remoteableServletUri;
        return this;
    }

    public RestClient setRootUrl(String rootUrl) {
        if (rootUrl.endsWith("/")) {
            rootUrl = rootUrl.replaceAll("\\/$", "");
        }
        this.rootUrl = rootUrl;
        return this;
    }

    public RestClient enableSSL(SSLOpts opts) throws KeyStoreException, NoSuchAlgorithmException {
        this.sslOpts = opts;
        return this;
    }

    public RestClient enableLaxSSL() throws KeyStoreException, NoSuchAlgorithmException {
        return this.enableSSL(SSLOpts.LAX);
    }

    public RestCall doGet(Object url) throws RestCallException {
        return this.doCall("GET", url, false);
    }

    public RestCall doPut(Object url, Object o) throws RestCallException {
        return this.doCall("PUT", url, true).setInput(o);
    }

    public RestCall doPost(Object url, Object o) throws RestCallException {
        return this.doCall("POST", url, true).setInput(o);
    }

    public RestCall doDelete(Object url) throws RestCallException {
        return this.doCall("DELETE", url, false);
    }

    public RestCall doOptions(Object url) throws RestCallException {
        return this.doCall("OPTIONS", url, true);
    }

    public RestCall doFormPost(Object url, Object o) throws RestCallException {
        return this.doCall("POST", url, true).setInput(o instanceof HttpEntity ? o : new RestRequestEntity(o, this.urlEncodingSerializer));
    }

    public RestCall doCallback(String callString) throws RestCallException {
        String s = callString;
        try {
            RestCall rc = null;
            String method = null;
            String uri = null;
            String content = null;
            ObjectMap h = null;
            int i = s.indexOf(32);
            if (i != -1) {
                method = s.substring(0, i).trim();
                if ((s = s.substring(i).trim()).length() > 0) {
                    if (s.charAt(0) == '{' && (i = s.indexOf(125)) != -1) {
                        String json = s.substring(0, i + 1);
                        h = JsonParser.DEFAULT.parse((Object)json, ObjectMap.class);
                        s = s.substring(i + 1).trim();
                    }
                    if (s.length() > 0) {
                        i = s.indexOf(32);
                        if (i == -1) {
                            uri = s;
                        } else {
                            uri = s.substring(0, i).trim();
                            if ((s = s.substring(i).trim()).length() > 0) {
                                content = s;
                            }
                        }
                    }
                }
            }
            if (method != null && uri != null) {
                rc = this.doCall(method, uri, content != null);
                if (content != null) {
                    rc.setInput(new StringEntity(content));
                }
                if (h != null) {
                    for (Map.Entry<String, Object> e : h.entrySet()) {
                        rc.setHeader(e.getKey(), e.getValue());
                    }
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw new RestCallException(e);
        }
        throw new RestCallException("Invalid format for call string.");
    }

    public RestCall doCall(HttpMethod method, Object url, Object content) throws RestCallException {
        RestCall rc = this.doCall(method.name(), url, method.hasContent());
        if (method.hasContent()) {
            rc.setInput(content);
        }
        return rc;
    }

    public RestCall doCall(String method, Object url, boolean hasContent) throws RestCallException {
        Object req = null;
        RestCall restCall = null;
        final String methodUC = method.toUpperCase(Locale.ENGLISH);
        if (hasContent) {
            req = new HttpEntityEnclosingRequestBase(){

                public String getMethod() {
                    return methodUC;
                }
            };
            restCall = new RestCall(this, (HttpRequestBase)req);
            if (this.contentType != null) {
                restCall.setHeader("Content-Type", this.contentType);
            }
        } else {
            req = new HttpRequestBase(){

                public String getMethod() {
                    return methodUC;
                }
            };
            restCall = new RestCall(this, (HttpRequestBase)req);
        }
        try {
            req.setURI(this.toURI(url));
        }
        catch (URISyntaxException e) {
            throw new RestCallException(e);
        }
        if (this.accept != null) {
            restCall.setHeader("Accept", this.accept);
        }
        for (Map.Entry<String, Object> e : this.headers.entrySet()) {
            restCall.setHeader(e.getKey(), e.getValue());
        }
        return restCall;
    }

    public <T> T getRemoteableProxy(final Class<T> interfaceClass) {
        if (this.remoteableServletUri == null) {
            throw new RuntimeException("Remoteable service URI has not been specified.");
        }
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                try {
                    String uri = (String)RestClient.this.remoteableServiceUriMap.get(method);
                    if (uri == null) {
                        uri = RestClient.this.remoteableServletUri + '/' + interfaceClass.getName() + '/' + ClassUtils.getMethodSignature(method);
                        RestClient.this.remoteableServiceUriMap.put(method, uri);
                    }
                    return RestClient.this.doPost(uri, args).getResponse(method.getReturnType());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private URI toURI(Object url) throws URISyntaxException {
        ThrowableUtils.assertFieldNotNull(url, "url");
        if (url instanceof URI) {
            return (URI)url;
        }
        if (url instanceof URL) {
            ((URL)url).toURI();
        }
        String s = url.toString();
        if (this.rootUrl != null && !this.absUrlPattern.matcher(s).matches()) {
            if (s.isEmpty()) {
                s = this.rootUrl;
            } else {
                StringBuilder sb = new StringBuilder(this.rootUrl);
                if (!s.startsWith("/")) {
                    sb.append('/');
                }
                sb.append(s);
                s = sb.toString();
            }
        }
        return new URI(s);
    }

    @Override
    public RestClient setProperty(String property, Object value) throws LockedException {
        super.setProperty(property, value);
        if (this.serializer != null) {
            this.serializer.setProperty(property, value);
        }
        if (this.parser != null) {
            this.parser.setProperty(property, value);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.setProperty(property, value);
        }
        return this;
    }

    @Override
    public RestClient setProperties(ObjectMap properties) throws LockedException {
        super.setProperties(properties);
        if (this.serializer != null) {
            this.serializer.setProperties(properties);
        }
        if (this.parser != null) {
            this.parser.setProperties(properties);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.setProperties(properties);
        }
        return this;
    }

    @Override
    public RestClient addNotBeanClasses(Class<?> ... classes) throws LockedException {
        super.addNotBeanClasses(classes);
        if (this.serializer != null) {
            this.serializer.addNotBeanClasses((Class[])classes);
        }
        if (this.parser != null) {
            this.parser.addNotBeanClasses((Class[])classes);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.addNotBeanClasses((Class[])classes);
        }
        return this;
    }

    @Override
    public RestClient addBeanFilters(Class<?> ... classes) throws LockedException {
        super.addBeanFilters(classes);
        if (this.serializer != null) {
            this.serializer.addBeanFilters((Class[])classes);
        }
        if (this.parser != null) {
            this.parser.addBeanFilters((Class[])classes);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.addBeanFilters((Class[])classes);
        }
        return this;
    }

    @Override
    public RestClient addPojoSwaps(Class<?> ... classes) throws LockedException {
        super.addPojoSwaps(classes);
        if (this.serializer != null) {
            this.serializer.addPojoSwaps((Class[])classes);
        }
        if (this.parser != null) {
            this.parser.addPojoSwaps((Class[])classes);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.addPojoSwaps((Class[])classes);
        }
        return this;
    }

    @Override
    public RestClient addToDictionary(Class<?> ... classes) throws LockedException {
        super.addToDictionary(classes);
        if (this.serializer != null) {
            this.serializer.addToDictionary((Class[])classes);
        }
        if (this.parser != null) {
            this.parser.addToDictionary((Class[])classes);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.addToDictionary((Class[])classes);
        }
        return this;
    }

    @Override
    public <T> RestClient addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        super.addImplClass(interfaceClass, implClass);
        if (this.serializer != null) {
            this.serializer.addImplClass((Class)interfaceClass, (Class)implClass);
        }
        if (this.parser != null) {
            this.parser.addImplClass((Class)interfaceClass, (Class)implClass);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.addImplClass((Class)interfaceClass, (Class)implClass);
        }
        return this;
    }

    @Override
    public RestClient setClassLoader(ClassLoader classLoader) throws LockedException {
        super.setClassLoader(classLoader);
        if (this.serializer != null) {
            this.serializer.setClassLoader(classLoader);
        }
        if (this.parser != null) {
            this.parser.setClassLoader(classLoader);
        }
        if (this.urlEncodingSerializer != null) {
            this.urlEncodingSerializer.setClassLoader(classLoader);
        }
        return this;
    }

    public RestClient setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.httpClientBuilder.setRedirectStrategy(redirectStrategy);
        return this;
    }

    public RestClient setDefaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        this.httpClientBuilder.setDefaultCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    public RestClient setRequestExecutor(HttpRequestExecutor requestExec) {
        this.httpClientBuilder.setRequestExecutor(requestExec);
        return this;
    }

    public RestClient setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.httpClientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        return this;
    }

    public RestClient setPublicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
        this.httpClientBuilder.setPublicSuffixMatcher(publicSuffixMatcher);
        return this;
    }

    public RestClient setSSLContext(SSLContext sslContext) {
        this.httpClientBuilder.setSSLContext(sslContext);
        return this;
    }

    public RestClient setSSLSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.httpClientBuilder.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    public RestClient setMaxConnTotal(int maxConnTotal) {
        this.httpClientBuilder.setMaxConnTotal(maxConnTotal);
        return this;
    }

    public RestClient setMaxConnPerRoute(int maxConnPerRoute) {
        this.httpClientBuilder.setMaxConnPerRoute(maxConnPerRoute);
        return this;
    }

    public RestClient setDefaultSocketConfig(SocketConfig config) {
        this.httpClientBuilder.setDefaultSocketConfig(config);
        return this;
    }

    public RestClient setDefaultConnectionConfig(ConnectionConfig config) {
        this.httpClientBuilder.setDefaultConnectionConfig(config);
        return this;
    }

    public RestClient setConnectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        this.httpClientBuilder.setConnectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
        return this;
    }

    public RestClient setConnectionManager(HttpClientConnectionManager connManager) {
        this.httpClientConnectionManager = connManager;
        this.httpClientBuilder.setConnectionManager(connManager);
        return this;
    }

    public RestClient setConnectionManagerShared(boolean shared) {
        this.httpClientBuilder.setConnectionManagerShared(shared);
        return this;
    }

    public RestClient setConnectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.httpClientBuilder.setConnectionReuseStrategy(reuseStrategy);
        return this;
    }

    public RestClient setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
        return this;
    }

    public RestClient setTargetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        this.httpClientBuilder.setTargetAuthenticationStrategy(targetAuthStrategy);
        return this;
    }

    public RestClient setProxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        this.httpClientBuilder.setProxyAuthenticationStrategy(proxyAuthStrategy);
        return this;
    }

    public RestClient setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.httpClientBuilder.setUserTokenHandler(userTokenHandler);
        return this;
    }

    public RestClient disableConnectionState() {
        this.httpClientBuilder.disableConnectionState();
        return this;
    }

    public RestClient setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.httpClientBuilder.setSchemePortResolver(schemePortResolver);
        return this;
    }

    public RestClient setUserAgent(String userAgent) {
        this.httpClientBuilder.setUserAgent(userAgent);
        return this;
    }

    public RestClient setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.httpClientBuilder.setDefaultHeaders(defaultHeaders);
        return this;
    }

    public RestClient addInterceptorFirst(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    public RestClient addInterceptorLast(HttpResponseInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    public RestClient addInterceptorFirst(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorFirst(itcp);
        return this;
    }

    public RestClient addInterceptorLast(HttpRequestInterceptor itcp) {
        this.httpClientBuilder.addInterceptorLast(itcp);
        return this;
    }

    public RestClient disableCookieManagement() {
        this.httpClientBuilder.disableCookieManagement();
        return this;
    }

    public RestClient disableContentCompression() {
        this.httpClientBuilder.disableContentCompression();
        return this;
    }

    public RestClient disableAuthCaching() {
        this.httpClientBuilder.disableAuthCaching();
        return this;
    }

    public RestClient setHttpProcessor(HttpProcessor httpprocessor) {
        this.httpClientBuilder.setHttpProcessor(httpprocessor);
        return this;
    }

    public RestClient setRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.httpClientBuilder.setRetryHandler(retryHandler);
        return this;
    }

    public RestClient disableAutomaticRetries() {
        this.httpClientBuilder.disableAutomaticRetries();
        return this;
    }

    public RestClient setProxy(HttpHost proxy) {
        this.httpClientBuilder.setProxy(proxy);
        return this;
    }

    public RestClient setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.httpClientBuilder.setRoutePlanner(routePlanner);
        return this;
    }

    public RestClient disableRedirectHandling() {
        this.httpClientBuilder.disableRedirectHandling();
        return this;
    }

    public RestClient setConnectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        this.httpClientBuilder.setConnectionBackoffStrategy(connectionBackoffStrategy);
        return this;
    }

    public RestClient setBackoffManager(BackoffManager backoffManager) {
        this.httpClientBuilder.setBackoffManager(backoffManager);
        return this;
    }

    public RestClient setServiceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
        this.httpClientBuilder.setServiceUnavailableRetryStrategy(serviceUnavailStrategy);
        return this;
    }

    public RestClient setDefaultCookieStore(CookieStore cookieStore) {
        this.httpClientBuilder.setDefaultCookieStore(cookieStore);
        return this;
    }

    public RestClient setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return this;
    }

    public RestClient setDefaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        this.httpClientBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    public RestClient setContentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
        this.httpClientBuilder.setContentDecoderRegistry(contentDecoderMap);
        return this;
    }

    public RestClient setDefaultRequestConfig(RequestConfig config) {
        this.httpClientBuilder.setDefaultRequestConfig(config);
        return this;
    }

    public RestClient useSystemProperties() {
        this.httpClientBuilder.useSystemProperties();
        return this;
    }

    public RestClient evictExpiredConnections() {
        this.httpClientBuilder.evictExpiredConnections();
        return this;
    }

    public RestClient evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.httpClientBuilder.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
        return this;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            System.err.println("WARNING:  RestClient garbage collected before it was finalized.");
            if (this.creationStack != null) {
                System.err.println("Creation Stack:");
                for (StackTraceElement e : this.creationStack) {
                    System.err.println(e);
                }
            } else {
                System.err.println("Creation stack traces can be displayed by setting the system property 'org.apache.juneau.client.RestClient.trackCreation' to true.");
            }
        }
    }
}

