/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.client;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.client.RestCall;
import org.apache.juneau.client.RestCallException;
import org.apache.juneau.client.RestCallInterceptor;

public class RestCallLogger
extends RestCallInterceptor {
    private Level level;
    private Logger log;

    protected RestCallLogger(Level level, Logger log) {
        this.level = level;
        this.log = log;
    }

    @Override
    public void onInit(RestCall restCall) {
        if (this.log.isLoggable(this.level)) {
            restCall.captureResponse();
        }
    }

    @Override
    public void onConnect(RestCall restCall, int statusCode, HttpRequest req, HttpResponse res) {
    }

    @Override
    public void onRetry(RestCall restCall, int statusCode, HttpRequest req, HttpResponse res, Exception ex) {
        if (this.log.isLoggable(this.level)) {
            if (ex == null) {
                this.log.log(this.level, MessageFormat.format("Call to {0} returned {1}.  Will retry.", req.getRequestLine().getUri(), statusCode));
            } else {
                this.log.log(this.level, MessageFormat.format("Call to {0} caused exception {1}.  Will retry.", req.getRequestLine().getUri(), ex.getLocalizedMessage()), ex);
            }
        }
    }

    @Override
    public void onClose(RestCall restCall) throws RestCallException {
        block14: {
            try {
                if (!this.log.isLoggable(this.level)) break block14;
                String output = restCall.getCapturedResponse();
                StringBuilder sb = new StringBuilder();
                HttpUriRequest req = restCall.getRequest();
                HttpResponse res = restCall.getResponse();
                if (req != null) {
                    sb.append("\n=== HTTP Call ==================================================================");
                    sb.append("\n=== REQUEST ===\n").append(req);
                    sb.append("\n---request headers---");
                    for (Header h : req.getAllHeaders()) {
                        sb.append("\n").append(h);
                    }
                    if (req instanceof HttpEntityEnclosingRequestBase) {
                        sb.append("\n---request entity---");
                        HttpEntityEnclosingRequestBase req2 = (HttpEntityEnclosingRequestBase)req;
                        HttpEntity e = req2.getEntity();
                        if (e == null) {
                            sb.append("\nEntity is null");
                        } else {
                            if (e.getContentType() != null) {
                                sb.append("\n").append(e.getContentType());
                            }
                            if (e.getContentEncoding() != null) {
                                sb.append("\n").append(e.getContentEncoding());
                            }
                            if (e.isRepeatable()) {
                                try {
                                    sb.append("\n---request content---\n").append(EntityUtils.toString((HttpEntity)e));
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        }
                    }
                }
                if (res != null) {
                    sb.append("\n=== RESPONSE ===\n").append(res.getStatusLine());
                    sb.append("\n---response headers---");
                    for (Header h : res.getAllHeaders()) {
                        sb.append("\n").append(h);
                    }
                    sb.append("\n---response content---\n").append(output);
                    sb.append("\n=== END ========================================================================");
                }
                this.log.log(this.level, sb.toString());
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }
}

