/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.client.ResponsePattern;
import org.apache.juneau.client.RestCallException;
import org.apache.juneau.client.RestCallInterceptor;
import org.apache.juneau.client.RestCallLogger;
import org.apache.juneau.client.RestClient;
import org.apache.juneau.client.RestRequestEntity;
import org.apache.juneau.client.RetryOn;
import org.apache.juneau.internal.ByteArrayInOutStream;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.TeeOutputStream;
import org.apache.juneau.internal.TeeWriter;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.utils.IOPipe;
import org.apache.juneau.utils.PojoRest;

public final class RestCall {
    private final RestClient client;
    private final HttpRequestBase request;
    private HttpResponse response;
    private List<RestCallInterceptor> interceptors = new ArrayList<RestCallInterceptor>();
    private boolean isConnected = false;
    private boolean allowRedirectsOnPosts;
    private int retries = 1;
    private int redirectOnPostsTries = 5;
    private long retryInterval = -1L;
    private RetryOn retryOn = RetryOn.DEFAULT;
    private boolean ignoreErrors;
    private boolean byLines = false;
    private TeeWriter writers = new TeeWriter(new Writer[0]);
    private StringWriter capturedResponseWriter;
    private String capturedResponse;
    private TeeOutputStream outputStreams = new TeeOutputStream(new OutputStream[0]);
    private boolean isClosed = false;
    private boolean isFailed = false;

    protected RestCall(RestClient client, HttpRequestBase request) throws RestCallException {
        this.client = client;
        this.request = request;
        for (RestCallInterceptor i : this.client.interceptors) {
            this.addInterceptor(i);
        }
    }

    public RestCall setInput(Object input) throws RestCallException {
        if (!(this.request instanceof HttpEntityEnclosingRequestBase)) {
            throw new RestCallException(0, "Method does not support content entity.", this.request.getMethod(), this.request.getURI(), null);
        }
        Object entity = input instanceof HttpEntity ? (HttpEntity)input : new RestRequestEntity(input, this.client.serializer);
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(entity);
        if (this.retries > 1 && !entity.isRepeatable()) {
            throw new RestCallException("Rest call set to retryable, but entity is not repeatable.");
        }
        return this;
    }

    public RestCall setHeader(String name, Object value) {
        this.request.setHeader(name, value.toString());
        return this;
    }

    public RestCall setRetryable(int retries, long interval, RetryOn retryOn) throws RestCallException {
        HttpEntity e;
        if (this.request instanceof HttpEntityEnclosingRequestBase && (e = ((HttpEntityEnclosingRequestBase)this.request).getEntity()) != null && !e.isRepeatable()) {
            throw new RestCallException("Attempt to make call retryable, but entity is not repeatable.");
        }
        this.retries = retries;
        this.retryInterval = interval;
        this.retryOn = retryOn == null ? RetryOn.DEFAULT : retryOn;
        return this;
    }

    public RestCall allowRedirectsOnPosts(boolean b) {
        this.allowRedirectsOnPosts = b;
        return this;
    }

    public RestCall setRedirectMaxAttempts(int maxAttempts) {
        this.redirectOnPostsTries = maxAttempts;
        return this;
    }

    public RestCall addInterceptor(RestCallInterceptor interceptor) {
        this.interceptors.add(interceptor);
        interceptor.onInit(this);
        return this;
    }

    public RestCall pipeTo(Writer w) {
        return this.pipeTo(w, false);
    }

    public RestCall pipeTo(Writer w, boolean close) {
        return this.pipeTo(null, w, close);
    }

    public RestCall pipeTo(String id, Writer w, boolean close) {
        this.writers.add(id, w, close);
        return this;
    }

    public Writer getWriter(String id) {
        return this.writers.getWriter(id);
    }

    public RestCall byLines() {
        this.byLines = true;
        return this;
    }

    public RestCall pipeTo(OutputStream os) {
        return this.pipeTo(os, false);
    }

    public RestCall pipeTo(OutputStream os, boolean close) {
        return this.pipeTo(null, os, close);
    }

    public RestCall pipeTo(String id, OutputStream os, boolean close) {
        this.outputStreams.add(id, os, close);
        return this;
    }

    public OutputStream getOutputStream(String id) {
        return this.outputStreams.getOutputStream(id);
    }

    public RestCall ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public RestCall captureResponse() {
        if (this.capturedResponseWriter == null) {
            this.capturedResponseWriter = new StringWriter();
            this.writers.add(this.capturedResponseWriter, false);
        }
        return this;
    }

    public RestCall failurePattern(String errorPattern) {
        this.addResponsePattern(new ResponsePattern(errorPattern){

            @Override
            public void onMatch(RestCall rc, Matcher m) throws RestCallException {
                throw new RestCallException("Failure pattern detected.");
            }
        });
        return this;
    }

    public RestCall successPattern(String successPattern) {
        this.addResponsePattern(new ResponsePattern(successPattern){

            @Override
            public void onNoMatch(RestCall rc) throws RestCallException {
                throw new RestCallException("Success pattern not detected.");
            }
        });
        return this;
    }

    public RestCall addResponsePattern(final ResponsePattern responsePattern) {
        this.captureResponse();
        this.addInterceptor(new RestCallInterceptor(){

            @Override
            public void onClose(RestCall restCall) throws RestCallException {
                responsePattern.match(RestCall.this);
            }
        });
        return this;
    }

    public RestCall setConfig(RequestConfig config) {
        this.request.setConfig(config);
        return this;
    }

    @Deprecated
    public int execute() throws RestCallException {
        return this.run();
    }

    public int run() throws RestCallException {
        this.connect();
        try {
            StatusLine status = this.response.getStatusLine();
            int sc = status.getStatusCode();
            if (sc >= 400 && !this.ignoreErrors) {
                throw new RestCallException(sc, status.getReasonPhrase(), this.request.getMethod(), this.request.getURI(), this.getResponseAsString()).setHttpResponse(this.response);
            }
            if (this.outputStreams.size() > 0 || this.writers.size() > 0) {
                this.getReader();
            }
            int n = sc;
            return n;
        }
        catch (RestCallException e) {
            this.isFailed = true;
            throw e;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw new RestCallException(e).setHttpResponse(this.response);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestCall connect() throws RestCallException {
        if (this.isConnected) {
            return this;
        }
        this.isConnected = true;
        try {
            int sc = 0;
            while (this.retries > 0) {
                Object ex;
                block21: {
                    --this.retries;
                    ex = null;
                    try {
                        this.response = this.client.execute((HttpUriRequest)this.request);
                        sc = this.response == null || this.response.getStatusLine() == null ? -1 : this.response.getStatusLine().getStatusCode();
                    }
                    catch (Exception e) {
                        ex = e;
                        sc = -1;
                        if (this.response == null) break block21;
                        EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
                    }
                }
                if (!this.retryOn.onCode(sc)) {
                    this.retries = 0;
                }
                if (this.retries > 0) {
                    for (RestCallInterceptor rci : this.interceptors) {
                        rci.onRetry(this, sc, (HttpRequest)this.request, this.response, (Exception)ex);
                    }
                    this.request.reset();
                    long w = this.retryInterval;
                    RestCall restCall = this;
                    synchronized (restCall) {
                        this.wait(w);
                        continue;
                    }
                }
                if (ex == null) continue;
                throw ex;
            }
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(this, sc, (HttpRequest)this.request, this.response);
            }
            if (this.response == null) {
                throw new RestCallException("HttpClient returned a null response");
            }
            StatusLine sl = this.response.getStatusLine();
            String method = this.request.getMethod();
            sc = sl.getStatusCode();
            if (sc >= 400 && !this.ignoreErrors) {
                throw new RestCallException(sc, sl.getReasonPhrase(), method, this.request.getURI(), this.getResponseAsString()).setHttpResponse(this.response);
            }
            if ((sc == 307 || sc == 302) && this.allowRedirectsOnPosts && method.equalsIgnoreCase("POST")) {
                if (this.redirectOnPostsTries-- < 1) {
                    throw new RestCallException(sc, "Maximum number of redirects occurred.  Location header: " + this.response.getFirstHeader("Location"), method, this.request.getURI(), this.getResponseAsString());
                }
                Header h = this.response.getFirstHeader("Location");
                if (h != null) {
                    this.reset();
                    this.request.setURI(URI.create(h.getValue()));
                    ++this.retries;
                    this.connect();
                }
            }
        }
        catch (RestCallException e) {
            this.isFailed = true;
            try {
                this.close();
            }
            catch (RestCallException restCallException) {
                // empty catch block
            }
            throw e;
        }
        catch (Exception e) {
            this.isFailed = true;
            this.close();
            throw new RestCallException(e).setHttpResponse(this.response);
        }
        return this;
    }

    private void reset() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        this.request.reset();
        this.isConnected = false;
        this.isClosed = false;
        this.isFailed = false;
        if (this.capturedResponseWriter != null) {
            this.capturedResponseWriter.getBuffer().setLength(0);
        }
    }

    public Reader getReader() throws IOException {
        String ct;
        InputStream is = this.getInputStream();
        if (is == null) {
            return null;
        }
        String cs = null;
        Header contentType = this.response.getLastHeader("Content-Type");
        String string = ct = contentType == null ? null : contentType.getValue();
        if (ct != null && ct.contains("charset=")) {
            cs = ct.substring(ct.indexOf("charset=") + 8).trim();
        }
        if (cs == null) {
            cs = "UTF-8";
        }
        InputStreamReader isr = new InputStreamReader(is, cs);
        if (this.writers.size() > 0) {
            StringWriter sw = new StringWriter();
            this.writers.add(sw, true);
            IOPipe.create(isr, this.writers).byLines(this.byLines).run();
            return new StringReader(sw.toString());
        }
        return new InputStreamReader(is, cs);
    }

    public String getCapturedResponse() {
        if (!this.isClosed) {
            throw new IllegalStateException("This method cannot be called until the response has been consumed.");
        }
        if (this.capturedResponse == null && this.capturedResponseWriter != null && this.capturedResponseWriter.getBuffer().length() > 0) {
            this.capturedResponse = this.capturedResponseWriter.toString();
        }
        return this.capturedResponse;
    }

    protected Parser getParser() throws RestCallException {
        if (this.client.parser == null) {
            throw new RestCallException(0, "No parser defined on client", this.request.getMethod(), this.request.getURI(), null);
        }
        return this.client.parser;
    }

    protected Serializer getSerializer() throws RestCallException {
        if (this.client.serializer == null) {
            throw new RestCallException(0, "No serializer defined on client", this.request.getMethod(), this.request.getURI(), null);
        }
        return this.client.serializer;
    }

    public int getContentLength() throws IOException {
        this.connect();
        Header h = this.response.getLastHeader("Content-Length");
        if (h == null) {
            return -1;
        }
        long l = Long.parseLong(h.getValue());
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Method cannot be called.  Response has already been consumed.");
        }
        this.connect();
        if (this.response == null) {
            throw new RestCallException("Response was null");
        }
        if (this.response.getEntity() == null) {
            return null;
        }
        InputStream is = this.response.getEntity().getContent();
        if (this.outputStreams.size() > 0) {
            ByteArrayInOutStream baios = new ByteArrayInOutStream();
            this.outputStreams.add(baios, true);
            IOPipe.create(is, baios).run();
            return baios.getInputStream();
        }
        return is;
    }

    public String getResponseAsString() throws IOException {
        try {
            String s;
            Reader r = this.getReader();
            String string = s = IOUtils.read(r).toString();
            return string;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw e;
        }
        finally {
            this.close();
        }
    }

    public <T> T getResponse(Class<T> type) throws IOException, ParseException {
        BeanContext bc = this.getParser().getBeanContext();
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return this.getResponse(bc.getClassMeta(type));
    }

    public PojoRest getResponsePojoRest(Class<?> innerType) throws IOException, ParseException {
        return new PojoRest(this.getResponse(innerType));
    }

    public PojoRest getResponsePojoRest() throws IOException, ParseException {
        return this.getResponsePojoRest(ObjectMap.class);
    }

    public final <K, V, T extends Map<K, V>> T getResponseMap(Class<T> mapClass, Class<K> keyClass, Class<V> valueClass) throws ParseException, IOException {
        ClassMeta<T> cm = this.getBeanContext().getMapClassMeta(mapClass, keyClass, valueClass);
        return (T)((Map)this.getResponse(cm));
    }

    public final <E, T extends Collection<E>> T getResponseCollection(Class<T> collectionClass, Class<E> entryClass) throws ParseException, IOException {
        ClassMeta<T> cm = this.getBeanContext().getCollectionClassMeta(collectionClass, entryClass);
        return (T)((Collection)this.getResponse(cm));
    }

    <T> T getResponse(ClassMeta<T> type) throws IOException, ParseException {
        try {
            Parser p = this.getParser();
            T o = null;
            if (!p.isReaderParser()) {
                InputStream is = this.getInputStream();
                o = ((InputStreamParser)p).parse((Object)is, type);
            } else {
                Reader r = this.getReader();
                o = ((ReaderParser)p).parse((Object)r, type);
            }
            T t = o;
            return t;
        }
        catch (ParseException e) {
            this.isFailed = true;
            throw e;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw e;
        }
        finally {
            this.close();
        }
    }

    BeanContext getBeanContext() throws RestCallException {
        BeanContext bc = this.getParser().getBeanContext();
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return bc;
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() throws IOException {
        this.connect();
        return this.response;
    }

    public RestCall setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    @Deprecated
    public void consumeResponse() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
    }

    public RestCall close() throws RestCallException {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        this.isClosed = true;
        if (!this.isFailed) {
            for (RestCallInterceptor r : this.interceptors) {
                r.onClose(this);
            }
        }
        return this;
    }

    public RestCall logTo(Level level, Logger log) {
        this.addInterceptor(new RestCallLogger(level, log));
        return this;
    }
}

