/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class MediaRange
implements Comparable<MediaRange> {
    private final String type;
    private final String subType;
    private final Float qValue;
    private final Map<String, Set<String>> parameters;
    private final Map<String, Set<String>> extensions;

    public String getMediaType() {
        return this.type + "/" + this.subType;
    }

    public String getType() {
        return this.type;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public Map<String, Set<String>> getParameters() {
        return this.parameters;
    }

    public Map<String, Set<String>> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        StringBuffer sb;
        block8: {
            String k;
            block7: {
                sb = new StringBuffer().append(this.type).append('/').append(this.subType);
                if (!this.parameters.isEmpty()) {
                    for (Map.Entry<String, Set<String>> e : this.parameters.entrySet()) {
                        k = e.getKey();
                        for (String v : e.getValue()) {
                            sb.append(';').append(k).append('=').append(v);
                        }
                    }
                }
                if ((double)this.qValue.floatValue() != 1.0) break block7;
                if (this.extensions.isEmpty()) break block8;
                sb.append(";q=").append(this.qValue);
                for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                    k = e.getKey();
                    for (String v : e.getValue()) {
                        sb.append(';').append(k).append('=').append(v);
                    }
                }
                break block8;
            }
            sb.append(";q=").append(this.qValue);
            for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                k = e.getKey();
                for (String v : e.getValue()) {
                    sb.append(';').append(k).append('=').append(v);
                }
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MediaRange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        MediaRange o2 = (MediaRange)o;
        return this.qValue.equals(o2.qValue) && this.type.equals(o2.type) && this.subType.equals(o2.subType) && this.parameters.equals(o2.parameters) && this.extensions.equals(o2.extensions);
    }

    public int hashCode() {
        return this.type.hashCode() + this.subType.hashCode();
    }

    private MediaRange(String type, String subType, Map<String, Set<String>> parameters, Float qValue, Map<String, Set<String>> extensions) {
        this.type = type;
        this.subType = subType;
        this.parameters = parameters == null ? new TreeMap() : parameters;
        this.extensions = extensions == null ? new TreeMap() : extensions;
        this.qValue = qValue;
    }

    public static MediaRange[] parse(String value) {
        TreeSet<MediaRange> ranges = new TreeSet<MediaRange>();
        if (value == null || value.length() == 0) {
            return new MediaRange[]{new MediaRange("*", "*", null, Float.valueOf(1.0f), null)};
        }
        value = value.toLowerCase(Locale.ENGLISH);
        for (String r : value.trim().split("\\s*,\\s*")) {
            String subType;
            if ((r = r.trim()).isEmpty()) continue;
            String[] tokens = r.split("\\s*;\\s*");
            tokens[0] = tokens[0].replace(' ', '+');
            String[] t = tokens[0].split("/");
            String type = t[0];
            String string = subType = t.length == 1 ? "*" : t[1];
            if (tokens.length == 1) {
                ranges.add(new MediaRange(type, subType, null, Float.valueOf(1.0f), null));
                continue;
            }
            Float qValue = Float.valueOf(1.0f);
            TreeMap<String, Set<String>> params = new TreeMap<String, Set<String>>();
            TreeMap<String, Set<String>> exts = new TreeMap<String, Set<String>>();
            boolean isInExtensions = false;
            for (int i = 1; i < tokens.length; ++i) {
                String[] parm = tokens[i].split("\\s*=\\s*");
                if (parm.length != 2) continue;
                String k = parm[0];
                String v = parm[1];
                if (isInExtensions) {
                    if (!exts.containsKey(parm[0])) {
                        exts.put(parm[0], new TreeSet());
                    }
                    ((Set)exts.get(parm[0])).add(parm[1]);
                    continue;
                }
                if (k.equals("q")) {
                    qValue = new Float(v);
                    isInExtensions = true;
                    continue;
                }
                if (!params.containsKey(parm[0])) {
                    params.put(parm[0], new TreeSet());
                }
                ((Set)params.get(parm[0])).add(parm[1]);
            }
            ranges.add(new MediaRange(type, subType, params, qValue, exts));
        }
        return ranges.toArray(new MediaRange[ranges.size()]);
    }

    @Override
    public int compareTo(MediaRange o) {
        int qCompare = Float.compare(o.qValue.floatValue(), this.qValue.floatValue());
        if (qCompare != 0) {
            return qCompare;
        }
        int i = o.type.compareTo(this.type);
        if (i == 0) {
            i = o.subType.compareTo(this.subType);
        }
        return i;
    }

    public boolean matches(MediaRange o) {
        if (this == o) {
            return true;
        }
        if (this.qValue.floatValue() == 0.0f || o.qValue.floatValue() == 0.0f) {
            return false;
        }
        return !(!this.type.equals(o.type) && !this.type.equals("*") && !o.type.equals("*") || !this.subType.equals(o.subType) && !this.subType.equals("*") && !o.subType.equals("*"));
    }
}

