/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.Lockable;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectMap;

public abstract class CoreApi
extends Lockable {
    private ContextFactory contextFactory = ContextFactory.create();
    private BeanContext beanContext;

    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public BeanContext getBeanContext() {
        if (this.beanContext == null) {
            return this.contextFactory.getContext(BeanContext.class);
        }
        return this.beanContext;
    }

    protected final <T extends Context> T getContext(Class<T> contextClass) {
        return this.contextFactory.getContext(contextClass);
    }

    public CoreApi setProperty(String property, Object value) throws LockedException {
        this.checkLock();
        this.contextFactory.setProperty(property, value);
        return this;
    }

    public CoreApi setProperties(ObjectMap properties) throws LockedException {
        this.checkLock();
        this.contextFactory.setProperties(properties);
        return this;
    }

    public CoreApi addNotBeanClasses(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.contextFactory.addNotBeanClasses(classes);
        return this;
    }

    public CoreApi addBeanFilters(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.contextFactory.addBeanFilters(classes);
        return this;
    }

    public CoreApi addPojoSwaps(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.contextFactory.addPojoSwaps(classes);
        return this;
    }

    public CoreApi addToDictionary(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.contextFactory.addToDictionary(classes);
        return this;
    }

    public <T> CoreApi addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        this.checkLock();
        this.contextFactory.addImplClass(interfaceClass, implClass);
        return this;
    }

    public CoreApi setClassLoader(ClassLoader classLoader) throws LockedException {
        this.checkLock();
        this.contextFactory.setClassLoader(classLoader);
        return this;
    }

    public ClassMeta<Object> object() {
        return this.getBeanContext().object();
    }

    public ClassMeta<String> string() {
        return this.getBeanContext().string();
    }

    @Override
    public void checkLock() {
        super.checkLock();
        this.beanContext = null;
    }

    @Override
    public CoreApi lock() {
        try {
            super.lock();
            this.contextFactory = this.contextFactory.clone();
            this.contextFactory.lock();
            this.beanContext = this.contextFactory.getContext(BeanContext.class);
            return this;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CoreApi clone() throws CloneNotSupportedException {
        CoreApi c = (CoreApi)super.clone();
        c.contextFactory = ContextFactory.create(this.contextFactory);
        c.beanContext = null;
        return c;
    }
}

