/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.Lockable;
import org.apache.juneau.LockedException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ReaderParser;

public final class ContextFactory
extends Lockable {
    private Map<String, PropertyMap> properties = new ConcurrentSkipListMap<String, PropertyMap>();
    private final Map<Class<? extends Context>, Context> contexts = new ConcurrentHashMap<Class<? extends Context>, Context>();
    private static final ConcurrentHashMap<Integer, ConcurrentHashMap<Class<? extends Context>, Context>> globalContextCache = new ConcurrentHashMap();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock rl = this.lock.readLock();
    private Lock wl = this.lock.writeLock();
    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    ReaderParser defaultParser;
    private static Comparator<Object> PROPERTY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ContextFactory.unswap(o1).toString().compareTo(ContextFactory.unswap(o2).toString());
        }
    };

    public static ContextFactory create() {
        ContextFactory f = new ContextFactory();
        BeanContext.loadDefaults(f);
        return f;
    }

    public static ContextFactory create(ContextFactory copyFrom) {
        return new ContextFactory().copyFrom(copyFrom);
    }

    ContextFactory() {
    }

    public ContextFactory(ContextFactory copyFrom) {
        this.copyFrom(copyFrom);
    }

    public ContextFactory copyFrom(ContextFactory cf) {
        for (Map.Entry<String, PropertyMap> e : cf.properties.entrySet()) {
            this.properties.put(e.getKey(), new PropertyMap(e.getValue()));
        }
        this.classLoader = cf.classLoader;
        this.defaultParser = cf.defaultParser;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFactory setProperty(String name, Object value) {
        String prefix = this.prefix(name);
        if (name.endsWith(".add")) {
            return this.addToProperty(name.substring(0, name.lastIndexOf(46)), value);
        }
        if (name.endsWith(".put")) {
            return this.putToProperty(name.substring(0, name.lastIndexOf(46)), value);
        }
        if (name.endsWith(".remove")) {
            return this.removeFromProperty(name.substring(0, name.lastIndexOf(46)), value);
        }
        this.wl.lock();
        try {
            this.checkLock();
            this.contexts.clear();
            if (!this.properties.containsKey(prefix)) {
                this.properties.put(prefix, new PropertyMap(prefix));
            }
            this.properties.get(prefix).set(name, value);
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFactory setProperties(Map newProperties) {
        this.wl.lock();
        try {
            this.checkLock();
            this.contexts.clear();
            for (Map.Entry e : newProperties.entrySet()) {
                String name = e.getKey().toString();
                Object value = e.getValue();
                String prefix = this.prefix(name);
                if (name.endsWith(".add")) {
                    this.addToProperty(name.substring(0, name.lastIndexOf(46)), value);
                    continue;
                }
                if (name.endsWith(".remove")) {
                    this.removeFromProperty(name.substring(0, name.lastIndexOf(46)), value);
                    continue;
                }
                if (!this.properties.containsKey(prefix)) {
                    this.properties.put(prefix, new PropertyMap(prefix));
                }
                this.properties.get(prefix).set(name, value);
            }
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFactory addToProperty(String name, Object value) {
        String prefix = this.prefix(name);
        this.wl.lock();
        try {
            this.checkLock();
            this.contexts.clear();
            if (!this.properties.containsKey(prefix)) {
                this.properties.put(prefix, new PropertyMap(prefix));
            }
            this.properties.get(prefix).addTo(name, value);
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFactory putToProperty(String name, Object key, Object value) {
        String prefix = this.prefix(name);
        this.wl.lock();
        try {
            this.checkLock();
            this.contexts.clear();
            if (!this.properties.containsKey(prefix)) {
                this.properties.put(prefix, new PropertyMap(prefix));
            }
            this.properties.get(prefix).putTo(name, key, value);
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFactory putToProperty(String name, Object value) {
        String prefix = this.prefix(name);
        this.wl.lock();
        try {
            this.checkLock();
            this.contexts.clear();
            if (!this.properties.containsKey(prefix)) {
                this.properties.put(prefix, new PropertyMap(prefix));
            }
            this.properties.get(prefix).putTo(name, value);
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFactory removeFromProperty(String name, Object value) {
        String prefix = this.prefix(name);
        this.wl.lock();
        try {
            this.checkLock();
            this.contexts.clear();
            if (this.properties.containsKey(prefix)) {
                this.properties.get(prefix).removeFrom(name, value);
            }
        }
        finally {
            this.wl.unlock();
        }
        return this;
    }

    public <T extends Context> T getContext(Class<T> c) {
        this.rl.lock();
        try {
            Object key;
            if (!this.contexts.containsKey(c)) {
                ConcurrentHashMap<Class<? extends Context>, Context> cacheForThisConfig;
                key = this.hashCode();
                if (!globalContextCache.containsKey(key)) {
                    globalContextCache.putIfAbsent((Integer)key, new ConcurrentHashMap());
                }
                if (!(cacheForThisConfig = globalContextCache.get(key)).containsKey(c)) {
                    cacheForThisConfig.putIfAbsent((Class<? extends Context>)c, (Context)c.getConstructor(ContextFactory.class).newInstance(this));
                }
                this.contexts.put(c, cacheForThisConfig.get(c));
            }
            key = this.contexts.get(c);
            return (T)key;
        }
        catch (Exception e) {
            throw new ConfigException("Could not instantiate config class ''{0}''", this.className(c)).initCause(e);
        }
        finally {
            this.rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyMap getPropertyMap(String prefix) {
        this.rl.lock();
        try {
            PropertyMap m = this.properties.get(prefix);
            PropertyMap propertyMap = m == null ? new PropertyMap(prefix) : m;
            return propertyMap;
        }
        finally {
            this.rl.unlock();
        }
    }

    public ContextFactory setClassLoader(ClassLoader classLoader) {
        this.checkLock();
        this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        return this;
    }

    public ContextFactory setDefaultParser(ReaderParser defaultParser) {
        this.checkLock();
        this.defaultParser = defaultParser == null ? JsonParser.DEFAULT : defaultParser;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getProperty(String name, Class<T> type, T def) {
        this.rl.lock();
        try {
            PropertyMap pm = this.getPropertyMap(this.prefix(name));
            if (pm != null) {
                T t = pm.get(name, type, def);
                return t;
            }
            String s = System.getProperty(name);
            if (!StringUtils.isEmpty(s)) {
                T t = BeanContext.DEFAULT.convertToType((Object)s, type);
                return t;
            }
            T t = def;
            return t;
        }
        finally {
            this.rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Map<K, V> getMap(String name, Class<K> keyType, Class<V> valType, Map<K, V> def) {
        this.rl.lock();
        try {
            PropertyMap pm = this.getPropertyMap(this.prefix(name));
            if (pm != null) {
                Map<K, V> map = pm.getMap(name, keyType, valType, def);
                return map;
            }
            Map<K, V> map = def;
            return map;
        }
        finally {
            this.rl.unlock();
        }
    }

    public BeanContext getBeanContext() {
        return this.getContext(BeanContext.class);
    }

    public ContextFactory addNotBeanClasses(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.addToProperty("BeanContext.notBeanClasses.set", classes);
        return this;
    }

    public ContextFactory addBeanFilters(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.addToProperty("BeanContext.beanFilters.list", classes);
        return this;
    }

    public ContextFactory addPojoSwaps(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.addToProperty("BeanContext.pojoSwaps.list", classes);
        return this;
    }

    public ContextFactory addToDictionary(Class<?> ... classes) throws LockedException {
        this.checkLock();
        this.addToProperty("BeanContext.beanDictionary.list", classes);
        return this;
    }

    public <T> ContextFactory addImplClass(Class<T> interfaceClass, Class<? extends T> implClass) throws LockedException {
        this.checkLock();
        this.putToProperty("BeanContext.implClasses.map", interfaceClass, implClass);
        return this;
    }

    public int hashCode() {
        HashCode c = new HashCode();
        for (PropertyMap m : this.properties.values()) {
            c.add(m);
        }
        return c.get();
    }

    private static final Object unswap(Object o) {
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Number || o instanceof Boolean) {
            return o.toString();
        }
        return o;
    }

    private static boolean same(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof Map) {
            if (o2 instanceof Map) {
                Map m1 = (Map)o1;
                Map m2 = (Map)o2;
                if (m1.size() == m2.size()) {
                    Set s1 = m1.entrySet();
                    Set s2 = m2.entrySet();
                    Iterator i1 = s1.iterator();
                    Iterator i2 = s2.iterator();
                    while (i1.hasNext()) {
                        Map.Entry e1 = i1.next();
                        Map.Entry e2 = i2.next();
                        if (!ContextFactory.same(e1.getKey(), e2.getKey())) {
                            return false;
                        }
                        if (ContextFactory.same(e1.getValue(), e2.getValue())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (o1 instanceof Collection) {
            if (o2 instanceof Collection) {
                Collection c1 = (Collection)o1;
                Collection c2 = (Collection)o2;
                if (c1.size() == c2.size()) {
                    Iterator i1 = c1.iterator();
                    Iterator i2 = c2.iterator();
                    while (i1.hasNext()) {
                        if (ContextFactory.same(i1.next(), i2.next())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        return ContextFactory.unswap(o1).equals(ContextFactory.unswap(o2));
    }

    private String prefix(String name) {
        if (name == null) {
            throw new ConfigException("Invalid property name specified: 'null'", new Object[0]);
        }
        if (name.indexOf(46) == -1) {
            return "";
        }
        return name.substring(0, name.indexOf(46));
    }

    private String className(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Class) {
            return ClassUtils.getReadableClassName((Class)o);
        }
        return ClassUtils.getReadableClassName(o.getClass());
    }

    public String toString() {
        this.rl.lock();
        try {
            ObjectMap m = new ObjectMap();
            m.put("id", System.identityHashCode(this));
            m.put("hashCode", this.hashCode());
            m.put("properties.id", System.identityHashCode(this.properties));
            m.put("contexts.id", System.identityHashCode(this.contexts));
            m.put("properties", this.properties);
            m.put("contexts", this.contexts);
            String string = m.toString();
            return string;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public ContextFactory clone() throws CloneNotSupportedException {
        this.rl.lock();
        try {
            ContextFactory contextFactory = new ContextFactory(this);
            return contextFactory;
        }
        finally {
            this.rl.unlock();
        }
    }

    private static class MapProperty
    extends Property {
        final Map<Object, Object> value = (Map)this.value();

        MapProperty(String name, Object value) {
            super(name, "MAP", Collections.synchronizedMap(new TreeMap(PROPERTY_COMPARATOR)));
            this.put(value);
        }

        @Override
        void put(Object val) {
            try {
                if (BeanContext.DEFAULT != null && !(val instanceof Map)) {
                    val = BeanContext.DEFAULT.convertToType(val, Map.class);
                }
                if (val instanceof Map) {
                    Map m = (Map)val;
                    for (Map.Entry e : m.entrySet()) {
                        this.put(e.getKey(), e.getValue());
                    }
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.put(val);
        }

        @Override
        void put(Object key, Object val) {
            for (Map.Entry<Object, Object> e : this.value.entrySet()) {
                if (!ContextFactory.same(e.getKey(), key)) continue;
                e.setValue(val);
                return;
            }
            this.value.put(key, val);
        }
    }

    private static class ListProperty
    extends Property {
        private final LinkedList<Object> value = (LinkedList)this.value();

        private ListProperty(String name, Object value) {
            super(name, "LIST", new LinkedList());
            this.add(value);
        }

        @Override
        void add(Object val) {
            if (val.getClass().isArray()) {
                for (int i = Array.getLength(val) - 1; i >= 0; --i) {
                    this.add(Array.get(val, i));
                }
            } else if (val instanceof List) {
                List l = (List)val;
                ListIterator i = l.listIterator(l.size());
                while (i.hasPrevious()) {
                    this.add(i.previous());
                }
            } else if (val instanceof Collection) {
                ArrayList l = new ArrayList((Collection)val);
                ListIterator i = l.listIterator(l.size());
                while (i.hasPrevious()) {
                    this.add(i.previous());
                }
            } else {
                String s = val.toString();
                if (s.startsWith("[") && s.endsWith("]")) {
                    try {
                        this.add(new ObjectList(s));
                        return;
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                Iterator i = this.value.iterator();
                while (i.hasNext()) {
                    if (!ContextFactory.same(val, i.next())) continue;
                    i.remove();
                }
                this.value.addFirst(val);
            }
        }

        @Override
        void remove(Object val) {
            if (val.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(val); ++i) {
                    this.remove(Array.get(val, i));
                }
            } else if (val instanceof Collection) {
                for (Object o : (Collection)val) {
                    this.remove(o);
                }
            } else {
                String s = val.toString();
                if (s.startsWith("[") && s.endsWith("]")) {
                    try {
                        this.remove(new ObjectList(s));
                        return;
                    }
                    catch (Exception o) {
                        // empty catch block
                    }
                }
                Iterator i = this.value.iterator();
                while (i.hasNext()) {
                    if (!ContextFactory.same(i.next(), val)) continue;
                    i.remove();
                }
            }
        }
    }

    private static class SetProperty
    extends Property {
        private final Set<Object> value = (Set)this.value();

        private SetProperty(String name, Object value) {
            super(name, "SET", new ConcurrentSkipListSet(PROPERTY_COMPARATOR));
            this.add(value);
        }

        @Override
        void add(Object val) {
            if (val.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(val); ++i) {
                    this.add(Array.get(val, i));
                }
            } else if (val instanceof Collection) {
                for (Object o : (Collection)val) {
                    this.add(o);
                }
            } else {
                String s;
                if (val instanceof String && (s = val.toString()).startsWith("[") && s.endsWith("]")) {
                    try {
                        this.add(new ObjectList(s));
                        return;
                    }
                    catch (Exception o) {
                        // empty catch block
                    }
                }
                for (Object o : this.value) {
                    if (!ContextFactory.same(val, o)) continue;
                    return;
                }
                this.value.add(val);
            }
        }

        @Override
        void remove(Object val) {
            if (val.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(val); ++i) {
                    this.remove(Array.get(val, i));
                }
            } else if (val instanceof Collection) {
                for (Object o : (Collection)val) {
                    this.remove(o);
                }
            } else {
                String s;
                if (val instanceof String && (s = val.toString()).startsWith("[") && s.endsWith("]")) {
                    try {
                        this.remove(new ObjectList(s));
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Iterator<Object> i = this.value.iterator();
                while (i.hasNext()) {
                    if (!ContextFactory.same(i.next(), val)) continue;
                    i.remove();
                }
            }
        }
    }

    private static class SimpleProperty
    extends Property {
        SimpleProperty(String name, Object value) {
            super(name, "SIMPLE", value);
        }
    }

    private static abstract class Property {
        private final String name;
        private final String type;
        private final Object value;

        private static Property create(String name, Object value) {
            if (name.endsWith(".set")) {
                return new SetProperty(name, value);
            }
            if (name.endsWith(".list")) {
                return new ListProperty(name, value);
            }
            if (name.endsWith(".map")) {
                return new MapProperty(name, value);
            }
            return new SimpleProperty(name, value);
        }

        Property(String name, String type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        void add(Object val) {
            throw new ConfigException("Cannot add value {0} ({1}) to property ''{2}'' ({3}).", JsonSerializer.DEFAULT_LAX.toString(val), ClassUtils.getReadableClassNameForObject(val), this.name, this.type);
        }

        void remove(Object val) {
            throw new ConfigException("Cannot remove value {0} ({1}) from property ''{2}'' ({3}).", JsonSerializer.DEFAULT_LAX.toString(val), ClassUtils.getReadableClassNameForObject(val), this.name, this.type);
        }

        void put(Object val) {
            throw new ConfigException("Cannot put value {0} ({1}) to property ''{2}'' ({3}).", JsonSerializer.DEFAULT_LAX.toString(val), ClassUtils.getReadableClassNameForObject(val), this.name, this.type);
        }

        void put(Object key, Object val) {
            throw new ConfigException("Cannot put value {0}({1})->{2}({3}) to property ''{4}'' ({5}).", JsonSerializer.DEFAULT_LAX.toString(key), ClassUtils.getReadableClassNameForObject(key), JsonSerializer.DEFAULT_LAX.toString(val), ClassUtils.getReadableClassNameForObject(val), this.name, this.type);
        }

        protected Object value() {
            return this.value;
        }

        public int hashCode() {
            HashCode c = new NormalizingHashCode().add(this.name);
            if (this.value instanceof Map) {
                for (Map.Entry e : ((Map)this.value).entrySet()) {
                    c.add(e.getKey()).add(e.getValue());
                }
            } else if (this.value instanceof Collection) {
                for (Object o : (Collection)this.value) {
                    c.add(o);
                }
            } else {
                c.add(this.value);
            }
            return c.get();
        }

        public String toString() {
            return "Property(name=" + this.name + ",type=" + this.type + ")";
        }
    }

    public class PropertyMap {
        private final Map<String, Property> map = new ConcurrentSkipListMap<String, Property>();
        private volatile int hashCode = 0;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock rl = this.lock.readLock();
        private final Lock wl = this.lock.writeLock();
        private final String prefix;

        private PropertyMap(String prefix) {
            this.prefix = prefix;
            prefix = prefix + '.';
            Properties p = System.getProperties();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                if (!e.getKey().toString().startsWith(prefix)) continue;
                this.set(e.getKey().toString(), e.getValue());
            }
        }

        private PropertyMap(PropertyMap orig) {
            this.prefix = orig.prefix;
            for (Map.Entry<String, Property> e : orig.map.entrySet()) {
                this.map.put(e.getKey(), Property.create(e.getValue().name, e.getValue().value()));
            }
        }

        public <T> T get(String name, Class<T> type, T def) {
            this.rl.lock();
            try {
                Property p = this.map.get(name);
                if (p == null || type == null) {
                    T t = def;
                    return t;
                }
                if (BeanContext.DEFAULT == null) {
                    T t = def;
                    return t;
                }
                T t = BeanContext.DEFAULT.convertToType(p.value, type);
                return t;
            }
            finally {
                this.rl.unlock();
            }
        }

        public <K, V> Map<K, V> getMap(String name, Class<K> keyType, Class<V> valueType, Map<K, V> def) {
            this.rl.lock();
            try {
                Property p = this.map.get(name);
                if (p == null || keyType == null || valueType == null) {
                    Map<K, V> map = def;
                    return map;
                }
                BeanContext bc = BeanContext.DEFAULT;
                if (bc != null) {
                    Map map = bc.convertToType(p.value, bc.getMapClassMeta(LinkedHashMap.class, keyType, valueType));
                    return map;
                }
                Map<K, V> map = def;
                return map;
            }
            finally {
                this.rl.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> asMap() {
            this.rl.lock();
            try {
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                for (Property p : this.map.values()) {
                    m.put(p.name, p.value);
                }
                LinkedHashMap<String, Object> linkedHashMap = m;
                return linkedHashMap;
            }
            finally {
                this.rl.unlock();
            }
        }

        private void set(String name, Object value) {
            this.wl.lock();
            this.hashCode = 0;
            try {
                if (value == null) {
                    this.map.remove(name);
                } else {
                    this.map.put(name, Property.create(name, value));
                }
            }
            finally {
                this.wl.unlock();
            }
        }

        private void addTo(String name, Object value) {
            this.wl.lock();
            this.hashCode = 0;
            try {
                if (!this.map.containsKey(name)) {
                    this.map.put(name, Property.create(name, Collections.emptyList()));
                }
                this.map.get(name).add(value);
            }
            finally {
                this.wl.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putTo(String name, Object key, Object value) {
            this.wl.lock();
            this.hashCode = 0;
            try {
                if (!this.map.containsKey(name)) {
                    this.map.put(name, Property.create(name, Collections.emptyMap()));
                }
                this.map.get(name).put(key, value);
            }
            finally {
                this.wl.unlock();
            }
        }

        private void putTo(String name, Object value) {
            this.wl.lock();
            this.hashCode = 0;
            try {
                if (!this.map.containsKey(name)) {
                    this.map.put(name, Property.create(name, Collections.emptyMap()));
                }
                this.map.get(name).put(value);
            }
            finally {
                this.wl.unlock();
            }
        }

        private void removeFrom(String name, Object value) {
            this.wl.lock();
            this.hashCode = 0;
            try {
                if (this.map.containsKey(name)) {
                    this.map.get(name).remove(value);
                }
            }
            finally {
                this.wl.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            this.rl.lock();
            try {
                if (this.hashCode == 0) {
                    HashCode c = new HashCode().add(this.prefix);
                    for (Property p : this.map.values()) {
                        c.add(p);
                    }
                    this.hashCode = c.get();
                }
                int n = this.hashCode;
                return n;
            }
            finally {
                this.rl.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            this.rl.lock();
            try {
                if (o instanceof PropertyMap) {
                    PropertyMap m = (PropertyMap)o;
                    if (m.hashCode() != this.hashCode()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = this.map.equals(m.map);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.rl.unlock();
            }
        }

        public String toString() {
            return "PropertyMap(id=" + System.identityHashCode(this) + ")";
        }
    }

    private static class NormalizingHashCode
    extends HashCode {
        private NormalizingHashCode() {
        }

        @Override
        protected Object unswap(Object o) {
            return ContextFactory.unswap(o);
        }
    }
}

