/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanProxyInvocationHandler;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.annotation.Pojo;
import org.apache.juneau.annotation.Remoteable;
import org.apache.juneau.annotation.URI;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.transform.AnnotationBeanFilterBuilder;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.MetadataMap;

@Bean(properties="innerClass,classCategory,elementType,keyType,valueType,notABeanReason,initException,beanMeta")
public final class ClassMeta<T>
implements Type {
    final BeanContext beanContext;
    ClassCategory classCategory = ClassCategory.UNKNOWN;
    final Class<T> innerClass;
    ClassMeta<?> serializedClassMeta;
    ClassMeta<?> elementType = null;
    ClassMeta<?> keyType = null;
    ClassMeta<?> valueType = null;
    InvocationHandler invocationHandler;
    volatile BeanMeta<T> beanMeta;
    Method fromStringMethod;
    Constructor<? extends T> noArgConstructor;
    Constructor<T> stringConstructor;
    Constructor<T> numberConstructor;
    Class<? extends Number> numberConstructorType;
    Constructor<T> objectMapConstructor;
    Method toObjectMapMethod;
    Method namePropertyMethod;
    Method parentPropertyMethod;
    String notABeanReason;
    PojoSwap<T, ?> pojoSwap;
    BeanFilter beanFilter;
    boolean isDelegate;
    boolean isAbstract;
    boolean isMemberClass;
    private MetadataMap extMeta = new MetadataMap();
    private Throwable initException;
    private boolean hasChildPojoSwaps;
    private Object primitiveDefault;
    private Map<String, Method> remoteableMethods;
    private Map<String, Method> publicMethods;
    private static final Boolean BOOLEAN_DEFAULT = false;
    private static final Character CHARACTER_DEFAULT = Character.valueOf('\u0000');
    private static final Short SHORT_DEFAULT = 0;
    private static final Integer INTEGER_DEFAULT = 0;
    private static final Long LONG_DEFAULT = 0L;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Byte BYTE_DEFAULT = 0;

    ClassMeta(Class<T> innerClass, BeanContext beanContext) {
        this(innerClass, beanContext, false);
    }

    ClassMeta(Class<T> innerClass, BeanContext beanContext, boolean delayedInit) {
        this.innerClass = innerClass;
        this.beanContext = beanContext;
        if (!delayedInit) {
            this.init();
        }
    }

    ClassMeta init() {
        try {
            ClassMeta[] parameters;
            this.beanFilter = this.findBeanFilter(this.beanContext);
            this.pojoSwap = this.findPojoSwap(this.beanContext);
            ClassMeta<?> classMeta = this.serializedClassMeta = this.pojoSwap == null ? this : this.beanContext.getClassMeta(this.pojoSwap.getSwapClass());
            if (this.serializedClassMeta == null) {
                this.serializedClassMeta = this;
            }
            if (this.innerClass != Object.class) {
                this.noArgConstructor = this.beanContext.getImplClassConstructor(this.innerClass, Visibility.PUBLIC);
                if (this.noArgConstructor == null) {
                    this.noArgConstructor = ClassMeta.findNoArgConstructor(this.innerClass, Visibility.PUBLIC);
                }
            }
            this.hasChildPojoSwaps = this.beanContext.hasChildPojoSwaps(this.innerClass);
            Class<T> c = this.innerClass;
            if (c.isPrimitive()) {
                if (c == Boolean.TYPE) {
                    this.classCategory = ClassCategory.BOOLEAN;
                } else if (c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE) {
                    this.classCategory = c == Float.TYPE || c == Double.TYPE ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                } else if (c == Character.TYPE) {
                    this.classCategory = ClassCategory.CHAR;
                }
            } else {
                if (ClassUtils.isParentClass(Delegate.class, c)) {
                    this.isDelegate = true;
                }
                if (c == Object.class) {
                    this.classCategory = ClassCategory.OBJ;
                } else if (c.isEnum()) {
                    this.classCategory = ClassCategory.ENUM;
                } else if (c.equals(Class.class)) {
                    this.classCategory = ClassCategory.CLASS;
                } else if (ClassUtils.isParentClass(CharSequence.class, c)) {
                    this.classCategory = c.equals(String.class) ? ClassCategory.STR : ClassCategory.CHARSEQ;
                } else if (ClassUtils.isParentClass(Number.class, c)) {
                    this.classCategory = ClassUtils.isParentClass(Float.class, c) || ClassUtils.isParentClass(Double.class, c) ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                } else if (ClassUtils.isParentClass(Collection.class, c)) {
                    this.classCategory = ClassCategory.COLLECTION;
                } else if (ClassUtils.isParentClass(Map.class, c)) {
                    this.classCategory = ClassUtils.isParentClass(BeanMap.class, c) ? ClassCategory.BEANMAP : ClassCategory.MAP;
                } else if (c == Character.class) {
                    this.classCategory = ClassCategory.CHAR;
                } else if (c == Boolean.class) {
                    this.classCategory = ClassCategory.BOOLEAN;
                } else if (ClassUtils.isParentClass(Date.class, c) || ClassUtils.isParentClass(Calendar.class, c)) {
                    this.classCategory = ClassCategory.DATE;
                } else if (c.isArray()) {
                    this.classCategory = ClassCategory.ARRAY;
                } else if (ClassUtils.isParentClass(URL.class, c) || ClassUtils.isParentClass(java.net.URI.class, c) || c.isAnnotationPresent(URI.class)) {
                    this.classCategory = ClassCategory.URI;
                } else if (ClassUtils.isParentClass(Reader.class, c)) {
                    this.classCategory = ClassCategory.READER;
                } else if (ClassUtils.isParentClass(InputStream.class, c)) {
                    this.classCategory = ClassCategory.INPUTSTREAM;
                }
            }
            this.isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
            block5: for (String string : new String[]{"fromString", "valueOf", "parse", "parseString", "forName"}) {
                if (this.fromStringMethod != null) continue;
                for (Method m : c.getMethods()) {
                    Class<?>[] args;
                    String mName;
                    if (!ClassUtils.isStatic(m) || !ClassUtils.isPublic(m) || !ClassUtils.isNotDeprecated(m) || !(mName = m.getName()).equals(string) || m.getReturnType() != this.innerClass || (args = m.getParameterTypes()).length != 1 || args[0] != String.class) continue;
                    this.fromStringMethod = m;
                    continue block5;
                }
            }
            for (Method method : c.getMethods()) {
                String mName;
                if (!ClassUtils.isPublic(method) || !ClassUtils.isNotDeprecated(method) || ClassUtils.isStatic(method) || !(mName = method.getName()).equals("toObjectMap") || method.getParameterTypes().length != 0 || method.getReturnType() != ObjectMap.class) continue;
                this.toObjectMapMethod = method;
                break;
            }
            for (Method method : c.getDeclaredMethods()) {
                if (method.isAnnotationPresent(ParentProperty.class) && method.getParameterTypes().length == 1) {
                    method.setAccessible(true);
                    this.parentPropertyMethod = method;
                }
                if (!method.isAnnotationPresent(NameProperty.class) || method.getParameterTypes().length != 1) continue;
                method.setAccessible(true);
                this.namePropertyMethod = method;
            }
            Object[] objectArray = c.getConstructors();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?>[] args;
                Object object = objectArray[i];
                if (!ClassUtils.isPublic(object) || !ClassUtils.isNotDeprecated(object) || (args = ((Constructor)object).getParameterTypes()).length != (this.isMemberClass ? 2 : 1)) continue;
                Class<?> arg = args[this.isMemberClass ? 1 : 0];
                if (arg == String.class) {
                    this.stringConstructor = object;
                    continue;
                }
                if (ObjectMap.class.isAssignableFrom(arg)) {
                    this.objectMapConstructor = object;
                    continue;
                }
                if (this.classCategory == ClassCategory.NUMBER || !Number.class.isAssignableFrom(arg) && (!arg.isPrimitive() || arg != Integer.TYPE && arg != Short.TYPE && arg != Long.TYPE && arg != Float.TYPE && arg != Double.TYPE)) continue;
                this.numberConstructor = object;
                this.numberConstructorType = ClassUtils.getWrapperIfPrimitive(arg);
            }
            boolean bl = this.isAbstract = Modifier.isAbstract(c.getModifiers()) && !this.isPrimitive();
            if (this.classCategory == ClassCategory.ARRAY) {
                this.elementType = this.beanContext.getClassMeta(this.innerClass.getComponentType());
            } else if (this.classCategory == ClassCategory.MAP) {
                parameters = this.beanContext.findParameters(this.innerClass, this.innerClass);
                if (parameters != null && parameters.length == 2) {
                    this.keyType = parameters[0];
                    this.valueType = parameters[1];
                } else {
                    this.keyType = this.beanContext.getClassMeta(Object.class);
                    this.valueType = this.beanContext.getClassMeta(Object.class);
                }
            } else if (this.classCategory == ClassCategory.COLLECTION) {
                parameters = this.beanContext.findParameters(this.innerClass, this.innerClass);
                this.elementType = parameters != null && parameters.length == 1 ? parameters[0] : this.beanContext.getClassMeta(Object.class);
            } else if (this.classCategory == ClassCategory.UNKNOWN) {
                BeanMeta newMeta = null;
                try {
                    newMeta = new BeanMeta(this, this.beanContext, this.beanFilter, null);
                    this.notABeanReason = newMeta.notABeanReason;
                }
                catch (RuntimeException e) {
                    this.notABeanReason = e.getMessage();
                    throw e;
                }
                if (this.notABeanReason != null) {
                    this.classCategory = ClassCategory.OTHER;
                } else {
                    this.beanMeta = newMeta;
                    this.classCategory = ClassCategory.BEAN;
                }
            }
            if (c.isPrimitive()) {
                if (c == Boolean.TYPE) {
                    this.primitiveDefault = BOOLEAN_DEFAULT;
                } else if (c == Character.TYPE) {
                    this.primitiveDefault = CHARACTER_DEFAULT;
                } else if (c == Short.TYPE) {
                    this.primitiveDefault = SHORT_DEFAULT;
                } else if (c == Integer.TYPE) {
                    this.primitiveDefault = INTEGER_DEFAULT;
                } else if (c == Long.TYPE) {
                    this.primitiveDefault = LONG_DEFAULT;
                } else if (c == Float.TYPE) {
                    this.primitiveDefault = FLOAT_DEFAULT;
                } else if (c == Double.TYPE) {
                    this.primitiveDefault = DOUBLE_DEFAULT;
                } else if (c == Byte.TYPE) {
                    this.primitiveDefault = BYTE_DEFAULT;
                }
            } else if (c == Boolean.class) {
                this.primitiveDefault = BOOLEAN_DEFAULT;
            } else if (c == Character.class) {
                this.primitiveDefault = CHARACTER_DEFAULT;
            } else if (c == Short.class) {
                this.primitiveDefault = SHORT_DEFAULT;
            } else if (c == Integer.class) {
                this.primitiveDefault = INTEGER_DEFAULT;
            } else if (c == Long.class) {
                this.primitiveDefault = LONG_DEFAULT;
            } else if (c == Float.class) {
                this.primitiveDefault = FLOAT_DEFAULT;
            } else if (c == Double.class) {
                this.primitiveDefault = DOUBLE_DEFAULT;
            } else if (c == Byte.class) {
                this.primitiveDefault = BYTE_DEFAULT;
            }
        }
        catch (NoClassDefFoundError e) {
            this.initException = e;
        }
        catch (RuntimeException e) {
            this.initException = e;
            throw e;
        }
        if (this.innerClass.getAnnotation(Remoteable.class) != null) {
            this.remoteableMethods = this.getPublicMethods();
        } else {
            for (Method m : this.innerClass.getMethods()) {
                if (m.getAnnotation(Remoteable.class) == null) continue;
                if (this.remoteableMethods == null) {
                    this.remoteableMethods = new LinkedHashMap<String, Method>();
                }
                this.remoteableMethods.put(ClassUtils.getMethodSignature(m), m);
            }
        }
        if (this.remoteableMethods != null) {
            this.remoteableMethods = Collections.unmodifiableMap(this.remoteableMethods);
        }
        return this;
    }

    public String getDictionaryName() {
        if (this.beanMeta != null) {
            return this.beanMeta.getDictionaryName();
        }
        return null;
    }

    public ClassCategory getClassCategory() {
        return this.classCategory;
    }

    public boolean isAssignableFrom(Class<?> c) {
        return ClassUtils.isParentClass(this.innerClass, c);
    }

    public boolean hasSubTypes() {
        return this.beanFilter != null && this.beanFilter.getSubTypeProperty() != null;
    }

    public boolean isInstanceOf(Class<?> c) {
        return ClassUtils.isParentClass(c, this.innerClass);
    }

    public boolean hasChildPojoSwaps() {
        return this.hasChildPojoSwaps;
    }

    private BeanFilter findBeanFilter(BeanContext context) {
        try {
            if (context == null) {
                return null;
            }
            BeanFilter f = context.findBeanFilter(this.innerClass);
            if (f != null) {
                return f;
            }
            List<Bean> ba = ReflectionUtils.findAnnotations(Bean.class, this.innerClass);
            if (!ba.isEmpty()) {
                f = new AnnotationBeanFilterBuilder(this.innerClass, ba).build();
            }
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PojoSwap<T, ?> findPojoSwap(BeanContext context) {
        try {
            Class<?> c;
            Pojo p = this.innerClass.getAnnotation(Pojo.class);
            if (p != null && (c = p.swap()) != Null.class) {
                if (ClassUtils.isParentClass(PojoSwap.class, c)) {
                    return (PojoSwap)c.newInstance();
                }
                throw new RuntimeException("TODO - Surrogate classes not yet supported.");
            }
            if (context == null) {
                return null;
            }
            PojoSwap f = context.findPojoSwap(this.innerClass);
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> Constructor<? extends T> findNoArgConstructor(Class<T> c, Visibility v) {
        int mod = c.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return null;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> cc : c.getConstructors()) {
            mod = cc.getModifiers();
            if (cc.getParameterTypes().length != (isMemberClass ? 1 : 0) || !v.isVisible(mod) || !ClassUtils.isNotDeprecated(cc)) continue;
            return v.transform(cc);
        }
        return null;
    }

    protected ClassMeta<T> setElementType(ClassMeta<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    protected ClassMeta<T> setKeyType(ClassMeta<?> keyType) {
        this.keyType = keyType;
        return this;
    }

    protected ClassMeta<T> setValueType(ClassMeta<?> valueType) {
        this.valueType = valueType;
        return this;
    }

    public Class<T> getInnerClass() {
        return this.innerClass;
    }

    @BeanIgnore
    public ClassMeta<?> getSerializedClassMeta() {
        return this.serializedClassMeta;
    }

    public ClassMeta<?> getElementType() {
        return this.elementType;
    }

    public ClassMeta<?> getKeyType() {
        return this.keyType;
    }

    public ClassMeta<?> getValueType() {
        return this.valueType;
    }

    public boolean isDelegate() {
        return this.isDelegate;
    }

    public boolean isMap() {
        return this.classCategory == ClassCategory.MAP || this.classCategory == ClassCategory.BEANMAP;
    }

    public boolean isBeanMap() {
        return this.classCategory == ClassCategory.BEANMAP;
    }

    public boolean isCollection() {
        return this.classCategory == ClassCategory.COLLECTION;
    }

    public boolean isClass() {
        return this.classCategory == ClassCategory.CLASS;
    }

    public boolean isEnum() {
        return this.classCategory == ClassCategory.ENUM;
    }

    public boolean isArray() {
        return this.classCategory == ClassCategory.ARRAY;
    }

    public boolean isBean() {
        return this.classCategory == ClassCategory.BEAN;
    }

    public boolean isObject() {
        return this.classCategory == ClassCategory.OBJ;
    }

    public boolean isNotObject() {
        return this.classCategory != ClassCategory.OBJ;
    }

    public boolean isNumber() {
        return this.classCategory == ClassCategory.NUMBER || this.classCategory == ClassCategory.DECIMAL;
    }

    public boolean isDecimal() {
        return this.classCategory == ClassCategory.DECIMAL;
    }

    public boolean isBoolean() {
        return this.classCategory == ClassCategory.BOOLEAN;
    }

    public boolean isCharSequence() {
        return this.classCategory == ClassCategory.STR || this.classCategory == ClassCategory.CHARSEQ;
    }

    public boolean isString() {
        return this.classCategory == ClassCategory.STR;
    }

    public boolean isChar() {
        return this.classCategory == ClassCategory.CHAR;
    }

    public boolean isPrimitive() {
        return this.innerClass.isPrimitive();
    }

    public boolean isDate() {
        return this.classCategory == ClassCategory.DATE;
    }

    public boolean isUri() {
        return this.classCategory == ClassCategory.URI;
    }

    public boolean isReader() {
        return this.classCategory == ClassCategory.READER;
    }

    public boolean isInputStream() {
        return this.classCategory == ClassCategory.INPUTSTREAM;
    }

    public boolean isNullable() {
        if (this.innerClass.isPrimitive()) {
            return this.classCategory == ClassCategory.CHAR;
        }
        return true;
    }

    public boolean isRemoteable() {
        return this.remoteableMethods != null;
    }

    public Map<String, Method> getRemoteableMethods() {
        return this.remoteableMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Method> getPublicMethods() {
        if (this.publicMethods == null) {
            ClassMeta classMeta = this;
            synchronized (classMeta) {
                LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
                for (Method m : this.innerClass.getMethods()) {
                    if (!ClassUtils.isPublic(m) || !ClassUtils.isNotDeprecated(m)) continue;
                    map.put(ClassUtils.getMethodSignature(m), m);
                }
                this.publicMethods = Collections.unmodifiableMap(map);
            }
        }
        return this.publicMethods;
    }

    public PojoSwap<T, ?> getPojoSwap() {
        return this.pojoSwap;
    }

    public BeanMeta<T> getBeanMeta() {
        return this.beanMeta;
    }

    public Constructor<? extends T> getConstructor() {
        return this.noArgConstructor;
    }

    public <M extends ClassMetaExtended> M getExtendedMeta(Class<M> c) {
        return (M)((ClassMetaExtended)this.extMeta.get(c, this));
    }

    public InvocationHandler getProxyInvocationHandler() {
        if (this.invocationHandler == null && this.beanMeta != null && this.beanContext.useInterfaceProxies && this.innerClass.isInterface()) {
            this.invocationHandler = new BeanProxyInvocationHandler<T>(this.beanMeta);
        }
        return this.invocationHandler;
    }

    public boolean canCreateNewInstance() {
        if (this.isMemberClass) {
            return false;
        }
        if (this.noArgConstructor != null) {
            return true;
        }
        if (this.getProxyInvocationHandler() != null) {
            return true;
        }
        return this.isArray() && this.elementType.canCreateNewInstance();
    }

    public boolean canCreateNewInstance(Object outer) {
        if (this.isMemberClass) {
            return outer != null && this.noArgConstructor != null && this.noArgConstructor.getParameterTypes()[0] == outer.getClass();
        }
        return this.canCreateNewInstance();
    }

    public boolean canCreateNewBean(Object outer) {
        if (this.beanMeta == null) {
            return false;
        }
        if (this.beanFilter != null && this.beanFilter.getSubTypeProperty() != null) {
            return true;
        }
        if (this.beanMeta.constructor == null) {
            return false;
        }
        if (this.isMemberClass) {
            return outer != null && this.beanMeta.constructor.getParameterTypes()[0] == outer.getClass();
        }
        return true;
    }

    public boolean canCreateNewInstanceFromString(Object outer) {
        if (this.fromStringMethod != null) {
            return true;
        }
        if (this.stringConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && this.stringConstructor.getParameterTypes()[0] == outer.getClass();
            }
            return true;
        }
        return false;
    }

    public boolean canCreateNewInstanceFromNumber(Object outer) {
        if (this.numberConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && this.numberConstructor.getParameterTypes()[0] == outer.getClass();
            }
            return true;
        }
        return false;
    }

    public Class<? extends Number> getNewInstanceFromNumberClass() {
        return this.numberConstructorType;
    }

    public boolean canCreateNewInstanceFromObjectMap(Object outer) {
        if (this.objectMapConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && this.objectMapConstructor.getParameterTypes()[0] == outer.getClass();
            }
            return true;
        }
        return false;
    }

    public boolean hasToObjectMapMethod() {
        return this.toObjectMapMethod != null;
    }

    public Method getNameProperty() {
        return this.namePropertyMethod;
    }

    public Method getParentProperty() {
        return this.parentPropertyMethod;
    }

    public ObjectMap toObjectMap(Object t) throws BeanRuntimeException {
        try {
            if (this.toObjectMapMethod != null) {
                return (ObjectMap)this.toObjectMapMethod.invoke(t, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public synchronized String getNotABeanReason() {
        return this.notABeanReason;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Throwable getInitException() {
        return this.initException;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public T getPrimitiveDefault() {
        return (T)this.primitiveDefault;
    }

    public T newInstanceFromString(Object outer, String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Method m = this.fromStringMethod;
        if (m != null) {
            return (T)m.invoke(null, arg);
        }
        Constructor<T> c = this.stringConstructor;
        if (c != null) {
            if (this.isMemberClass) {
                return c.newInstance(outer, arg);
            }
            return c.newInstance(arg);
        }
        throw new InstantiationError("No string constructor or valueOf(String) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstanceFromNumber(Object outer, Number arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> c = this.numberConstructor;
        if (c != null) {
            Object arg2 = this.beanContext.convertToType((Object)arg, this.numberConstructor.getParameterTypes()[0]);
            if (this.isMemberClass) {
                return c.newInstance(outer, arg2);
            }
            return c.newInstance(arg2);
        }
        throw new InstantiationError("No string constructor or valueOf(Number) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstanceFromObjectMap(Object outer, ObjectMap arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> c = this.objectMapConstructor;
        if (c != null) {
            if (this.isMemberClass) {
                return c.newInstance(outer, arg);
            }
            return c.newInstance(arg);
        }
        throw new InstantiationError("No map constructor method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstance() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isArray()) {
            return (T)Array.newInstance(this.getInnerClass().getComponentType(), 0);
        }
        Constructor<T> c = this.getConstructor();
        if (c != null) {
            return c.newInstance(null);
        }
        InvocationHandler h = this.getProxyInvocationHandler();
        if (h != null) {
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getInnerClass(), Serializable.class}, h);
        }
        if (this.isArray()) {
            return (T)Array.newInstance(this.elementType.innerClass, 0);
        }
        return null;
    }

    public T newInstance(Object outer) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isMemberClass) {
            return this.noArgConstructor.newInstance(outer);
        }
        return this.newInstance();
    }

    public boolean equals(Object t) {
        if (t == null || !(t instanceof ClassMeta)) {
            return false;
        }
        ClassMeta t2 = (ClassMeta)t;
        return t2.getInnerClass() == this.getInnerClass();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simple) {
        return this.toString(new StringBuilder(), simple).toString();
    }

    protected StringBuilder toString(StringBuilder sb, boolean simple) {
        String n = this.innerClass.getName();
        if (simple) {
            int i = n.lastIndexOf(46);
            n = n.substring(i == -1 ? 0 : i + 1).replace('$', '.');
        }
        switch (this.classCategory) {
            case ARRAY: {
                return this.elementType.toString(sb, simple).append('[').append(']');
            }
            case MAP: {
                return sb.append(n).append(this.keyType.isObject() && this.valueType.isObject() ? "" : "<" + this.keyType.toString(simple) + "," + this.valueType.toString(simple) + ">");
            }
            case BEANMAP: {
                return sb.append(BeanMap.class.getName()).append('<').append(n).append('>');
            }
            case COLLECTION: {
                return sb.append(n).append(this.elementType.isObject() ? "" : "<" + this.elementType.toString(simple) + ">");
            }
            case OTHER: {
                if (simple) {
                    return sb.append(n);
                }
                sb.append("OTHER-").append(n).append(",notABeanReason=").append(this.notABeanReason);
                if (this.initException != null) {
                    sb.append(",initException=").append(this.initException);
                }
                return sb;
            }
        }
        return sb.append(n);
    }

    public boolean isInstance(Object o) {
        if (o != null) {
            return ClassUtils.isParentClass(this.innerClass, o.getClass());
        }
        return false;
    }

    public String getReadableName() {
        return ClassUtils.getReadableClassName(this.innerClass);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static enum ClassCategory {
        MAP,
        COLLECTION,
        CLASS,
        NUMBER,
        DECIMAL,
        BOOLEAN,
        CHAR,
        DATE,
        ARRAY,
        ENUM,
        BEAN,
        UNKNOWN,
        OTHER,
        CHARSEQ,
        STR,
        OBJ,
        URI,
        BEANMAP,
        READER,
        INPUTSTREAM;

    }
}

