/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMetaExtended;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanConstructor;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.utils.MetadataMap;

public class BeanMeta<T> {
    protected final ClassMeta<T> classMeta;
    protected final Class<T> c;
    protected final Map<String, BeanPropertyMeta> properties;
    protected final Map<Method, String> getterProps;
    protected final Map<Method, String> setterProps;
    protected final BeanContext ctx;
    protected final BeanFilter beanFilter;
    protected final Map<Class<?>, Class<?>[]> typeVarImpls;
    protected final Constructor<T> constructor;
    protected final String[] constructorArgs;
    private final MetadataMap extMeta;
    final BeanPropertyMeta subTypeProperty;
    private final BeanPropertyMeta typeProperty;
    private final String dictionaryName;
    final String notABeanReason;

    protected BeanMeta(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
        this.classMeta = classMeta;
        this.ctx = ctx;
        this.c = classMeta.getInnerClass();
        Builder b = new Builder(classMeta, ctx, beanFilter, pNames);
        this.notABeanReason = b.init(this);
        this.beanFilter = beanFilter;
        this.dictionaryName = beanFilter == null ? null : beanFilter.getTypeName();
        this.properties = b.properties;
        this.getterProps = Collections.unmodifiableMap(b.getterProps);
        this.setterProps = Collections.unmodifiableMap(b.setterProps);
        this.typeVarImpls = b.typeVarImpls;
        this.constructor = b.constructor;
        this.constructorArgs = b.constructorArgs;
        this.extMeta = b.extMeta;
        this.subTypeProperty = b.subTypeIdProperty;
        this.typeProperty = new BeanPropertyMeta(this, ctx.getBeanTypePropertyName(), ctx.string());
    }

    @BeanIgnore
    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public BeanPropertyMeta getSubTypeProperty() {
        return this.subTypeProperty;
    }

    public boolean isSubTyped() {
        return this.subTypeProperty != null;
    }

    public BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    private static List<BeanMethod> findBeanMethods(Class<?> c, Class<?> stopClass, Visibility v, Set<String> fixedBeanProps, PropertyNamer pn) {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Method m : c2.getDeclaredMethods()) {
                int mod = m.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isTransient(mod) || m.isAnnotationPresent(BeanIgnore.class) || m.isBridge() || !v.isVisible(m) && !m.isAnnotationPresent(BeanProperty.class)) continue;
                String n = m.getName();
                Class<?>[] pt = m.getParameterTypes();
                Class<?> rt = m.getReturnType();
                boolean isGetter = false;
                boolean isSetter = false;
                if (pt.length == 1 && n.startsWith("set") && (ClassUtils.isParentClass(rt, c) || rt.equals(Void.TYPE))) {
                    isSetter = true;
                    n = n.substring(3);
                } else if (pt.length == 0 && n.startsWith("get") && !rt.equals(Void.TYPE)) {
                    isGetter = true;
                    n = n.substring(3);
                } else if (pt.length == 0 && n.startsWith("is") && (rt.equals(Boolean.TYPE) || rt.equals(Boolean.class))) {
                    isGetter = true;
                    n = n.substring(2);
                }
                n = pn.getPropertyName(n);
                if (!isGetter && !isSetter) continue;
                BeanProperty bp = m.getAnnotation(BeanProperty.class);
                if (bp != null && !bp.name().equals("")) {
                    n = bp.name();
                    if (!fixedBeanProps.isEmpty() && !fixedBeanProps.contains(n)) {
                        throw new BeanRuntimeException(c, "Method property ''{0}'' identified in @BeanProperty, but missing from @Bean", n);
                    }
                }
                l.add(new BeanMethod(n, isSetter, m));
            }
        }
        return l;
    }

    private static Collection<Field> findBeanFields(Class<?> c, Class<?> stopClass, Visibility v) {
        LinkedList<Field> l = new LinkedList<Field>();
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Field f : c2.getDeclaredFields()) {
                int m = f.getModifiers();
                if (Modifier.isStatic(m) || Modifier.isTransient(m) || f.isAnnotationPresent(BeanIgnore.class) || !v.isVisible(f) && !f.isAnnotationPresent(BeanProperty.class)) continue;
                l.add(f);
            }
        }
        return l;
    }

    private static List<Class<?>> findClasses(Class<?> c, Class<?> stopClass) {
        LinkedList l = new LinkedList();
        BeanMeta.findClasses(c, l, stopClass);
        return l;
    }

    private static void findClasses(Class<?> c, LinkedList<Class<?>> l, Class<?> stopClass) {
        while (c != null && stopClass != c) {
            l.addFirst(c);
            for (Class<?> ci : c.getInterfaces()) {
                BeanMeta.findClasses(ci, l, stopClass);
            }
            c = c.getSuperclass();
        }
    }

    public Collection<BeanPropertyMeta> getPropertyMetas() {
        return this.properties.values();
    }

    public Collection<BeanPropertyMeta> getPropertyMetas(String ... pNames) {
        if (pNames == null) {
            return this.getPropertyMetas();
        }
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(pNames.length);
        for (int i = 0; i < pNames.length; ++i) {
            l.add(this.getPropertyMeta(pNames[i]));
        }
        return l;
    }

    public <M extends BeanMetaExtended> M getExtendedMeta(Class<M> metaDataClass) {
        return (M)((BeanMetaExtended)this.extMeta.get(metaDataClass, this));
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        return this.properties.get(name);
    }

    protected T newBean(Object outer) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.classMeta.isMemberClass) {
            if (this.constructor != null) {
                return this.constructor.newInstance(outer);
            }
        } else {
            if (this.constructor != null) {
                return this.constructor.newInstance(null);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (h != null) {
                ClassLoader cl = this.classMeta.beanContext.classLoader;
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                return (T)Proxy.newProxyInstance(cl, new Class[]{this.classMeta.innerClass, Serializable.class}, h);
            }
        }
        return null;
    }

    private static void findTypeVarImpls(Type t, Map<Class<?>, Class<?>[]> m) {
        ParameterizedType pt;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            BeanMeta.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                BeanMeta.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
            Type[] gImpls = pt.getActualTypeArguments();
            Class[] gTypes = new Class[gImpls.length];
            for (int i = 0; i < gImpls.length; ++i) {
                Type gt = gImpls[i];
                if (gt instanceof Class) {
                    gTypes[i] = (Class)gt;
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    gTypes[i] = (Class)upperBound;
                }
            }
            m.put((Class)rt, gTypes);
            BeanMeta.findTypeVarImpls(pt.getRawType(), m);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.c.getName());
        sb.append(" {\n");
        for (BeanPropertyMeta pm : this.properties.values()) {
            sb.append('\t').append(pm.toString()).append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    private static class SubTypePropertyMeta
    extends BeanPropertyMeta {
        private Map<Class<?>, String> subTypes;
        private BeanPropertyMeta realProperty;
        private BeanMeta<?> beanMeta;

        SubTypePropertyMeta(BeanMeta beanMeta, String subTypeAttr, Map<Class<?>, String> subTypes, BeanPropertyMeta realProperty) {
            super(beanMeta, subTypeAttr, beanMeta.ctx.string());
            this.subTypes = subTypes;
            this.realProperty = realProperty;
            this.beanMeta = beanMeta;
        }

        @Override
        public Object set(BeanMap<?> m, Object value) throws BeanRuntimeException {
            if (value == null) {
                throw new BeanRuntimeException("Attempting to set bean subtype property to null.");
            }
            String subTypeId = value.toString();
            for (Map.Entry<Class<?>, String> e : this.subTypes.entrySet()) {
                if (!e.getValue().equals(subTypeId)) continue;
                Class<?> subTypeClass = e.getKey();
                m.meta = this.beanMeta.ctx.getBeanMeta(subTypeClass);
                try {
                    m.setBean(subTypeClass.newInstance());
                    if (this.realProperty != null) {
                        this.realProperty.set(m, value);
                    }
                    if (m.propertyCache != null) {
                        for (Map.Entry<String, Object> me : m.propertyCache.entrySet()) {
                            m.put(me.getKey(), me.getValue());
                        }
                    }
                }
                catch (Exception e1) {
                    throw new BeanRuntimeException(e1);
                }
                return null;
            }
            throw new BeanRuntimeException(this.beanMeta.c, "Unknown subtype ID ''{0}''", subTypeId);
        }

        @Override
        public Object get(BeanMap<?> m) throws BeanRuntimeException {
            String subTypeId = this.beanMeta.beanFilter.getSubTypes().get(this.beanMeta.c);
            if (subTypeId == null) {
                throw new BeanRuntimeException(this.beanMeta.c, "Unmapped sub type class", new Object[0]);
            }
            return subTypeId;
        }
    }

    private static class BeanMethod {
        String propertyName;
        boolean isSetter;
        Method method;
        Class<?> type;

        BeanMethod(String propertyName, boolean isSetter, Method method) {
            this.propertyName = propertyName;
            this.isSetter = isSetter;
            this.method = method;
            this.type = isSetter ? method.getParameterTypes()[0] : method.getReturnType();
        }

        boolean matchesPropertyType(BeanPropertyMeta b) {
            if (b == null) {
                return false;
            }
            Class<?> pt = null;
            if (b.getGetter() != null) {
                pt = b.getGetter().getReturnType();
            } else if (b.getField() != null) {
                pt = b.getField().getType();
            }
            if (pt == null) {
                return false;
            }
            if (!ClassUtils.isParentClass(this.type, pt)) {
                return false;
            }
            if (b.getSetter() == null) {
                return true;
            }
            Class<?> prevType = b.getSetter().getParameterTypes()[0];
            return ClassUtils.isParentClass(prevType, this.type, true);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private static final class Builder<T> {
        ClassMeta<T> classMeta;
        BeanContext ctx;
        BeanFilter beanFilter;
        String[] pNames;
        Map<String, BeanPropertyMeta> properties;
        Map<Method, String> getterProps = new HashMap<Method, String>();
        Map<Method, String> setterProps = new HashMap<Method, String>();
        Map<Class<?>, Class<?>[]> typeVarImpls;
        Constructor<T> constructor;
        String[] constructorArgs = new String[0];
        MetadataMap extMeta = new MetadataMap();
        BeanPropertyMeta subTypeIdProperty;
        PropertyNamer propertyNamer;

        private Builder(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
            this.classMeta = classMeta;
            this.ctx = ctx;
            this.beanFilter = beanFilter;
            this.pNames = pNames;
        }

        /*
         * WARNING - void declaration
         */
        private String init(BeanMeta<T> beanMeta) {
            Class<T> c = this.classMeta.getInnerClass();
            try {
                Object m;
                Class<Object> stopClass;
                Visibility conVis = this.ctx.beanConstructorVisibility;
                Visibility cVis = this.ctx.beanClassVisibility;
                Visibility mVis = this.ctx.beanMethodVisibility;
                Visibility fVis = this.ctx.beanFieldVisibility;
                Class<T> c2 = this.beanFilter != null && this.beanFilter.getInterfaceClass() != null ? this.beanFilter.getInterfaceClass() : c;
                Class clazz = stopClass = this.beanFilter != null ? this.beanFilter.getStopClass() : Object.class;
                if (stopClass == null) {
                    stopClass = Object.class;
                }
                LinkedHashMap<String, BeanPropertyMeta> normalProps = new LinkedHashMap<String, BeanPropertyMeta>();
                if (this.ctx.isNotABean(c)) {
                    return "Class matches exclude-class list";
                }
                if (!cVis.isVisible(c.getModifiers())) {
                    return "Class is not public";
                }
                if (c.isAnnotationPresent(BeanIgnore.class)) {
                    return "Class is annotated with @BeanIgnore";
                }
                if (this.beanFilter == null && this.ctx.beansRequireSerializable && !ClassUtils.isParentClass(Serializable.class, c)) {
                    return "Class is not serializable";
                }
                for (Constructor<?> x : c.getConstructors()) {
                    if (!x.isAnnotationPresent(BeanConstructor.class)) continue;
                    if (this.constructor != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of '@BeanConstructor' found.", new Object[0]);
                    }
                    this.constructor = x;
                    this.constructorArgs = StringUtils.split(x.getAnnotation(BeanConstructor.class).properties(), ',');
                    if (this.constructorArgs.length != x.getParameterTypes().length) {
                        throw new BeanRuntimeException(c, "Number of properties defined in '@BeanConstructor' annotation does not match number of parameters in constructor.", new Object[0]);
                    }
                    if (Visibility.setAccessible(this.constructor)) continue;
                    throw new BeanRuntimeException(c, "Could not set accessibility to true on method with @BeanConstructor annotation.  Method=''{0}''", this.constructor.getName());
                }
                if (this.constructor == null) {
                    this.constructor = this.ctx.getImplClassConstructor(c, conVis);
                }
                if (this.constructor == null) {
                    this.constructor = ClassMeta.findNoArgConstructor(c, conVis);
                }
                if (this.constructor == null && this.beanFilter == null && this.ctx.beansRequireDefaultConstructor) {
                    return "Class does not have the required no-arg constructor";
                }
                if (!Visibility.setAccessible(this.constructor)) {
                    throw new BeanRuntimeException(c, "Could not set accessibility to true on no-arg constructor", new Object[0]);
                }
                LinkedHashSet<String> fixedBeanProps = new LinkedHashSet<String>();
                if (this.beanFilter != null) {
                    if (this.beanFilter.getProperties() != null) {
                        for (String string : this.beanFilter.getProperties()) {
                            fixedBeanProps.add(string);
                        }
                    }
                    if (this.beanFilter.getPropertyNamer() != null) {
                        this.propertyNamer = this.beanFilter.getPropertyNamer();
                    }
                }
                if (this.propertyNamer == null) {
                    this.propertyNamer = new PropertyNamerDefault();
                }
                for (String name : fixedBeanProps) {
                    normalProps.put(name, new BeanPropertyMeta(beanMeta, name));
                }
                if (this.ctx.useJavaBeanIntrospector) {
                    Object bi = null;
                    bi = !c2.isInterface() ? Introspector.getBeanInfo(c2, stopClass) : Introspector.getBeanInfo(c2, null);
                    if (bi != null) {
                        void var14_40;
                        PropertyDescriptor[] name = bi.getPropertyDescriptors();
                        int x = name.length;
                        boolean bl = false;
                        while (var14_40 < x) {
                            PropertyDescriptor pd = name[var14_40];
                            String name2 = pd.getName();
                            if (!normalProps.containsKey(name2)) {
                                normalProps.put(name2, new BeanPropertyMeta(beanMeta, name2));
                            }
                            ((BeanPropertyMeta)normalProps.get(name2)).setGetter(pd.getReadMethod()).setSetter(pd.getWriteMethod());
                            ++var14_40;
                        }
                    }
                } else {
                    for (Field f : BeanMeta.findBeanFields(c2, stopClass, fVis)) {
                        String name = this.findPropertyName(f, fixedBeanProps);
                        if (name == null) continue;
                        if (!normalProps.containsKey(name)) {
                            normalProps.put(name, new BeanPropertyMeta(beanMeta, name));
                        }
                        ((BeanPropertyMeta)normalProps.get(name)).setField(f);
                    }
                    List bms = BeanMeta.findBeanMethods(c2, stopClass, mVis, fixedBeanProps, this.propertyNamer);
                    for (BeanMethod bm : bms) {
                        String string = bm.propertyName;
                        m = bm.method;
                        if (!normalProps.containsKey(string)) {
                            normalProps.put(string, new BeanPropertyMeta(beanMeta, string));
                        }
                        BeanPropertyMeta bpm = (BeanPropertyMeta)normalProps.get(string);
                        if (bm.isSetter) continue;
                        bpm.setGetter((Method)m);
                    }
                    for (BeanMethod bm : bms) {
                        BeanPropertyMeta beanPropertyMeta;
                        if (!bm.isSetter || !bm.matchesPropertyType(beanPropertyMeta = (BeanPropertyMeta)normalProps.get(bm.propertyName))) continue;
                        beanPropertyMeta.setSetter(bm.method);
                    }
                }
                this.typeVarImpls = new HashMap();
                BeanMeta.findTypeVarImpls(c, this.typeVarImpls);
                if (this.typeVarImpls.isEmpty()) {
                    this.typeVarImpls = null;
                }
                Iterator<Object> i = normalProps.values().iterator();
                while (i.hasNext()) {
                    BeanPropertyMeta p = (BeanPropertyMeta)i.next();
                    try {
                        if (p.validate(this.ctx, this.typeVarImpls)) {
                            if (p.getGetter() != null) {
                                this.getterProps.put(p.getGetter(), p.getName());
                            }
                            if (p.getSetter() == null) continue;
                            this.setterProps.put(p.getSetter(), p.getName());
                            continue;
                        }
                        i.remove();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanRuntimeException(c, e.getLocalizedMessage(), new Object[0]);
                    }
                }
                for (String fp : fixedBeanProps) {
                    if (normalProps.containsKey(fp)) continue;
                    throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Bean(properties=X) annotation but was not found on the class definition.", fp);
                }
                for (Iterator<Object> iterator : this.constructorArgs) {
                    m = (BeanPropertyMeta)normalProps.get(iterator);
                    if (m == null) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @BeanConstructor(properties=X) annotation but was not found on the class definition.", iterator);
                    }
                    ((BeanPropertyMeta)m).setAsConstructorArg();
                }
                if (this.beanFilter == null && this.ctx.beansRequireSomeProperties && normalProps.size() == 0) {
                    return "No properties detected on bean class";
                }
                boolean sortProperties = (this.ctx.sortProperties || this.beanFilter != null && this.beanFilter.isSortProperties()) && fixedBeanProps.isEmpty();
                Map<Object, Object> map = this.properties = sortProperties ? new TreeMap() : new LinkedHashMap();
                if (this.beanFilter != null && this.beanFilter.getSubTypeProperty() != null) {
                    String subTypeProperty = this.beanFilter.getSubTypeProperty();
                    this.subTypeIdProperty = new SubTypePropertyMeta(beanMeta, subTypeProperty, this.beanFilter.getSubTypes(), (BeanPropertyMeta)normalProps.remove(subTypeProperty));
                    this.properties.put(subTypeProperty, this.subTypeIdProperty);
                }
                this.properties.putAll(normalProps);
                if (this.beanFilter != null) {
                    String[] includeKeys = this.beanFilter.getProperties();
                    String[] excludeKeys = this.beanFilter.getExcludeProperties();
                    if (excludeKeys != null) {
                        for (String k : excludeKeys) {
                            this.properties.remove(k);
                        }
                    } else if (includeKeys != null) {
                        LinkedHashMap<String, BeanPropertyMeta> linkedHashMap = new LinkedHashMap<String, BeanPropertyMeta>();
                        for (String k : includeKeys) {
                            if (!this.properties.containsKey(k)) continue;
                            linkedHashMap.put(k, this.properties.get(k));
                        }
                        this.properties = linkedHashMap;
                    }
                }
                if (this.pNames != null) {
                    LinkedHashMap<String, BeanPropertyMeta> properties2 = new LinkedHashMap<String, BeanPropertyMeta>();
                    for (String k : this.pNames) {
                        if (!this.properties.containsKey(k)) continue;
                        properties2.put(k, this.properties.get(k));
                    }
                    this.properties = properties2;
                }
                this.properties = Collections.unmodifiableMap(this.properties);
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return "Exception:  " + StringUtils.getStackTrace(e);
            }
            return null;
        }

        private String findPropertyName(Field f, Set<String> fixedBeanProps) {
            BeanProperty bp = f.getAnnotation(BeanProperty.class);
            if (bp != null && !bp.name().equals("")) {
                String name = bp.name();
                if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                    return name;
                }
                throw new BeanRuntimeException(this.classMeta.getInnerClass(), "Method property ''{0}'' identified in @BeanProperty, but missing from @Bean", name);
            }
            String name = this.propertyNamer.getPropertyName(f.getName());
            if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                return name;
            }
            return null;
        }
    }
}

