/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanDictionaryBuilder;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;

public class BeanDictionary {
    private final Map<String, ClassMeta<?>> map;
    private final BeanContext beanContext;
    private final String beanTypePropertyName;

    BeanDictionary(BeanDictionaryBuilder builder) {
        this.beanContext = builder.beanContext;
        this.beanTypePropertyName = this.beanContext.getBeanTypePropertyName();
        HashMap m1 = new HashMap();
        for (Map.Entry<String, Class<?>> e : builder.map.entrySet()) {
            ClassMeta<?> cm = this.beanContext.getClassMeta(e.getValue());
            if (!cm.isBean()) {
                throw new BeanRuntimeException("Invalid class type passed to dictionary.  ''{0}'' is not a bean.", cm);
            }
            m1.put(e.getKey(), cm);
        }
        this.map = Collections.unmodifiableMap(m1);
    }

    public Object cast(ObjectMap m) {
        Object o = m.get(this.beanTypePropertyName);
        if (o == null) {
            return m;
        }
        String typeName = o.toString();
        ClassMeta<?> cm = this.getClassMeta(typeName);
        BeanMap<?> bm = this.beanContext.newBeanMap(cm.getInnerClass());
        for (Map.Entry<String, Object> e : m.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            if (k.equals(this.beanTypePropertyName)) continue;
            if (v instanceof ObjectMap) {
                v = this.cast((ObjectMap)v);
            }
            bm.put(k, v);
        }
        return bm.getBean();
    }

    public ClassMeta<?> getClassMeta(String typeName) {
        ClassMeta<?> cm = this.map.get(typeName);
        if (cm == null) {
            throw new BeanRuntimeException("Could not find bean type ''{0}'' in dictionary.", typeName);
        }
        return cm;
    }

    public boolean hasName(String typeName) {
        return this.map.containsKey(typeName);
    }
}

