/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.BeanDictionary;
import org.apache.juneau.BeanDictionaryBuilder;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.ContextFactory;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.InterfaceBeanFilterBuilder;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transform.SurrogateSwap;

public class BeanContext
extends Context {
    public static final String BEAN_beansRequireDefaultConstructor = "BeanContext.beansRequireDefaultConstructor";
    public static final String BEAN_beansRequireSerializable = "BeanContext.beansRequireSerializable";
    public static final String BEAN_beansRequireSettersForGetters = "BeanContext.beansRequireSettersForGetters";
    public static final String BEAN_beansRequireSomeProperties = "BeanContext.beansRequireSomeProperties";
    public static final String BEAN_beanMapPutReturnsOldValue = "BeanContext.beanMapPutReturnsOldValue";
    public static final String BEAN_beanConstructorVisibility = "BeanContext.beanConstructorVisibility";
    public static final String BEAN_beanClassVisibility = "BeanContext.beanClassVisibility";
    public static final String BEAN_beanFieldVisibility = "BeanContext.beanFieldVisibility";
    public static final String BEAN_methodVisibility = "BeanContext.methodVisibility";
    public static final String BEAN_useJavaBeanIntrospector = "BeanContext.useJavaBeanIntrospector";
    public static final String BEAN_useInterfaceProxies = "BeanContext.useInterfaceProxies";
    public static final String BEAN_ignoreUnknownBeanProperties = "BeanContext.ignoreUnknownBeanProperties";
    public static final String BEAN_ignoreUnknownNullBeanProperties = "BeanContext.ignoreUnknownNullBeanProperties";
    public static final String BEAN_ignorePropertiesWithoutSetters = "BeanContext.ignorePropertiesWithoutSetters";
    public static final String BEAN_ignoreInvocationExceptionsOnGetters = "BeanContext.ignoreInvocationExceptionsOnGetters";
    public static final String BEAN_ignoreInvocationExceptionsOnSetters = "BeanContext.ignoreInvocationExceptionsOnSetters";
    public static final String BEAN_sortProperties = "BeanContext.sortProperties";
    public static final String BEAN_notBeanPackages = "BeanContext.notBeanPackages.set";
    public static final String BEAN_notBeanPackages_add = "BeanContext.notBeanPackages.set.add";
    public static final String BEAN_notBeanPackages_remove = "BeanContext.notBeanPackages.set.remove";
    public static final String BEAN_notBeanClasses = "BeanContext.notBeanClasses.set";
    public static final String BEAN_notBeanClasses_add = "BeanContext.notBeanClasses.set.add";
    public static final String BEAN_notBeanClasses_remove = "BeanContext.notBeanClasses.set.remove";
    public static final String BEAN_beanFilters = "BeanContext.beanFilters.list";
    public static final String BEAN_beanFilters_add = "BeanContext.beanFilters.list.add";
    public static final String BEAN_beanFilters_remove = "BeanContext.beanFilters.list.remove";
    public static final String BEAN_pojoSwaps = "BeanContext.pojoSwaps.list";
    public static final String BEAN_pojoSwaps_add = "BeanContext.pojoSwaps.list.add";
    public static final String BEAN_pojoSwaps_remove = "BeanContext.pojoSwaps.list.remove";
    public static final String BEAN_implClasses = "BeanContext.implClasses.map";
    public static final String BEAN_implClasses_put = "BeanContext.implClasses.map.put";
    public static final String BEAN_beanDictionary = "BeanContext.beanDictionary.list";
    public static final String BEAN_beanDictionary_add = "BeanContext.beanDictionary.list.add";
    public static final String BEAN_beanDictionary_remove = "BeanContext.beanDictionary.list.remove";
    public static final String BEAN_beanTypePropertyName = "BeanContext.beanTypePropertyName";
    public static final String BEAN_defaultParser = "BeanContext.defaultParser";
    private static final String[] DEFAULT_NOTBEAN_PACKAGES = new String[]{"java.lang", "java.lang.annotation", "java.lang.ref", "java.lang.reflect", "java.io", "java.net", "java.nio.*", "java.util.*"};
    private static final Class<?>[] DEFAULT_NOTBEAN_CLASSES = new Class[]{Map.class, Collection.class, Reader.class, Writer.class, InputStream.class, OutputStream.class, Throwable.class};
    private static final ConcurrentHashMap<Integer, Map<Class, ClassMeta>> cmCacheCache = new ConcurrentHashMap();
    public static final BeanContext DEFAULT = ContextFactory.create().getContext(BeanContext.class);
    public static final BeanContext DEFAULT_SORTED = ContextFactory.create().setProperty("BeanContext.sortProperties", true).getContext(BeanContext.class);
    final boolean beansRequireDefaultConstructor;
    final boolean beansRequireSerializable;
    final boolean beansRequireSettersForGetters;
    final boolean beansRequireSomeProperties;
    final boolean beanMapPutReturnsOldValue;
    final boolean useInterfaceProxies;
    final boolean ignoreUnknownBeanProperties;
    final boolean ignoreUnknownNullBeanProperties;
    final boolean ignorePropertiesWithoutSetters;
    final boolean ignoreInvocationExceptionsOnGetters;
    final boolean ignoreInvocationExceptionsOnSetters;
    final boolean useJavaBeanIntrospector;
    final boolean sortProperties;
    final Visibility beanConstructorVisibility;
    final Visibility beanClassVisibility;
    final Visibility beanMethodVisibility;
    final Visibility beanFieldVisibility;
    final Class<?>[] notBeanClasses;
    final String[] notBeanPackageNames;
    final String[] notBeanPackagePrefixes;
    final BeanFilter[] beanFilters;
    final PojoSwap<?, ?>[] pojoSwaps;
    final BeanDictionary beanDictionary;
    final Map<Class<?>, Class<?>> implClasses;
    final Class<?>[] implKeyClasses;
    final Class<?>[] implValueClasses;
    final ClassLoader classLoader;
    final Map<Class, ClassMeta> cmCache;
    final ClassMeta<Object> cmObject;
    final ClassMeta<String> cmString;
    final ClassMeta<Class> cmClass;
    final ReaderParser defaultParser;
    final String beanTypePropertyName;
    final Deque<ClassMeta> pendingClassMetas = new LinkedList<ClassMeta>();
    final int hashCode;

    static final void loadDefaults(ContextFactory config) {
        config.setProperty(BEAN_notBeanPackages, DEFAULT_NOTBEAN_PACKAGES);
        config.setProperty(BEAN_notBeanClasses, DEFAULT_NOTBEAN_CLASSES);
    }

    public BeanContext(ContextFactory cf) {
        super(cf);
        ContextFactory.PropertyMap pm = cf.getPropertyMap("BeanContext");
        this.hashCode = pm.hashCode();
        this.classLoader = cf.classLoader;
        this.defaultParser = cf.defaultParser;
        this.beansRequireDefaultConstructor = pm.get(BEAN_beansRequireDefaultConstructor, Boolean.TYPE, false);
        this.beansRequireSerializable = pm.get(BEAN_beansRequireSerializable, Boolean.TYPE, false);
        this.beansRequireSettersForGetters = pm.get(BEAN_beansRequireSettersForGetters, Boolean.TYPE, false);
        this.beansRequireSomeProperties = pm.get(BEAN_beansRequireSomeProperties, Boolean.TYPE, true);
        this.beanMapPutReturnsOldValue = pm.get(BEAN_beanMapPutReturnsOldValue, Boolean.TYPE, false);
        this.useInterfaceProxies = pm.get(BEAN_useInterfaceProxies, Boolean.TYPE, true);
        this.ignoreUnknownBeanProperties = pm.get(BEAN_ignoreUnknownBeanProperties, Boolean.TYPE, false);
        this.ignoreUnknownNullBeanProperties = pm.get(BEAN_ignoreUnknownNullBeanProperties, Boolean.TYPE, true);
        this.ignorePropertiesWithoutSetters = pm.get(BEAN_ignorePropertiesWithoutSetters, Boolean.TYPE, true);
        this.ignoreInvocationExceptionsOnGetters = pm.get(BEAN_ignoreInvocationExceptionsOnGetters, Boolean.TYPE, false);
        this.ignoreInvocationExceptionsOnSetters = pm.get(BEAN_ignoreInvocationExceptionsOnSetters, Boolean.TYPE, false);
        this.useJavaBeanIntrospector = pm.get(BEAN_useJavaBeanIntrospector, Boolean.TYPE, false);
        this.sortProperties = pm.get(BEAN_sortProperties, Boolean.TYPE, false);
        this.beanTypePropertyName = pm.get(BEAN_beanTypePropertyName, String.class, "_type");
        this.beanConstructorVisibility = pm.get(BEAN_beanConstructorVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanClassVisibility = pm.get(BEAN_beanClassVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanMethodVisibility = pm.get(BEAN_methodVisibility, Visibility.class, Visibility.PUBLIC);
        this.beanFieldVisibility = pm.get(BEAN_beanFieldVisibility, Visibility.class, Visibility.PUBLIC);
        this.notBeanClasses = pm.get(BEAN_notBeanClasses, Class[].class, new Class[0]);
        LinkedList<String> l1 = new LinkedList<String>();
        LinkedList<String> l2 = new LinkedList<String>();
        for (String s : pm.get(BEAN_notBeanPackages, String[].class, new String[0])) {
            if (s.endsWith(".*")) {
                l2.add(s.substring(0, s.length() - 2));
                continue;
            }
            l1.add(s);
        }
        this.notBeanPackageNames = l1.toArray(new String[l1.size()]);
        this.notBeanPackagePrefixes = l2.toArray(new String[l2.size()]);
        LinkedList<BeanFilter> lbf = new LinkedList<BeanFilter>();
        try {
            for (Class c : pm.get(BEAN_beanFilters, Class[].class, new Class[0])) {
                if (ClassUtils.isParentClass(BeanFilter.class, c)) {
                    lbf.add((BeanFilter)c.newInstance());
                    continue;
                }
                if (ClassUtils.isParentClass(BeanFilterBuilder.class, c)) {
                    lbf.add(((BeanFilterBuilder)c.newInstance()).build());
                    continue;
                }
                lbf.add(new InterfaceBeanFilterBuilder(c).build());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.beanFilters = lbf.toArray(new BeanFilter[0]);
        LinkedList<PojoSwap> lpf = new LinkedList<PojoSwap>();
        try {
            for (Class c : pm.get(BEAN_pojoSwaps, Class[].class, new Class[0])) {
                if (ClassUtils.isParentClass(PojoSwap.class, c)) {
                    lpf.add((PojoSwap)c.newInstance());
                    continue;
                }
                lpf.addAll(SurrogateSwap.findPojoSwaps(c));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.pojoSwaps = lpf.toArray(new PojoSwap[0]);
        this.implClasses = new TreeMap(new ClassUtils.ClassComparator());
        Map<Class, Class> m = pm.getMap(BEAN_implClasses, Class.class, Class.class, null);
        if (m != null) {
            for (Map.Entry<Class, Class> e : m.entrySet()) {
                this.implClasses.put(e.getKey(), e.getValue());
            }
        }
        this.implKeyClasses = this.implClasses.keySet().toArray(new Class[0]);
        this.implValueClasses = this.implClasses.values().toArray(new Class[0]);
        if (!cmCacheCache.containsKey(this.hashCode)) {
            ConcurrentHashMap<Class, ClassMeta<Object>> cm = new ConcurrentHashMap<Class, ClassMeta<Object>>();
            cm.put(String.class, new ClassMeta<String>(String.class, this));
            cm.put(Object.class, new ClassMeta<Object>(Object.class, this));
            cmCacheCache.putIfAbsent(this.hashCode, cm);
        }
        this.cmCache = cmCacheCache.get(this.hashCode);
        this.cmString = this.cmCache.get(String.class);
        this.cmObject = this.cmCache.get(Object.class);
        this.cmClass = this.cmCache.get(Class.class);
        this.beanDictionary = new BeanDictionaryBuilder().add(pm.get(BEAN_beanDictionary, Class[].class, new Class[0])).setBeanContext(this).build();
    }

    public boolean hasSameCache(BeanContext bc) {
        return bc.cmCache == this.cmCache;
    }

    public boolean isIgnoreUnknownBeanProperties() {
        return this.ignoreUnknownBeanProperties;
    }

    protected boolean isNotABean(Class<?> c) {
        if (c.isArray() || c.isPrimitive() || c.isEnum() || c.isAnnotation()) {
            return true;
        }
        Package p = c.getPackage();
        if (p != null) {
            for (String string : this.notBeanPackageNames) {
                if (!p.getName().equals(string)) continue;
                return true;
            }
            for (String string : this.notBeanPackagePrefixes) {
                if (!p.getName().startsWith(string)) continue;
                return true;
            }
        }
        for (Class<?> clazz : this.notBeanClasses) {
            if (!ClassUtils.isParentClass(clazz, c)) continue;
            return true;
        }
        return false;
    }

    protected static void dumpCacheStats() {
        try {
            int ctCount = 0;
            for (Map<Class, ClassMeta> cm : cmCacheCache.values()) {
                ctCount += cm.size();
            }
            System.out.println(MessageFormat.format("ClassMeta cache: {0} instances in {1} caches", ctCount, cmCacheCache.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> BeanMap<T> forBean(T o) {
        return this.forBean(o, o.getClass());
    }

    public boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.isBean(o.getClass());
    }

    public boolean isBean(Class<?> c) {
        return this.getBeanMeta(c) != null;
    }

    public <T> BeanMap<T> forBean(T o, Class<? super T> c) throws BeanRuntimeException {
        ClassMeta<T> cm;
        BeanMeta<? super T> m;
        ThrowableUtils.assertFieldNotNull(o, "o");
        ThrowableUtils.assertFieldNotNull(c, "c");
        if (!c.isInstance(o)) {
            ThrowableUtils.illegalArg("The specified object is not an instance of the specified class.  class=''{0}'', objectClass=''{1}'', object=''{2}''", c.getName(), o.getClass().getName(), 0);
        }
        if ((m = (cm = this.getClassMeta(c)).getBeanMeta()) == null) {
            throw new BeanRuntimeException(c, "Class is not a bean.  Reason=''{0}''", cm.getNotABeanReason());
        }
        return new BeanMap<T>(o, m);
    }

    public <T> BeanMap<T> newBeanMap(Class<T> c) {
        return this.newBeanMap(null, c);
    }

    public <T> BeanMap<T> newBeanMap(Object outer, Class<T> c) {
        BeanMeta<T> m = this.getBeanMeta(c);
        if (m == null) {
            return null;
        }
        Object bean = null;
        if (m.constructorArgs.length == 0 && (bean = (Object)this.newBean(outer, c)) == null && !m.getClassMeta().hasSubTypes()) {
            return null;
        }
        return new BeanMap<Object>(bean, (BeanMeta<Object>)m);
    }

    public <T> T newBean(Class<T> c) throws BeanRuntimeException {
        return this.newBean(null, c);
    }

    public <T> T newBean(Object outer, Class<T> c) throws BeanRuntimeException {
        ClassMeta<T> cm = this.getClassMeta(c);
        BeanMeta<T> m = cm.getBeanMeta();
        if (m == null) {
            return null;
        }
        try {
            T o = m.newBean(outer);
            if (o == null) {
                if (cm.beanFilter != null && cm.beanFilter.getSubTypeProperty() != null) {
                    return null;
                }
                throw new BeanRuntimeException(c, "Class does not have a no-arg constructor.", new Object[0]);
            }
            return o;
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public <T> ClassMeta<T> normalizeClassMeta(ClassMeta<T> cm) {
        if (cm == null) {
            return this.object();
        }
        if (cm.beanContext == this || cm.beanContext.equals(this)) {
            return cm;
        }
        if (cm.isMap()) {
            ClassMeta<T> cm2 = cm;
            cm2 = this.getMapClassMeta(cm2.getInnerClass(), cm2.getKeyType().getInnerClass(), cm2.getValueType().getInnerClass());
            return cm2;
        }
        if (cm.isCollection()) {
            ClassMeta<T> cm2 = cm;
            cm2 = this.getCollectionClassMeta(cm2.getInnerClass(), cm2.getElementType().getInnerClass());
            return cm2;
        }
        return this.getClassMeta(cm.getInnerClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ClassMeta<T> getClassMeta(Class<T> c) {
        if (c.isArray() && this.findPojoSwap(c) == null) {
            return new ClassMeta<T>(c, this);
        }
        if (this.cmCache == null) {
            return null;
        }
        ClassMeta<T> cm = this.cmCache.get(c);
        if (cm == null) {
            BeanContext beanContext = this;
            synchronized (beanContext) {
                cm = this.cmCache.get(c);
                if (cm == null) {
                    for (ClassMeta pcm : this.pendingClassMetas) {
                        if (pcm.innerClass != c) continue;
                        return pcm;
                    }
                    cm = new ClassMeta<T>(c, this, true);
                    this.pendingClassMetas.addLast(cm);
                    try {
                        cm.init();
                    }
                    finally {
                        this.pendingClassMetas.removeLast();
                    }
                    this.cmCache.put(c, cm);
                }
            }
        }
        return cm;
    }

    public <K, V, T extends Map<K, V>> ClassMeta<T> getMapClassMeta(Class<T> c, ClassMeta<K> keyType, ClassMeta<V> valueType) {
        if (keyType.isObject() && valueType.isObject()) {
            return this.getClassMeta(c);
        }
        return new ClassMeta<T>(c, this).setKeyType(keyType).setValueType(valueType);
    }

    public <K, V, T extends Map<K, V>> ClassMeta<T> getMapClassMeta(Class<T> c, Class<K> keyType, Class<V> valueType) {
        return this.getMapClassMeta(c, this.getClassMeta(keyType), this.getClassMeta(valueType));
    }

    public <T extends Map> ClassMeta<T> getMapClassMeta(Class<T> c, Type keyType, Type valueType) {
        return this.getMapClassMeta(c, this.getClassMeta(keyType), this.getClassMeta(valueType));
    }

    public <E, T extends Collection<E>> ClassMeta<T> getCollectionClassMeta(Class<T> c, ClassMeta<E> elementType) {
        if (elementType.isObject()) {
            return this.getClassMeta(c);
        }
        return new ClassMeta<T>(c, this).setElementType(elementType);
    }

    public <E, T extends Collection<E>> ClassMeta<T> getCollectionClassMeta(Class<T> c, Class<E> elementType) {
        return this.getCollectionClassMeta(c, this.getClassMeta(elementType));
    }

    public <T extends Collection> ClassMeta<T> getCollectionClassMeta(Class<T> c, Type elementType) {
        return this.getCollectionClassMeta(c, this.getClassMeta(elementType));
    }

    public ClassMeta getClassMeta(Type o) {
        return this.getClassMeta(o, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ClassMeta getClassMeta(Type o, Map<Class<?>, Class<?>[]> typeVarImpls) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            return (ClassMeta)o;
        }
        Class<?> c = null;
        if (o instanceof Class) {
            c = (Class<?>)o;
        } else if (o instanceof ParameterizedType) {
            c = (Class)((ParameterizedType)o).getRawType();
        } else if (o instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)o;
            Type gatct = gat.getGenericComponentType();
            if (gatct instanceof Class) {
                Class gatctc = (Class)gatct;
                c = Array.newInstance(gatctc, 0).getClass();
            } else {
                if (!(gatct instanceof ParameterizedType)) return null;
                Class gatctc = (Class)((ParameterizedType)gatct).getRawType();
                c = Array.newInstance(gatctc, 0).getClass();
            }
        } else {
            if (!(o instanceof TypeVariable)) return this.object();
            if (typeVarImpls == null) return this.object();
            TypeVariable t = (TypeVariable)o;
            String varName = t.getName();
            int varIndex = -1;
            Class gc = (Class)t.getGenericDeclaration();
            TypeVariable<Class<T>>[] tv = gc.getTypeParameters();
            for (int i = 0; i < tv.length; ++i) {
                if (!tv[i].getName().equals(varName)) continue;
                varIndex = i;
            }
            if (varIndex == -1) return this.object();
            if (typeVarImpls.containsKey(gc)) return this.getClassMeta(typeVarImpls.get(gc)[varIndex]);
            return this.object();
        }
        ClassMeta rawType = this.getClassMeta(c);
        if (!rawType.isMap() && !rawType.isCollection()) return rawType;
        ClassMeta[] params = this.findParameters(o, c);
        if (params == null) {
            return rawType;
        }
        if (rawType.isMap()) {
            if (params.length != 2) {
                return rawType;
            }
            if (!params[0].isObject() || !params[1].isObject()) return new ClassMeta(rawType.innerClass, this).setKeyType(params[0]).setValueType(params[1]);
            return rawType;
        }
        if (!rawType.isCollection()) return rawType;
        if (params.length != 1) {
            return rawType;
        }
        if (!params[0].isObject()) return new ClassMeta(rawType.innerClass, this).setElementType(params[0]);
        return rawType;
    }

    public ClassMeta<?>[] getClassMetas(Class<?>[] classes) {
        ThrowableUtils.assertFieldNotNull(classes, "classes");
        ClassMeta[] cm = new ClassMeta[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            cm[i] = this.getClassMeta(classes[i]);
        }
        return cm;
    }

    ClassMeta[] findParameters(Type o, Class c) {
        ParameterizedType pt;
        if (o == null) {
            o = c;
        }
        if (!(o instanceof ParameterizedType)) {
            block0: while (!((o = c.getGenericSuperclass()) instanceof ParameterizedType)) {
                for (Type t : c.getGenericInterfaces()) {
                    o = t;
                    if (o instanceof ParameterizedType) break block0;
                }
                if ((c = c.getSuperclass()) != null) continue;
            }
        }
        if (o instanceof ParameterizedType && !(pt = (ParameterizedType)o).getRawType().equals(Enum.class)) {
            LinkedList<ClassMeta> l = new LinkedList<ClassMeta>();
            for (Type pt2 : pt.getActualTypeArguments()) {
                if (pt2 instanceof WildcardType || pt2 instanceof TypeVariable) {
                    return null;
                }
                l.add(this.getClassMeta(pt2, null));
            }
            if (l.isEmpty()) {
                return null;
            }
            return l.toArray(new ClassMeta[l.size()]);
        }
        return null;
    }

    public <T> ClassMeta<T> getClassMetaForObject(T o) {
        if (o == null) {
            return null;
        }
        return this.getClassMeta(o.getClass());
    }

    protected <T> ClassMeta<T> getClassMeta(BeanProperty p, Type t, Map<Class<?>, Class<?>[]> typeVarImpls) {
        ClassMeta cm;
        ClassMeta cm2 = cm = this.getClassMeta(t, typeVarImpls);
        if (p != null) {
            if (p.type() != Object.class) {
                cm2 = this.getClassMeta(p.type(), typeVarImpls);
            }
            if (cm2.isMap()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray2 = new Class[2];
                    classArray2[0] = Object.class;
                    classArray = classArray2;
                    classArray2[1] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 2) {
                    throw new RuntimeException("Invalid number of parameters specified for Map (must be 2): " + pParams.length);
                }
                ClassMeta<?> keyType = this.resolveType(pParams[0], cm2.getKeyType(), cm.getKeyType());
                ClassMeta<?> valueType = this.resolveType(pParams[1], cm2.getValueType(), cm.getValueType());
                if (keyType.isObject() && valueType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2.innerClass, this).setKeyType(keyType).setValueType(valueType);
            }
            if (cm2.isCollection()) {
                Class<?>[] pParams;
                Class<?>[] classArray;
                if (p.params().length == 0) {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = Object.class;
                } else {
                    classArray = pParams = p.params();
                }
                if (pParams.length != 1) {
                    throw new RuntimeException("Invalid number of parameters specified for Collection (must be 1): " + pParams.length);
                }
                ClassMeta<?> elementType = this.resolveType(pParams[0], cm2.getElementType(), cm.getElementType());
                if (elementType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2.innerClass, this).setElementType(elementType);
            }
            return cm2;
        }
        return cm;
    }

    private ClassMeta<?> resolveType(Type ... t) {
        for (Type tt : t) {
            if (tt == null) continue;
            ClassMeta cm = this.getClassMeta(tt);
            if (tt == this.cmObject) continue;
            return cm;
        }
        return this.cmObject;
    }

    public ClassMeta<?> getClassMetaFromString(String s) {
        int d = 0;
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.charAt(0) == '[') {
            try {
                return this.getClassMeta(this.findClass(s));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        int i1 = 0;
        int i2 = 0;
        int dim = 0;
        LinkedList p = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                if (d == 0) {
                    i1 = i;
                    i2 = i + 1;
                    p = new LinkedList();
                }
                ++d;
            } else if (c == '>') {
                if (--d == 0 && p != null) {
                    p.add(this.getClassMetaFromString(s.substring(i2, i)));
                }
            } else if (c == ',' && d == 1) {
                if (p != null) {
                    p.add(this.getClassMetaFromString(s.substring(i2, i)));
                }
                i2 = i + 1;
            }
            if (c != '[') continue;
            if (i1 == 0) {
                i1 = i;
            }
            ++dim;
        }
        if (i1 == 0) {
            i1 = s.length();
        }
        try {
            String name = s.substring(0, i1).trim();
            char x = name.charAt(0);
            Class<Object> c = null;
            c = x >= 'b' && x <= 's' ? (x == 'b' && name.equals("boolean") ? Boolean.TYPE : (x == 'b' && name.equals("byte") ? Byte.TYPE : (x == 'c' && name.equals("char") ? Character.TYPE : (x == 'd' && name.equals("double") ? Double.TYPE : (x == 'i' && name.equals("int") ? Integer.TYPE : (x == 'l' && name.equals("long") ? Long.TYPE : (x == 's' && name.equals("short") ? Short.TYPE : this.findClass(name)))))))) : this.findClass(name);
            ClassMeta<?> cm = this.getClassMeta(c);
            if (p != null) {
                if (cm.isMap()) {
                    cm = new ClassMeta(c, this).setKeyType((ClassMeta)p.get(0)).setValueType((ClassMeta)p.get(1));
                }
                if (cm.isCollection()) {
                    cm = new ClassMeta(c, this).setElementType((ClassMeta)p.get(0));
                }
            }
            while (dim > 0) {
                cm = new ClassMeta(Array.newInstance(cm.getInnerClass(), 0).getClass(), this);
                --dim;
            }
            return cm;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> findClass(String name) throws ClassNotFoundException {
        return this.classLoader == null ? Class.forName(name) : Class.forName(name, true, this.classLoader);
    }

    protected <T> PojoSwap findPojoSwap(Class<T> c) {
        if (c != null) {
            for (PojoSwap<?, ?> f : this.pojoSwaps) {
                if (!ClassUtils.isParentClass(f.getNormalClass(), c)) continue;
                return f;
            }
        }
        return null;
    }

    protected boolean hasChildPojoSwaps(Class<?> c) {
        if (c != null) {
            for (PojoSwap<?, ?> f : this.pojoSwaps) {
                if (!ClassUtils.isParentClass(c, f.getNormalClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected <T> BeanFilter findBeanFilter(Class<T> c) {
        if (c != null) {
            for (BeanFilter f : this.beanFilters) {
                if (!ClassUtils.isParentClass(f.getBeanClass(), c)) continue;
                return f;
            }
        }
        return null;
    }

    public final String getBeanTypePropertyName() {
        return this.beanTypePropertyName;
    }

    public BeanDictionary getBeanDictionary() {
        return this.beanDictionary;
    }

    protected <T> Constructor<? extends T> getImplClassConstructor(Class<T> c, Visibility v) {
        if (this.implClasses.isEmpty()) {
            return null;
        }
        for (Class<T> cc = c; cc != null; cc = cc.getSuperclass()) {
            Class<?> implClass = this.implClasses.get(cc);
            if (implClass != null) {
                return ClassMeta.findNoArgConstructor(implClass, v);
            }
            for (Class<?> ic : cc.getInterfaces()) {
                implClass = this.implClasses.get(ic);
                if (implClass == null) continue;
                return ClassMeta.findNoArgConstructor(implClass, v);
            }
        }
        return null;
    }

    public <T> T convertToType(Object value, Class<T> type) throws InvalidDataConversionException {
        if (value != null && value.getClass() == type) {
            return (T)value;
        }
        return this.convertToType(null, value, this.getClassMeta(type));
    }

    public <T> T convertToType(Object outer, Object value, Class<T> type) throws InvalidDataConversionException {
        return this.convertToType(outer, value, this.getClassMeta(type));
    }

    public ClassMeta<Object> object() {
        return this.cmObject;
    }

    public ClassMeta<String> string() {
        return this.cmString;
    }

    public ClassMeta<Class> _class() {
        return this.cmClass;
    }

    public <T> T convertToType(Object value, ClassMeta<T> type) throws InvalidDataConversionException {
        return this.convertToType(null, value, type);
    }

    public <T> T convertToType(Object outer, Object value, ClassMeta<T> type) throws InvalidDataConversionException {
        if (type == null) {
            type = this.object();
        }
        try {
            String s;
            Object n;
            ClassMeta<Object> vt;
            if (value == null) {
                if (type.isPrimitive()) {
                    return (T)type.getPrimitiveDefault();
                }
                return null;
            }
            Class<Object> tc = type.getInnerClass();
            if (!(!tc.isInstance(value) || type.isMap() && type.getValueType().isNotObject() || type.isCollection() && type.getElementType().isNotObject())) {
                return (T)value;
            }
            if (tc == Class.class) {
                return (T)this.classLoader.loadClass(value.toString());
            }
            if (type.getPojoSwap() != null) {
                PojoSwap<Object, Object> f = type.getPojoSwap();
                Class<Object> nc = f.getNormalClass();
                Class<?> fc = f.getSwapClass();
                if (ClassUtils.isParentClass(nc, tc) && ClassUtils.isParentClass(fc, value.getClass())) {
                    return (T)f.unswap(value, type, this);
                }
            }
            if ((vt = this.getClassMetaForObject(value)).getPojoSwap() != null) {
                PojoSwap<Object, ?> f = vt.getPojoSwap();
                Class<Object> nc = f.getNormalClass();
                Class<?> fc = f.getSwapClass();
                if (ClassUtils.isParentClass(nc, vt.getInnerClass()) && ClassUtils.isParentClass(fc, tc)) {
                    return (T)f.swap(value, this);
                }
            }
            if (type.isPrimitive()) {
                if (value.toString().isEmpty()) {
                    return (T)type.getPrimitiveDefault();
                }
                if (type.isNumber()) {
                    if (value instanceof Number) {
                        n = (Number)value;
                        if (tc == Integer.TYPE) {
                            return (T)Integer.valueOf(((Number)n).intValue());
                        }
                        if (tc == Short.TYPE) {
                            return (T)Short.valueOf(((Number)n).shortValue());
                        }
                        if (tc == Long.TYPE) {
                            return (T)Long.valueOf(((Number)n).longValue());
                        }
                        if (tc == Float.TYPE) {
                            return (T)Float.valueOf(((Number)n).floatValue());
                        }
                        if (tc == Double.TYPE) {
                            return (T)Double.valueOf(((Number)n).doubleValue());
                        }
                        if (tc == Byte.TYPE) {
                            return (T)Byte.valueOf(((Number)n).byteValue());
                        }
                    } else {
                        n = null;
                        n = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : value.toString();
                        if (tc == Integer.TYPE) {
                            return (T)Integer.valueOf((String)n);
                        }
                        if (tc == Short.TYPE) {
                            return (T)Short.valueOf((String)n);
                        }
                        if (tc == Long.TYPE) {
                            return (T)Long.valueOf((String)n);
                        }
                        if (tc == Float.TYPE) {
                            return (T)new Float((String)n);
                        }
                        if (tc == Double.TYPE) {
                            return (T)new Double((String)n);
                        }
                        if (tc == Byte.TYPE) {
                            return (T)Byte.valueOf((String)n);
                        }
                    }
                } else {
                    if (type.isChar()) {
                        s = value.toString();
                        return (T)Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
                    }
                    if (type.isBoolean()) {
                        if (value instanceof Number) {
                            int i = ((Number)value).intValue();
                            return (T)(i == 0 ? Boolean.FALSE : Boolean.TRUE);
                        }
                        return (T)Boolean.valueOf(value.toString());
                    }
                }
            }
            if (type.isNumber()) {
                if (value instanceof Number) {
                    n = (Number)value;
                    if (tc == Integer.class) {
                        return (T)Integer.valueOf(((Number)n).intValue());
                    }
                    if (tc == Short.class) {
                        return (T)Short.valueOf(((Number)n).shortValue());
                    }
                    if (tc == Long.class) {
                        return (T)Long.valueOf(((Number)n).longValue());
                    }
                    if (tc == Float.class) {
                        return (T)Float.valueOf(((Number)n).floatValue());
                    }
                    if (tc == Double.class) {
                        return (T)Double.valueOf(((Number)n).doubleValue());
                    }
                    if (tc == Byte.class) {
                        return (T)Byte.valueOf(((Number)n).byteValue());
                    }
                    if (tc == Byte.class) {
                        return (T)Byte.valueOf(((Number)n).byteValue());
                    }
                    if (tc == AtomicInteger.class) {
                        return (T)new AtomicInteger(((Number)n).intValue());
                    }
                    if (tc == AtomicLong.class) {
                        return (T)new AtomicLong(((Number)n).intValue());
                    }
                } else {
                    if (value.toString().isEmpty()) {
                        return null;
                    }
                    n = null;
                    n = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : value.toString();
                    if (tc == Integer.class) {
                        return (T)Integer.valueOf((String)n);
                    }
                    if (tc == Short.class) {
                        return (T)Short.valueOf((String)n);
                    }
                    if (tc == Long.class) {
                        return (T)Long.valueOf((String)n);
                    }
                    if (tc == Float.class) {
                        return (T)new Float((String)n);
                    }
                    if (tc == Double.class) {
                        return (T)new Double((String)n);
                    }
                    if (tc == Byte.class) {
                        return (T)Byte.valueOf((String)n);
                    }
                    if (tc == AtomicInteger.class) {
                        return (T)new AtomicInteger(Integer.valueOf((String)n));
                    }
                    if (tc == AtomicLong.class) {
                        return (T)new AtomicLong(Long.valueOf((String)n));
                    }
                }
            }
            if (type.isChar()) {
                s = value.toString();
                return (T)Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
            }
            if (type.isArray()) {
                if (vt.isCollection()) {
                    return (T)this.toArray(type, (Collection)value);
                }
                if (vt.isArray()) {
                    return (T)this.toArray(type, Arrays.asList((Object[])value));
                }
                if (StringUtils.startsWith(value.toString(), '[')) {
                    return (T)this.toArray(type, new ObjectList(value.toString()).setBeanContext(this));
                }
            }
            if (type.isMap()) {
                try {
                    Map<String, Object> m;
                    if (value instanceof Map) {
                        m = type.canCreateNewInstance(outer) ? (Map)type.newInstance(outer) : new ObjectMap(this);
                        ClassMeta<?> keyType = type.getKeyType();
                        Object[] valueType = type.getValueType();
                        for (Map.Entry e : ((Map)value).entrySet()) {
                            Object k = e.getKey();
                            if (keyType.isNotObject()) {
                                k = keyType.isString() && k.getClass() != Class.class ? k.toString() : this.convertToType((Object)m, k, keyType);
                            }
                            Object v = e.getValue();
                            if (valueType.isNotObject()) {
                                v = this.convertToType((Object)m, v, (ClassMeta<T>)valueType);
                            }
                            m.put((String)k, v);
                        }
                        return (T)m;
                    }
                    if (!type.canCreateNewInstanceFromString(outer)) {
                        m = new ObjectMap(value.toString(), (Parser)this.defaultParser);
                        return (T)this.convertToType(outer, (Object)m, type);
                    }
                }
                catch (Exception e) {
                    throw new InvalidDataConversionException(value.getClass(), type, e);
                }
            }
            if (type.isCollection()) {
                try {
                    Collection<Object> l = type.canCreateNewInstance(outer) ? (Collection)type.newInstance(outer) : new ObjectList(this);
                    ClassMeta<?> elementType = type.getElementType();
                    if (value.getClass().isArray()) {
                        for (Object o : (Object[])value) {
                            l.add(elementType.isObject() ? o : this.convertToType(l, o, elementType));
                        }
                    } else if (value instanceof Collection) {
                        for (Object o : (Collection)value) {
                            l.add(elementType.isObject() ? o : this.convertToType(l, o, elementType));
                        }
                    } else if (value instanceof Map) {
                        l.add(elementType.isObject() ? value : this.convertToType(l, value, elementType));
                    } else if (!value.toString().isEmpty()) {
                        throw new InvalidDataConversionException(value.getClass(), type, null);
                    }
                    return (T)l;
                }
                catch (InvalidDataConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvalidDataConversionException(value.getClass(), type, e);
                }
            }
            if (type.isEnum()) {
                if (type.canCreateNewInstanceFromString(outer)) {
                    return (T)type.newInstanceFromString(outer, value.toString());
                }
                return (T)Enum.valueOf(tc, value.toString());
            }
            if (type.isString()) {
                if (vt.isArray() || vt.isMap() || vt.isCollection() || vt.isBean()) {
                    if (JsonSerializer.DEFAULT_LAX != null) {
                        return (T)JsonSerializer.DEFAULT_LAX.serialize(value);
                    }
                } else if (vt.isClass()) {
                    return (T)ClassUtils.getReadableClassName((Class)value);
                }
                return (T)value.toString();
            }
            if (type.isCharSequence()) {
                Class<?> c = value.getClass();
                if (c.isArray()) {
                    if (c.getComponentType().isPrimitive()) {
                        ObjectList l = new ObjectList(this);
                        int size = Array.getLength(value);
                        for (int i = 0; i < size; ++i) {
                            l.add(Array.get(value, i));
                        }
                        value = l;
                    }
                    value = new ObjectList((Object[])value).setBeanContext(this);
                }
                return (T)type.newInstanceFromString(outer, value.toString());
            }
            if (type.isBoolean()) {
                if (value instanceof Number) {
                    return (T)Boolean.valueOf(((Number)value).intValue() != 0);
                }
                return (T)Boolean.valueOf(value.toString());
            }
            if (type.isBean() && value instanceof Map) {
                return (T)this.newBeanMap(tc).load((Map)value).getBean();
            }
            if (type.canCreateNewInstanceFromObjectMap(outer) && value instanceof ObjectMap) {
                return (T)type.newInstanceFromObjectMap(outer, (ObjectMap)value);
            }
            if (type.canCreateNewInstanceFromNumber(outer) && value instanceof Number) {
                return (T)type.newInstanceFromNumber(outer, (Number)value);
            }
            if (type.canCreateNewInstanceFromString(outer)) {
                return (T)type.newInstanceFromString(outer, value.toString());
            }
            if (type.isBean()) {
                return (T)this.newBeanMap(type.getInnerClass()).load(value.toString()).getBean();
            }
        }
        catch (Exception e) {
            throw new InvalidDataConversionException(value, type, e);
        }
        throw new InvalidDataConversionException(value, type, null);
    }

    public Object toArray(ClassMeta<?> type, Collection<?> list) {
        if (list == null) {
            return null;
        }
        ClassMeta<?> componentType = type.getElementType();
        Object array = Array.newInstance(componentType.getInnerClass(), list.size());
        int i = 0;
        for (Object o : list) {
            if (!type.getInnerClass().isInstance(o)) {
                o = componentType.isArray() && o instanceof Collection ? this.toArray(componentType, (Collection)o) : (o == null && componentType.isPrimitive() ? componentType.getPrimitiveDefault() : this.convertToType(null, o, componentType));
            }
            try {
                Array.set(array, i++, o);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return array;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof BeanContext) {
            return ((BeanContext)o).hashCode == this.hashCode;
        }
        return false;
    }

    public String toString() {
        ObjectMap m = new ObjectMap().append("id", System.identityHashCode(this)).append("beansRequireDefaultConstructor", this.beansRequireDefaultConstructor).append("beansRequireSerializable", this.beansRequireSerializable).append("beansRequireSettersForGetters", this.beansRequireSettersForGetters).append("beansRequireSomeProperties", this.beansRequireSomeProperties).append("beanMapPutReturnsOldValue", this.beanMapPutReturnsOldValue).append("beanConstructorVisibility", (Object)this.beanConstructorVisibility).append("beanClassVisibility", (Object)this.beanClassVisibility).append("beanMethodVisibility", (Object)this.beanMethodVisibility).append("beanFieldVisibility", (Object)this.beanFieldVisibility).append("useInterfaceProxies", this.useInterfaceProxies).append("ignoreUnknownBeanProperties", this.ignoreUnknownBeanProperties).append("ignoreUnknownNullBeanProperties", this.ignoreUnknownNullBeanProperties).append("ignorePropertiesWithoutSetters", this.ignorePropertiesWithoutSetters).append("ignoreInvocationExceptionsOnGetters", this.ignoreInvocationExceptionsOnGetters).append("ignoreInvocationExceptionsOnSetters", this.ignoreInvocationExceptionsOnSetters).append("useJavaBeanIntrospector", this.useJavaBeanIntrospector).append("beanFilters", this.beanFilters).append("pojoSwaps", this.pojoSwaps).append("notBeanClasses", this.notBeanClasses).append("implClasses", this.implClasses).append("sortProperties", this.sortProperties);
        try {
            return m.toString(JsonSerializer.DEFAULT_LAX_READABLE);
        }
        catch (SerializeException e) {
            return e.getLocalizedMessage();
        }
    }
}

