/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jexl3Function
extends AbstractFunction
implements ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(Jexl3Function.class);
    private static final String KEY = "__jexl3";
    private static final List<String> desc = new LinkedList<String>();
    private static final ThreadLocal<JexlEngine> threadLocalJexl = new ThreadLocal();
    private Object[] values;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String str = "";
        CompoundVariable var = (CompoundVariable)this.values[0];
        String exp = var.execute();
        String varName = "";
        if (this.values.length > 1) {
            varName = ((CompoundVariable)this.values[1]).execute().trim();
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        try {
            MapContext jc = new MapContext();
            jc.set("log", (Object)log);
            jc.set("ctx", (Object)jmctx);
            jc.set("vars", (Object)vars);
            jc.set("props", (Object)JMeterUtils.getJMeterProperties());
            jc.set("threadName", (Object)Thread.currentThread().getName());
            jc.set("sampler", (Object)currentSampler);
            jc.set("sampleResult", (Object)previousResult);
            jc.set("OUT", (Object)System.out);
            JexlExpression e = Jexl3Function.getJexlEngine().createExpression(exp);
            Object o = e.evaluate((JexlContext)jc);
            if (o != null) {
                str = o.toString();
            }
            if (vars != null && varName.length() > 0) {
                vars.put(varName, str);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while evaluating the expression \"" + exp + "\"\n", (Throwable)e);
        }
        return str;
    }

    private static JexlEngine getJexlEngine() {
        JexlEngine engine = threadLocalJexl.get();
        if (engine == null) {
            engine = new JexlBuilder().cache(512).silent(true).strict(true).debug(false).arithmetic((JexlArithmetic)new JMeterArithmetic(true)).create();
            threadLocalJexl.set(engine);
        }
        return engine;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.values = parameters.toArray();
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        JexlEngine engine = threadLocalJexl.get();
        if (engine != null) {
            engine.clearCache();
            threadLocalJexl.remove();
        }
    }

    static {
        desc.add(JMeterUtils.getResString((String)"jexl_expression"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }

    private static class JMeterArithmetic
    extends JexlArithmetic {
        public JMeterArithmetic(boolean astrict) {
            super(astrict);
        }

        public int size(JMeterArithmetic jma) {
            return 1;
        }
    }
}

