/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.es;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.query.text.es.ESSettings;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexES
implements TextIndex {
    private final EntityDefinition docDef;
    private static Client client;
    private final String indexName;
    static final String CLUSTER_NAME_PARAM = "cluster.name";
    static final String NUM_OF_SHARDS_PARAM = "number_of_shards";
    static final String NUM_OF_REPLICAS_PARAM = "number_of_replicas";
    private static final String DASH = "-";
    private static final String UNDERSCORE = "_";
    private static final String COLON = ":";
    private static final String ASTERISK = "*";
    private static final String ADD_UPDATE_SCRIPT = "if((ctx._source == null) || (ctx._source.<fieldName> == null) || (ctx._source.<fieldName>.empty == true)) {ctx._source.<fieldName>=[params.fieldValue] } else {ctx._source.<fieldName>.add(params.fieldValue)}";
    private static final String DELETE_SCRIPT = "if((ctx._source != null) && (ctx._source.<fieldToRemove> != null) && (ctx._source.<fieldToRemove>.empty != true) && (ctx._source.<fieldToRemove>.indexOf(params.valueToRemove) >= 0)) {ctx._source.<fieldToRemove>.remove(ctx._source.<fieldToRemove>.indexOf(params.valueToRemove))}";
    static final Integer MAX_RESULTS;
    private static final Logger LOGGER;

    public TextIndexES(TextIndexConfig config, ESSettings esSettings) {
        this.indexName = esSettings.getIndexName();
        this.docDef = config.getEntDef();
        this.docDef.setLangField("lang");
        try {
            IndicesExistsResponse exists;
            if (client == null) {
                LOGGER.debug("Initializing the Elastic Search Java Client with settings: " + esSettings);
                Settings settings = Settings.builder().put(CLUSTER_NAME_PARAM, esSettings.getClusterName()).build();
                ArrayList<InetSocketTransportAddress> addresses = new ArrayList<InetSocketTransportAddress>();
                for (String host : esSettings.getHostToPortMapping().keySet()) {
                    InetSocketTransportAddress addr = new InetSocketTransportAddress(InetAddress.getByName(host), esSettings.getHostToPortMapping().get(host).intValue());
                    addresses.add(addr);
                }
                InetSocketTransportAddress[] socketAddresses = new InetSocketTransportAddress[addresses.size()];
                PreBuiltTransportClient tc = new PreBuiltTransportClient(settings, new Class[0]);
                tc.addTransportAddresses((TransportAddress[])addresses.toArray(socketAddresses));
                client = tc;
                LOGGER.debug("Successfully initialized the client");
            }
            if (!(exists = (IndicesExistsResponse)client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.indexName})).get()).isExists()) {
                Settings indexSettings = Settings.builder().put(NUM_OF_SHARDS_PARAM, esSettings.getShards().intValue()).put(NUM_OF_REPLICAS_PARAM, esSettings.getReplicas().intValue()).build();
                LOGGER.debug("Index with name " + this.indexName + " does not exist yet. Creating one with settings: " + indexSettings.toString());
                client.admin().indices().prepareCreate(this.indexName).setSettings(indexSettings).get();
            }
        }
        catch (Exception e) {
            throw new TextIndexException("Exception occurred while instantiating ElasticSearch Text Index", (Throwable)e);
        }
    }

    public TextIndexES(TextIndexConfig config, Client client, String indexName) {
        this.docDef = config.getEntDef();
        TextIndexES.client = client;
        this.indexName = indexName;
    }

    public void prepareCommit() {
    }

    public void commit() {
    }

    public void rollback() {
    }

    public void close() {
    }

    public void updateEntity(Entity entity) {
        this.addEntity(entity);
    }

    public void addEntity(Entity entity) {
        LOGGER.debug("Adding/Updating the entity in ES");
        String fieldToAdd = null;
        String fieldValueToAdd = null;
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            for (String field : this.docDef.fields()) {
                if (entity.get(field) != null) {
                    fieldToAdd = entity.getLanguage() != null && !entity.getLanguage().isEmpty() ? this.normalizeFieldName(field, entity.getLanguage()) : field;
                    fieldValueToAdd = (String)entity.get(field);
                    builder = builder.field(fieldToAdd, Arrays.asList(fieldValueToAdd));
                    break;
                }
                builder = builder.field(field, Collections.emptyList());
            }
            builder = builder.endObject();
            IndexRequest indexRequest = new IndexRequest(this.indexName, this.docDef.getEntityField(), entity.getId()).source(builder);
            String addUpdateScript = ADD_UPDATE_SCRIPT.replaceAll("<fieldName>", fieldToAdd);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fieldValue", fieldValueToAdd);
            UpdateRequest upReq = new UpdateRequest(this.indexName, this.docDef.getEntityField(), entity.getId()).script(new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", addUpdateScript, params)).upsert(indexRequest);
            UpdateResponse response = (UpdateResponse)client.update(upReq).get();
            LOGGER.debug("Received the following Update response : " + response + " for the following entity: " + entity);
        }
        catch (Exception e) {
            throw new TextIndexException("Unable to Index the Entity in ElasticSearch.", (Throwable)e);
        }
    }

    public void deleteEntity(Entity entity) {
        String fieldToRemove = null;
        String valueToRemove = null;
        for (String field : this.docDef.fields()) {
            if (entity.get(field) == null) continue;
            fieldToRemove = field;
            if (entity.getLanguage() != null && !entity.getLanguage().isEmpty()) {
                fieldToRemove = this.normalizeFieldName(fieldToRemove, entity.getLanguage());
            }
            valueToRemove = (String)entity.get(field);
            break;
        }
        if (fieldToRemove != null && valueToRemove != null) {
            LOGGER.debug("deleting content related to entity: " + entity.getId());
            String deleteScript = DELETE_SCRIPT.replaceAll("<fieldToRemove>", fieldToRemove);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("valueToRemove", valueToRemove);
            UpdateRequest updateRequest = new UpdateRequest(this.indexName, this.docDef.getEntityField(), entity.getId()).script(new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", deleteScript, params));
            try {
                client.update(updateRequest).get();
            }
            catch (Exception e) {
                if (ExceptionUtils.getRootCause((Throwable)e) instanceof DocumentMissingException) {
                    LOGGER.debug("Trying to delete values from a missing document. Ignoring deletion of entity: ", (Object)entity);
                }
                throw new TextIndexException("Unable to delete entity.", (Throwable)e);
            }
        }
    }

    public Map<String, Node> get(String uri) {
        GetResponse response;
        HashMap<String, Node> result = new HashMap<String, Node>();
        if (uri != null && (response = (GetResponse)client.prepareGet(this.indexName, this.docDef.getEntityField(), uri).get()) != null && !response.isSourceEmpty()) {
            String entityField = response.getId();
            Node entity = NodeFactory.createURI((String)entityField);
            result.put(this.docDef.getEntityField(), entity);
            Map source = response.getSource();
            for (String field : this.docDef.fields()) {
                List responseList;
                Object fieldResponse = source.get(field);
                if (fieldResponse == null || !(fieldResponse instanceof List) || (responseList = (List)fieldResponse) == null || responseList.size() <= 0) continue;
                String fieldValue = (String)responseList.get(0);
                Node fieldNode = NodeFactoryExtra.createLiteralNode((String)fieldValue, null, null);
                result.put(field, fieldNode);
            }
        }
        return result;
    }

    public List<TextHit> query(Node property, String qs, String graphURI, String lang) {
        return this.query(property, qs, graphURI, lang, MAX_RESULTS);
    }

    public List<TextHit> query(Node property, String qs, String graphURI, String lang, int limit, String highlight) {
        return this.query(property, qs, graphURI, lang, limit);
    }

    public List<TextHit> query(Node property, String qs, String graphURI, String lang, int limit) {
        qs = property != null ? this.parse(property.getLocalName(), qs, lang) : this.parse(null, qs, lang);
        LOGGER.debug("Querying ElasticSearch for QueryString: " + qs);
        SearchResponse response = (SearchResponse)client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.docDef.getEntityField()}).setQuery((QueryBuilder)QueryBuilders.queryStringQuery((String)qs)).setFetchSource(false).setFrom(0).setSize(limit).get();
        ArrayList<TextHit> results = new ArrayList<TextHit>();
        for (SearchHit hit : response.getHits()) {
            String entityField = hit.getId();
            Node entityNode = TextQueryFuncs.stringToNode((String)entityField);
            Float score = Float.valueOf(hit.getScore());
            TextHit textHit = new TextHit(entityNode, score.floatValue(), null);
            results.add(textHit);
        }
        return results;
    }

    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private String parse(String fieldName, String qs, String lang) {
        if (fieldName != null && !fieldName.isEmpty()) {
            if (lang != null && !lang.equals("none")) {
                if (!ASTERISK.equals(lang)) {
                    fieldName = fieldName + UNDERSCORE + lang.replaceAll(DASH, UNDERSCORE);
                    qs = fieldName + COLON + qs;
                } else if (!qs.contains("\\*")) {
                    fieldName = fieldName + ASTERISK;
                    qs = fieldName + COLON + qs;
                }
            } else {
                qs = fieldName + COLON + qs;
            }
        }
        return qs.replaceAll("\\*", "\\\\*");
    }

    private String normalizeFieldName(String fieldName, String lang) {
        StringBuilder sb = new StringBuilder(fieldName);
        return sb.append(UNDERSCORE).append(lang.replaceAll(DASH, UNDERSCORE)).toString();
    }

    static {
        MAX_RESULTS = 10000;
        LOGGER = LoggerFactory.getLogger(TextIndexES.class);
    }
}

