/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.es;

import java.util.HashMap;
import java.util.Map;

public class ESSettings {
    private Map<String, Integer> hostToPortMapping;
    private String clusterName;
    private Integer shards;
    private Integer replicas;
    private String indexName;

    public Map<String, Integer> getHostToPortMapping() {
        return this.hostToPortMapping;
    }

    public void setHostToPortMapping(Map<String, Integer> hostToPortMapping) {
        this.hostToPortMapping = hostToPortMapping;
    }

    public Builder builder() {
        return new Builder();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public Integer getShards() {
        return this.shards;
    }

    public void setShards(Integer shards) {
        this.shards = shards;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String toString() {
        return "ESSettings{hostToPortMapping=" + this.hostToPortMapping + ", clusterName='" + this.clusterName + '\'' + ", shards=" + this.shards + ", replicas=" + this.replicas + ", indexName='" + this.indexName + '}';
    }

    public static class Builder {
        ESSettings settings = new ESSettings();

        public Builder() {
            this.settings.setClusterName("elasticsearch");
            this.settings.setShards(1);
            this.settings.setReplicas(1);
            this.settings.setHostToPortMapping(new HashMap<String, Integer>());
            this.settings.setIndexName("jena-text");
        }

        public Builder indexName(String indexName) {
            if (indexName != null && !indexName.isEmpty()) {
                this.settings.setIndexName(indexName);
            }
            return this;
        }

        public Builder clusterName(String clusterName) {
            if (clusterName != null && !clusterName.isEmpty()) {
                this.settings.setClusterName(clusterName);
            }
            return this;
        }

        public Builder shards(Integer shards) {
            if (shards != null) {
                this.settings.setShards(shards);
            }
            return this;
        }

        public Builder replicas(Integer replicas) {
            if (replicas != null) {
                this.settings.setReplicas(replicas);
            }
            return this;
        }

        public Builder hostAndPort(String host, Integer port) {
            if (host != null && port != null) {
                this.settings.getHostToPortMapping().put(host, port);
            }
            return this;
        }

        public Builder hostAndPortMap(Map<String, Integer> hostAndPortMap) {
            if (hostAndPortMap != null) {
                this.settings.getHostToPortMapping().putAll(hostAndPortMap);
            }
            return this;
        }

        public ESSettings build() {
            return this.settings;
        }
    }
}

