/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.es.assembler;

import java.util.HashMap;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.query.text.es.ESSettings;
import org.apache.jena.query.text.es.TextESDatasetFactory;
import org.apache.jena.query.text.es.TextVocabES;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexESAssembler
extends AssemblerBase {
    private static Logger LOGGER = LoggerFactory.getLogger(TextIndexESAssembler.class);
    protected static final String COMMA = ",";
    protected static final String COLON = ":";

    public TextIndex open(Assembler a, Resource root, Mode mode) {
        try {
            String indexName;
            String replicationFactor;
            String numberOfShards;
            String listOfHostsAndPorts = GraphUtils.getAsStringValue((Resource)root, (Property)TextVocabES.pServerList);
            if (listOfHostsAndPorts == null || listOfHostsAndPorts.isEmpty()) {
                throw new TextIndexException("Mandatory property text:serverList (containing the comma-separated list of host:port) property is not specified. An example value for the property: 127.0.0.1:9300");
            }
            String[] hosts = listOfHostsAndPorts.split(COMMA);
            HashMap<String, Integer> hostAndPortMapping = new HashMap<String, Integer>();
            for (String host : hosts) {
                String[] hostAndPort = host.split(COLON);
                if (hostAndPort.length < 2) {
                    LOGGER.error("Either the host or the port value is missing.Please specify the property in host:port format. Both parts are mandatory. Ignoring this value. Moving to the next one.");
                    continue;
                }
                hostAndPortMapping.put(hostAndPort[0], Integer.valueOf(hostAndPort[1]));
            }
            String clusterName = GraphUtils.getAsStringValue((Resource)root, (Property)TextVocabES.pClusterName);
            if (clusterName == null || clusterName.isEmpty()) {
                LOGGER.warn("ClusterName property is not specified. Defaulting to 'elasticsearch'");
                clusterName = "elasticsearch";
            }
            if ((numberOfShards = GraphUtils.getAsStringValue((Resource)root, (Property)TextVocabES.pShards)) == null || numberOfShards.isEmpty()) {
                LOGGER.warn("shards property is not specified. Defaulting to '1'");
                numberOfShards = "1";
            }
            if ((replicationFactor = GraphUtils.getAsStringValue((Resource)root, (Property)TextVocabES.pReplicas)) == null || replicationFactor.isEmpty()) {
                LOGGER.warn("replicas property is not specified. Defaulting to '1'");
                replicationFactor = "1";
            }
            if ((indexName = GraphUtils.getAsStringValue((Resource)root, (Property)TextVocabES.pIndexName)) == null || indexName.isEmpty()) {
                LOGGER.warn("index Name property is not specified. Defaulting to 'jena-text'");
                indexName = "jena-text";
            }
            Resource r = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pEntityMap);
            EntityDefinition docDef = (EntityDefinition)a.open(r);
            TextIndexConfig config = new TextIndexConfig(docDef);
            ESSettings settings = new ESSettings().builder().clusterName(clusterName).hostAndPortMap(hostAndPortMapping).shards(Integer.valueOf(numberOfShards)).replicas(Integer.valueOf(replicationFactor)).indexName(indexName).build();
            return TextESDatasetFactory.createESIndex(config, settings);
        }
        catch (Exception e) {
            throw new TextIndexException("An exception occurred while trying to open/load the Assembler configuration. ", (Throwable)e);
        }
    }
}

