/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.JenaTextExample1;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.util.QueryExecUtils;

public class JenaESTextExample {
    public static void main(String[] args) {
        JenaESTextExample.queryData(JenaESTextExample.loadData(JenaESTextExample.createAssembler()));
    }

    private static Dataset createAssembler() {
        String assemblerFile = "text-config-es.ttl";
        Dataset ds = DatasetFactory.assemble((String)assemblerFile, (String)"http://localhost/jena_example/#text_dataset");
        return ds;
    }

    private static Dataset loadData(Dataset ds) {
        JenaTextExample1.loadData((Dataset)ds, (String)"data-es.ttl");
        return ds;
    }

    private static void queryData(Dataset ds) {
        JenaESTextExample.queryDataWithoutProperty(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryDataWithoutProperty(Dataset dataset) {
        String pre = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/>", "PREFIX text: <http://jena.apache.org/text#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"});
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT * ", "{ ?s text:query ('2016-12-01T15:31:10-05:00') ;", "      rdfs:label ?label", " }"});
        dataset.begin(ReadWrite.READ);
        try {
            Query q = QueryFactory.create((String)(pre + "\n" + qs));
            QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Dataset)dataset);
            QueryExecUtils.executeQuery((Prologue)q, (QueryExecution)qexec);
        }
        finally {
            dataset.end();
        }
    }
}

