/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.runner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.parser.ShExC;
import org.apache.jena.shex.parser.ShexParseException;
import org.apache.jena.shex.runner.AbstractRunnerFiles;
import org.apache.jena.shex.sys.SysShex;
import org.junit.Assert;
import org.junit.runners.model.InitializationError;

public class RunnerShexBadSyntax
extends AbstractRunnerFiles {
    public RunnerShexBadSyntax(Class<?> klass) throws InitializationError {
        super(klass, RunnerShexBadSyntax::makeShexBadSyntaxTest, RunnerShexBadSyntax.includes(), RunnerShexBadSyntax.excludes());
    }

    private static Set<String> includes() {
        HashSet<String> includes = new HashSet<String>();
        return includes;
    }

    private static Set<String> excludes() {
        HashSet<String> excludes = new HashSet<String>();
        if (!SysShex.STRICT) {
            excludes.add("1iriLength2.shex");
            excludes.add("1literalLength2.shex");
            excludes.add("1unknowndatatypeMaxInclusive.shex");
        }
        return excludes;
    }

    public static Runnable makeShexBadSyntaxTest(String filename) {
        return () -> RunnerShexBadSyntax.fileBadSyntax(filename);
    }

    public static ShexSchema fileBadSyntax(String filename) {
        String str = IO.readWholeFileAsUTF8((String)filename);
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        try {
            ShexSchema shapes = ShExC.parse((InputStream)input, (String)filename, null);
            System.out.print("-- ");
            System.out.println(FileOps.basename((String)filename));
            System.out.println(str);
            Assert.fail((String)"Parsed negative syntax test");
            return shapes;
        }
        catch (ShexParseException ex) {
            return null;
        }
    }
}

