/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.runner;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.parser.ShexParseException;
import org.apache.jena.shex.runner.AbstractRunnerFiles;
import org.apache.jena.shex.writer.WriterShExC;
import org.junit.Assert;
import org.junit.runners.model.InitializationError;

public class RunnerPrintShex
extends AbstractRunnerFiles {
    public RunnerPrintShex(Class<?> klass) throws InitializationError {
        super(klass, RunnerPrintShex::makeShexPrintTest, RunnerPrintShex.includes(), RunnerPrintShex.excludes());
    }

    private static Set<String> includes() {
        HashSet<String> includes = new HashSet<String>();
        return includes;
    }

    private static Set<String> excludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("1refbnode_with_spanning_PN_CHARS_BASE1.shex");
        excludes.add("_all.shex");
        return excludes;
    }

    private static Runnable makeShexPrintTest(String filename) {
        return () -> RunnerPrintShex.testShexPrint(filename);
    }

    public static void testShexPrint(String FN) {
        ShexSchema schema2;
        ShexSchema schema = Shex.readSchema((String)FN);
        IndentedLineBuffer out = new IndentedLineBuffer();
        String label = FN;
        out.println("## Print");
        WriterShExC.print((IndentedWriter)out, (ShexSchema)schema);
        String s = out.toString();
        try {
            schema2 = Shex.schemaFromString((String)s);
        }
        catch (ShexParseException ex) {
            RunnerPrintShex.printFile(FN);
            System.out.println("-- --");
            System.out.println(s);
            System.out.println("** Syntax error ** " + FN);
            String msg = ex.getMessage();
            int i = msg.indexOf(10);
            if (i > 0) {
                msg = msg.substring(0, i);
            }
            System.out.println("** " + msg);
            IndentedWriter out2 = IndentedWriter.stdout.clone();
            out2.setLineNumbers(true);
            WriterShExC.print((IndentedWriter)out2, (ShexSchema)schema);
            System.out.println("-- --");
            Shex.printSchema((ShexSchema)schema);
            System.out.println("== ==");
            throw ex;
        }
        boolean equivalent = schema.sameAs((Object)schema2);
        if (!equivalent && !s.contains("_:")) {
            RunnerPrintShex.printFile(FN);
            System.out.println("** Not same ** " + label);
            System.out.println(s);
            System.out.println("-- --");
            Shex.printSchema((OutputStream)System.out, (ShexSchema)schema);
            System.out.println("-- --");
            Shex.printSchema((OutputStream)System.out, (ShexSchema)schema2);
            System.out.println("== ==");
            Assert.fail((String)"ShEx schames not equivalent");
        }
    }

    private static void printFile(String FN) {
        System.out.println("File: " + FN);
        System.out.print(IO.readWholeFileAsUTF8((String)FN));
    }

    private static void printString(String s) {
        System.out.print(s);
        if (!s.endsWith("\n")) {
            System.out.println();
        }
        System.out.println("-- --");
    }
}

