/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.runner;

import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.runner.ShexT;
import org.apache.jena.shex.runner.ShexTests;
import org.apache.jena.shex.sys.ShexLib;
import org.junit.Assert;

public class ShexValidationTest
implements Runnable {
    private final ManifestEntry entry;
    private final TestType testType;
    private final String schema;
    private final Node shape;
    private final Resource data;
    private final Node focus;
    private final ShexSchema shapes;
    private final String shapeMapURI;
    private final ShexMap shapeMap;
    private final boolean positiveTest;
    private final boolean verbose = false;

    static Runnable testShexValidationShapeFocus(ManifestEntry entry) {
        Resource action = entry.getAction();
        Resource schema = action.getProperty(ShexT.schema).getResource();
        Resource shape = action.getProperty(ShexT.shape).getResource();
        Resource data = action.getProperty(ShexT.data).getResource();
        RDFNode focus = action.getProperty(ShexT.focus).getObject();
        return new ShexValidationTest(entry, data, schema, shape, null, focus, TestType.ShapeFocus);
    }

    static Runnable testShexValidationStartFocus(ManifestEntry entry) {
        Resource action = entry.getAction();
        Resource schema = action.getProperty(ShexT.schema).getResource();
        Resource data = action.getProperty(ShexT.data).getResource();
        RDFNode focus = action.getProperty(ShexT.focus).getObject();
        return new ShexValidationTest(entry, data, schema, null, null, focus, TestType.StartFocus);
    }

    static Runnable testShexValidationMap(ManifestEntry entry) {
        Resource action = entry.getAction();
        Resource schema = action.getProperty(ShexT.schema).getResource();
        Resource map = action.getProperty(ShexT.map).getResource();
        Resource data = action.getProperty(ShexT.data).getResource();
        return new ShexValidationTest(entry, data, schema, null, map.getURI(), null, TestType.ShapeMap);
    }

    public ShexValidationTest(ManifestEntry entry, Resource data, Resource schema, Resource shape, String shapeMapRef, RDFNode focus, TestType testType) {
        String base = null;
        if (entry.getEntry().isURIResource()) {
            String fn = IRILib.IRIToFilename((String)entry.getEntry().getURI());
            int idx = fn.lastIndexOf(47);
            if (idx > 0) {
                base = fn.substring(0, idx + 1);
            }
            base = IRILib.filenameToIRI(base);
        }
        this.entry = entry;
        this.testType = testType;
        this.schema = schema.getURI();
        this.data = data;
        this.shape = shape != null ? shape.asNode() : null;
        this.focus = focus == null ? null : focus.asNode();
        this.shapeMapURI = shapeMapRef;
        this.shapeMap = shapeMapRef == null ? null : Shex.readShapeMapJson((String)shapeMapRef);
        this.shapes = Shex.readSchema((String)schema.getURI(), (String)base);
        this.positiveTest = entry.getTestType().equals((Object)ShexT.cValidationTest);
    }

    @Override
    public void run() {
        Graph graph = RDFDataMgr.loadGraph((String)this.data.getURI());
        try {
            boolean b;
            ShexReport report;
            if (ShexTests.dumpTest) {
                this.describeTest();
            }
            switch (this.testType) {
                case ShapeFocus: {
                    report = ShexValidator.get().validate(graph, this.shapes, this.shape, this.focus);
                    break;
                }
                case ShapeMap: {
                    report = ShexValidator.get().validate(graph, this.shapes, this.shapeMap);
                    break;
                }
                case StartFocus: {
                    ShexShape startShape = this.shapes.getStart();
                    report = ShexValidator.get().validate(graph, this.shapes, startShape, this.focus);
                    break;
                }
                default: {
                    throw new InternalErrorException("No test type");
                }
            }
            boolean bl = b = this.positiveTest == report.conforms();
            if (!b && !ShexTests.dumpTest) {
                this.describeTest();
            }
            Assert.assertEquals((String)this.entry.getName(), (Object)this.positiveTest, (Object)report.conforms());
        }
        catch (AssertionError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.describeTest();
            System.out.println("Exception: " + ex.getMessage());
            if (!(ex instanceof Error)) {
                ex.printStackTrace(System.out);
            } else {
                System.out.println(ex.getClass().getName());
            }
            Shex.printSchema((ShexSchema)this.shapes);
            throw ex;
        }
    }

    private void describeTest() {
        System.out.println("** " + ShexTests.fragment(this.entry));
        System.out.println("Schema:   " + this.schema);
        System.out.println("Data:     " + this.data);
        if (this.shape != null) {
            System.out.println("Shape:    " + ShexLib.displayStr((Node)this.shape));
        }
        if (this.focus != null) {
            System.out.println("Focus:    " + ShexLib.displayStr((Node)this.focus));
        }
        if (this.shapeMapURI != null) {
            System.out.println("Map:      " + this.shapeMapURI);
        }
        System.out.println("Positive: " + this.positiveTest);
        String fn = IRILib.IRIToFilename((String)this.schema);
        String s = IO.readWholeFileAsUTF8((String)fn);
        System.out.println("-- Schema:");
        System.out.print(s);
        if (!s.endsWith("\n")) {
            System.out.println();
        }
        if (this.shapeMapURI != null) {
            fn = IRILib.IRIToFilename((String)this.shapeMapURI);
            s = IO.readWholeFileAsUTF8((String)fn);
            System.out.println("-- Shape map:");
            System.out.print(s);
            if (!s.endsWith("\n")) {
                System.out.println();
            }
        }
        String dfn = IRILib.IRIToFilename((String)this.data.getURI());
        s = IO.readWholeFileAsUTF8((String)dfn);
        System.out.println("-- Data:");
        System.out.print(s);
        if (!s.endsWith("\n")) {
            System.out.println();
        }
        System.out.println("-- --");
        Shex.printSchema((ShexSchema)this.shapes);
        System.out.println("-- --");
    }

    static enum TestType {
        ShapeFocus,
        StartFocus,
        ShapeMap;

    }
}

