/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.runner;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.manifest.Prefix;
import org.apache.jena.arq.junit.runners.Label;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shex.expressions.Sx2;
import org.apache.jena.shex.runner.ShexT;
import org.apache.jena.shex.runner.ShexValidationTest;

public class ShexTests {
    static boolean VERBOSE = false;
    static Set<String> excludes = new HashSet<String>();
    static Set<String> includes = new LinkedHashSet<String>();
    static boolean dumpTest = false;
    static StreamManager streamMgr = StreamManager.get().clone();

    private static Collection<String> bNodeLabeltests() {
        HashSet<String> bNodeLabelTests = new HashSet<String>();
        bNodeLabelTests.add("#1focusLength-dot_fail-bnode-short");
        bNodeLabelTests.add("#1focusLength-dot_pass-bnode-equal");
        bNodeLabelTests.add("#1focusLength-dot_fail-bnode-long");
        bNodeLabelTests.add("#1focusMinLength-dot_pass-bnode-equal");
        bNodeLabelTests.add("#1focusMinLength-dot_pass-bnode-long");
        bNodeLabelTests.add("#1focusMaxLength-dot_pass-bnode-short");
        bNodeLabelTests.add("#1focusMaxLength-dot_pass-bnode-equal");
        bNodeLabelTests.add("#1focusPatternB-dot_pass-bnode-match");
        bNodeLabelTests.add("#1focusPatternB-dot_pass-bnode-long");
        bNodeLabelTests.add("#1focusBNODELength_dot_pass");
        bNodeLabelTests.add("#1bnodeLength_pass-bnode-equal");
        bNodeLabelTests.add("#1bnodeLength_fail-bnode-short");
        bNodeLabelTests.add("#1bnodeLength_pass-bnode-equal");
        bNodeLabelTests.add("#1bnodeLength_fail-bnode-long");
        bNodeLabelTests.add("#1bnodeLength_fail-lit-equal");
        bNodeLabelTests.add("#1bnodeLength_fail-iri-equal");
        bNodeLabelTests.add("#1nonliteralLength_fail-bnode-short");
        bNodeLabelTests.add("#1nonliteralLength_pass-bnode-equal");
        bNodeLabelTests.add("#1nonliteralLength_fail-bnode-long");
        bNodeLabelTests.add("#1bnodeMinlength_pass-bnode-equal");
        bNodeLabelTests.add("#1bnodeMinlength_pass-bnode-long");
        bNodeLabelTests.add("#1nonliteralMinlength_pass-bnode-equal");
        bNodeLabelTests.add("#1nonliteralMinlength_pass-bnode-long");
        bNodeLabelTests.add("#1bnodeMaxlength_pass-bnode-short");
        bNodeLabelTests.add("#1bnodeMaxlength_pass-bnode-equal");
        bNodeLabelTests.add("#1nonliteralMaxlength_pass-bnode-short");
        bNodeLabelTests.add("#1nonliteralMaxlength_pass-bnode-equal");
        bNodeLabelTests.add("#1bnodePattern_pass-bnode-match");
        bNodeLabelTests.add("#1bnodePattern_fail-bnode-short");
        bNodeLabelTests.add("#1bnodePattern_fail-bnode-long");
        bNodeLabelTests.add("#1bnodeMinlength_fail-bnode-short");
        bNodeLabelTests.add("#1bnodeMinlength_pass-bnode-equal");
        bNodeLabelTests.add("#1bnodeMinlength_pass-bnode-long");
        bNodeLabelTests.add("#1bnodePattern_pass-bnode-match");
        bNodeLabelTests.add("#1bnodePattern_fail-bnode-long");
        bNodeLabelTests.add("#1nonliteralPattern_pass-bnode-match");
        bNodeLabelTests.add("#1nonliteralPattern_pass-bnode-long");
        bNodeLabelTests.add("#1nonliteralMinlength_fail-bnode-short");
        bNodeLabelTests.add("#1nonliteralMinlength_pass-bnode-equal");
        bNodeLabelTests.add("#1nonliteralMinlength_pass-bnode-long");
        bNodeLabelTests.add("#1bnodeMaxlength_pass-bnode-short");
        bNodeLabelTests.add("#1bnodeMaxlength_pass-bnode-equal");
        bNodeLabelTests.add("#1bnodeMaxlength_fail-bnode-long");
        bNodeLabelTests.add("#1nonliteralMaxlength_pass-bnode-short");
        bNodeLabelTests.add("#1nonliteralMaxlength_pass-bnode-equal");
        bNodeLabelTests.add("#1nonliteralMaxlength_fail-bnode-long");
        bNodeLabelTests.add("#1valExprRefbnode-IV1_pass-lit-equal");
        bNodeLabelTests.add("#1focusBNODE_dot_fail-iriFocusLabel-equal");
        bNodeLabelTests.add("#1focusBNODE_dot_pass");
        bNodeLabelTests.add("#bnode1dot_fail-missing");
        bNodeLabelTests.add("#bnode1dot_pass-others_lexicallyEarlier");
        return bNodeLabelTests;
    }

    public static Runnable makeShexValidationTest(ManifestEntry entry) {
        if (!ShexTests.runTestExclusionsInclusions(entry)) {
            return null;
        }
        Resource testType = entry.getTestType();
        if (testType == null) {
            System.out.println("No test type: " + entry.getName());
            return null;
        }
        if (testType.equals((Object)ShexT.cRepresentationTest)) {
            return () -> {};
        }
        Resource action = entry.getAction();
        if (action == null) {
            System.out.println("Action expected: " + entry.getName());
            return null;
        }
        if (action.hasProperty(ShexT.semActs)) {
            // empty if block
        }
        if (action.hasProperty(ShexT.shapeExterns)) {
            // empty if block
        }
        if (testType == null) {
            // empty if block
        }
        if (!testType.equals((Object)ShexT.cValidationTest) && !testType.equals((Object)ShexT.cValidationFailure)) {
            System.err.println("Skip unknown test type for: " + entry.getName());
            return () -> {};
        }
        if (!action.hasProperty(ShexT.schema)) {
            System.err.println("Bad: no schema : " + entry.getName());
            return null;
        }
        if (action.hasProperty(ShexT.map)) {
            if (action.hasProperty(ShexT.shape) || action.hasProperty(ShexT.focus)) {
                System.err.println("Bad: map + (shape or focus) : " + entry.getName());
            }
            if (!action.hasProperty(ShexT.data) || !action.hasProperty(ShexT.schema)) {
                System.err.println("Bad: map + no (data+schema) : " + entry.getName());
            }
        } else if (!(action.hasProperty(ShexT.schema) && action.hasProperty(ShexT.data) && action.hasProperty(ShexT.focus))) {
            System.err.println("Bad: no map, no (scheme/data/focus) : " + entry.getName());
        }
        if (testType.equals((Object)ShexT.cValidationTest) || testType.equals((Object)ShexT.cValidationFailure)) {
            boolean faiureTest = testType.equals((Object)ShexT.cValidationFailure);
            if (action.hasProperty(ShexT.shape)) {
                try {
                    Resource schema = action.getProperty(ShexT.schema).getResource();
                    Resource shape = action.getProperty(ShexT.shape).getResource();
                    Resource data = action.getProperty(ShexT.data).getResource();
                    RDFNode focus = action.getProperty(ShexT.focus).getObject();
                    return ShexValidationTest.testShexValidationShapeFocus(entry);
                }
                catch (Exception ex) {
                    System.err.println(ex.getClass().getName());
                    System.err.println(ex.getMessage());
                    System.err.println(entry.getEntry().getLocalName());
                    return null;
                }
            }
            if (action.hasProperty(ShexT.focus)) {
                try {
                    Resource schema = action.getProperty(ShexT.schema).getResource();
                    Resource data = action.getProperty(ShexT.data).getResource();
                    RDFNode focus = action.getProperty(ShexT.focus).getObject();
                    return ShexValidationTest.testShexValidationStartFocus(entry);
                }
                catch (Exception schema) {
                    // empty catch block
                }
            }
            if (action.hasProperty(ShexT.map)) {
                try {
                    Resource schema = action.getProperty(ShexT.schema).getResource();
                    Resource map = action.getProperty(ShexT.map).getResource();
                    Resource data = action.getProperty(ShexT.data).getResource();
                    return ShexValidationTest.testShexValidationMap(entry);
                }
                catch (Exception ex) {
                    System.err.println(ex.getClass().getName());
                    System.err.println(ex.getMessage());
                    System.err.println(entry.getEntry().getLocalName());
                    return null;
                }
            }
            System.err.println("Unknown: " + entry.getName());
            return null;
        }
        Log.warn((Object)"ShexTests", (String)("Skip unknown test type for: " + entry.getName()));
        return null;
    }

    private static boolean runTestExclusionsInclusions(ManifestEntry entry) {
        String fragment = ShexTests.fragment(entry);
        if (fragment != null) {
            if (includes.contains(fragment)) {
                return true;
            }
            if (!includes.isEmpty()) {
                return false;
            }
            if (excludes.contains(fragment)) {
                return false;
            }
        }
        return true;
    }

    public static String fragment(ManifestEntry entry) {
        if (entry.getEntry().isURIResource()) {
            return ShexTests.fragment(entry.getEntry().getURI());
        }
        return null;
    }

    public static String fragment(String uri) {
        int j = uri.lastIndexOf(35);
        String fn = j >= 0 ? uri.substring(j) : uri;
        return fn;
    }

    static String getLabel(Class<?> klass) {
        Label annotation = klass.getAnnotation(Label.class);
        return annotation == null ? null : annotation.value();
    }

    static String getPrefix(Class<?> klass) {
        Prefix annotation = klass.getAnnotation(Prefix.class);
        return annotation == null ? null : annotation.value();
    }

    private static void setup() {
        String[] places;
        for (String dir : places = new String[]{"src/test/files/spec/schemas/", "src/test/files/spec/validation/"}) {
            LocatorShexTest alt = new LocatorShexTest(dir);
            streamMgr.addLocator((Locator)alt);
        }
        StreamManager.setGlobal((StreamManager)streamMgr);
    }

    static {
        ShexTests.setup();
        VERBOSE = !includes.isEmpty();
        excludes.add("#shapeExtern_pass");
        excludes.add("#shapeExtern_fail");
        excludes.add("#shapeExternRef_pass");
        excludes.add("#shapeExternRef_fail");
        excludes.add("#1dotCode1_pass");
        excludes.add("#1dotNoCode1_pass");
        excludes.add("#1inversedotCode1_pass");
        excludes.add("#1dotCode3_pass");
        excludes.add("#1dotNoCode3_pass");
        excludes.add("#1dotCode3fail_abort");
        excludes.add("#1dotCodeWithEscapes1_pass");
        excludes.add("#1dotShapeCode1_pass");
        excludes.add("#1dotShapeNoCode1_pass");
        excludes.add("#open3EachdotcloseCode1-p1p2p3");
        excludes.add("#startCode1_pass");
        excludes.add("#startNoCode1_pass");
        excludes.add("#startCode1fail_abort");
        excludes.add("#startCode1startRef_pass");
        excludes.add("#startCode1startReffail_abort");
        excludes.add("#startCode3_pass");
        excludes.add("#startCode3fail_abort");
        excludes.add("#open3Eachdotclosecard23Annot3Code2-p1p2p3X3");
        excludes.addAll(ShexTests.bNodeLabeltests());
        if (VERBOSE) {
            System.err.println("Validation");
            System.err.println("  inclusions    = " + includes.size());
            System.err.println("  exclusions    = " + (excludes.size() - ShexTests.bNodeLabeltests().size()));
            System.err.println("  bNode labels  = " + ShexTests.bNodeLabeltests().size());
            System.err.println();
            boolean bl = dumpTest = !includes.isEmpty();
        }
        if (!includes.isEmpty()) {
            Sx2.TRACE = true;
        }
    }

    static class LocatorShexTest
    extends LocatorFile {
        public LocatorShexTest(String dir) {
            super(dir);
        }

        public TypedInputStream open(String filenameOrURL) {
            String fn = FileOps.basename((String)filenameOrURL);
            Object url = fn.endsWith(".shex") ? fn : fn + ".shex";
            return super.open((String)url);
        }

        public String getName() {
            return "LocatorShexTest";
        }
    }
}

