/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.runner;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.parser.ShExC;
import org.apache.jena.shex.runner.AbstractRunnerFiles;
import org.junit.runners.model.InitializationError;

public class RunnerShexSyntax
extends AbstractRunnerFiles {
    public RunnerShexSyntax(Class<?> klass) throws InitializationError {
        super(klass, RunnerShexSyntax::makeShexBadSyntaxTest, RunnerShexSyntax.includes(), RunnerShexSyntax.excludes());
    }

    private static Set<String> includes() {
        HashSet<String> includes = new HashSet<String>();
        return includes;
    }

    private static Set<String> excludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("1refbnode_with_spanning_PN_CHARS_BASE1.shex");
        excludes.add("_all.shex");
        return excludes;
    }

    public static Runnable makeShexBadSyntaxTest(String filename) {
        return () -> RunnerShexSyntax.shapesFromFileBadSyntax(filename);
    }

    public static ShexSchema shapesFromFileBadSyntax(String filename) {
        String str = IO.readWholeFileAsUTF8((String)filename);
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        try {
            ShexSchema shapes = ShExC.parse((InputStream)input, (String)filename, null);
            return shapes;
        }
        catch (RuntimeException ex) {
            System.out.print("-- ");
            System.out.println(FileOps.basename((String)filename));
            if (ex.getMessage() != null) {
                System.out.println(ex.getMessage());
            } else {
                System.out.println(ex.getClass().getSimpleName());
            }
            System.out.println(str);
            throw ex;
        }
    }
}

