/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.runner;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.arq.junit.runners.Directories;
import org.apache.jena.arq.junit.runners.RunnerOneTest;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.shex.runner.ShexTests;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public abstract class AbstractRunnerFiles
extends ParentRunner<Runner> {
    private Description description;
    private List<Runner> children = new ArrayList<Runner>();
    private static boolean PrintManifests = false;
    private static IndentedWriter out = IndentedWriter.stdout;

    public AbstractRunnerFiles(Class<?> klass, Function<String, Runnable> maker, Set<String> includes, Set<String> excludes) throws InitializationError {
        super(klass);
        String label = ShexTests.getLabel(klass);
        if (label == null) {
            label = klass.getName();
        }
        String prefix = ShexTests.getPrefix(klass);
        String[] directories = AbstractRunnerFiles.getDirectories(klass);
        this.description = Description.createSuiteDescription((String)label, (Annotation[])new Annotation[0]);
        for (String directory : directories) {
            List<String> files = this.getFiles(directory, includes, excludes);
            if (files.isEmpty()) {
                throw new InitializationError("No files");
            }
            for (String file : files) {
                RunnerOneTest runner = AbstractRunnerFiles.buildTest(file, maker, prefix);
                if (runner == null) continue;
                this.description.addChild(runner.getDescription());
                this.children.add((Runner)runner);
            }
        }
        if (ShexTests.VERBOSE) {
            System.err.println(label);
            System.err.println("  inclusions    = " + includes.size());
            System.err.println("  exclusions    = " + excludes.size());
            System.err.println();
        }
    }

    protected final List<String> getFiles(String directory, Set<String> includes, Set<String> excludes) {
        Path src = Path.of(directory, new String[0]);
        BiPredicate<Path, BasicFileAttributes> predicate = (path, attr) -> attr.isRegularFile() && path.toString().endsWith(".shex");
        ArrayList<String> files = new ArrayList<String>();
        if (includes.isEmpty()) {
            try {
                Files.find(src, 1, predicate, new FileVisitOption[0]).filter(p -> !excludes.contains(p.getFileName().toString())).sorted().map(Path::toString).forEach(files::add);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            includes.forEach(fn -> files.add((String)fn));
        }
        return files;
    }

    public static RunnerOneTest buildTest(String filename, Function<String, Runnable> maker, String prefix) {
        Description description = Description.createSuiteDescription((String)filename, (Annotation[])new Annotation[0]);
        Runnable runnable = maker.apply(filename);
        String name = StringUtils.isEmpty((CharSequence)prefix) ? AbstractRunnerFiles.fixupName(filename) : prefix + " " + AbstractRunnerFiles.fixupName(filename);
        return new RunnerOneTest(filename, runnable);
    }

    public static String fixupName(String string) {
        string = string.replace('(', '[');
        string = string.replace(')', ']');
        return string;
    }

    private static String[] getDirectories(Class<?> klass) throws InitializationError {
        Directories directories = klass.getAnnotation(Directories.class);
        if (directories == null) {
            throw new InitializationError(String.format("class '%s' must have a @Directories annotation", klass.getName()));
        }
        return directories.value();
    }

    public Description getDescription() {
        return this.description;
    }

    protected List<Runner> getChildren() {
        return this.children;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

