/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.parser.ShExC;
import org.apache.jena.shex.parser.ShexParseException;
import org.junit.Assert;
import org.junit.Test;

public class TestShexShapeMapSyntax {
    @Test
    public void shape_map_1() {
        String s = StrUtils.strjoinNL((String[])new String[]{"<http://data.example/#n1> @ <http://data.example/#S2> ,", "\"chat\"@en-fr@<http://data.example/S3> ,", "{FOCUS a <http://schema.example/Some/Type>}@START ,", "{_ <http://data.example/p3> FOCUS}@START"});
        ShexMap map = this.parseShapeMap(s);
        Assert.assertNotNull((Object)map);
        Assert.assertNotNull((Object)map.entries());
        Assert.assertEquals((long)4L, (long)map.entries().size());
    }

    @Test
    public void shape_map_2() {
        String s = StrUtils.strjoinNL((String[])new String[]{"BASE  <http://data.example/>", "PREFIX : <http://data.example/#>", "", "<#n1> @ :S2 . ", "'xyz'^^:datatype @ START", "{FOCUS a <Some/Type>} @ :Shape", "{_ :p3 FOCUS } @START . "});
        ShexMap map = this.parseShapeMap(s);
        Assert.assertNotNull((Object)map);
        Assert.assertNotNull((Object)map.entries());
        Assert.assertEquals((long)4L, (long)map.entries().size());
    }

    @Test(expected=ShexParseException.class)
    public void shape_map_3() {
        String s = StrUtils.strjoinNL((String[])new String[]{"BASE  <http://data.example/>", "PREFIX : <http://data.example/#>", "", "{_ :p3 FOCUS } @START ,"});
        this.parseShapeMap(s);
    }

    private ShexMap parseShapeMap(String s) {
        ByteArrayInputStream input = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        ShexMap shapeMap = ShExC.parseShapeMap((InputStream)input, null);
        return shapeMap;
    }
}

