/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class B64Code {
    static final char pad = '=';
    static final char[] rfc1421alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static final byte[] rfc1421nibbles = new byte[256];

    public static String encode(String s) {
        try {
            return B64Code.encode(s, null);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException(e2.toString());
        }
    }

    public static String encode(String s, String charEncoding) throws UnsupportedEncodingException {
        byte[] bytes = charEncoding == null ? s.getBytes("ISO-8859-1") : s.getBytes(charEncoding);
        return new String(B64Code.encode(bytes));
    }

    public static char[] encode(byte[] b) {
        return B64Code.encode(b, false);
    }

    public static char[] encode(byte[] b, boolean rfc2045) {
        byte b1;
        byte b0;
        if (b == null) {
            return null;
        }
        int bLen = b.length;
        int cLen = (bLen + 2) / 3 * 4;
        if (rfc2045) {
            cLen += 2 + 2 * cLen / 76;
        }
        char[] c = new char[cLen];
        int ci = 0;
        int bi = 0;
        int stop = bLen / 3 * 3;
        int l = 0;
        while (bi < stop) {
            b0 = b[bi++];
            b1 = b[bi++];
            byte b2 = b[bi++];
            c[ci++] = rfc1421alphabet[b0 >>> 2 & 0x3F];
            c[ci++] = rfc1421alphabet[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
            c[ci++] = rfc1421alphabet[b1 << 2 & 0x3F | b2 >>> 6 & 3];
            c[ci++] = rfc1421alphabet[b2 & 0x3F];
            if (!rfc2045 || (l += 4) % 76 != 0) continue;
            c[ci++] = 13;
            c[ci++] = 10;
        }
        if (bLen != bi) {
            switch (bLen % 3) {
                case 2: {
                    b0 = b[bi++];
                    b1 = b[bi++];
                    c[ci++] = rfc1421alphabet[b0 >>> 2 & 0x3F];
                    c[ci++] = rfc1421alphabet[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                    c[ci++] = rfc1421alphabet[b1 << 2 & 0x3F];
                    c[ci++] = 61;
                    break;
                }
                case 1: {
                    b0 = b[bi++];
                    c[ci++] = rfc1421alphabet[b0 >>> 2 & 0x3F];
                    c[ci++] = rfc1421alphabet[b0 << 4 & 0x3F];
                    c[ci++] = 61;
                    c[ci++] = 61;
                    break;
                }
            }
        }
        if (rfc2045) {
            c[ci++] = 13;
            c[ci++] = 10;
        }
        return c;
    }

    public static String decode(String encoded, String charEncoding) throws UnsupportedEncodingException {
        byte[] decoded = B64Code.decode(encoded);
        if (charEncoding == null) {
            return new String(decoded);
        }
        return new String(decoded, charEncoding);
    }

    public static byte[] decode(char[] b) {
        int li;
        if (b == null) {
            return null;
        }
        int bLen = b.length;
        if (bLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        for (li = bLen - 1; li >= 0 && b[li] == '='; --li) {
        }
        if (li < 0) {
            return new byte[0];
        }
        int rLen = (li + 1) * 3 / 4;
        byte[] r = new byte[rLen];
        int ri = 0;
        int bi = 0;
        int stop = rLen / 3 * 3;
        try {
            byte b2;
            byte b1;
            byte b0;
            while (ri < stop) {
                b0 = rfc1421nibbles[b[bi++]];
                b1 = rfc1421nibbles[b[bi++]];
                b2 = rfc1421nibbles[b[bi++]];
                byte b3 = rfc1421nibbles[b[bi++]];
                if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                r[ri++] = (byte)(b0 << 2 | b1 >>> 4);
                r[ri++] = (byte)(b1 << 4 | b2 >>> 2);
                r[ri++] = (byte)(b2 << 6 | b3);
            }
            if (rLen != ri) {
                switch (rLen % 3) {
                    case 2: {
                        b0 = rfc1421nibbles[b[bi++]];
                        b1 = rfc1421nibbles[b[bi++]];
                        b2 = rfc1421nibbles[b[bi++]];
                        if (b0 < 0 || b1 < 0 || b2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        r[ri++] = (byte)(b0 << 2 | b1 >>> 4);
                        r[ri++] = (byte)(b1 << 4 | b2 >>> 2);
                        break;
                    }
                    case 1: {
                        b0 = rfc1421nibbles[b[bi++]];
                        b1 = rfc1421nibbles[b[bi++]];
                        if (b0 < 0 || b1 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        r[ri++] = (byte)(b0 << 2 | b1 >>> 4);
                        break;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e2) {
            throw new IllegalArgumentException("char " + bi + " was not B64 encoded");
        }
        return r;
    }

    public static byte[] decode(String encoded) {
        char c;
        if (encoded == null) {
            return null;
        }
        int ci = 0;
        byte[] nibbles = new byte[4];
        int s = 0;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(4 * encoded.length() / 3);
        while (ci < encoded.length() && (c = encoded.charAt(ci++)) != '=') {
            if (Character.isWhitespace(c)) continue;
            byte nibble = rfc1421nibbles[c];
            if (nibble < 0) {
                throw new IllegalArgumentException("Not B64 encoded");
            }
            nibbles[s++] = rfc1421nibbles[c];
            switch (s) {
                case 1: {
                    break;
                }
                case 2: {
                    bout.write(nibbles[0] << 2 | nibbles[1] >>> 4);
                    break;
                }
                case 3: {
                    bout.write(nibbles[1] << 4 | nibbles[2] >>> 2);
                    break;
                }
                case 4: {
                    bout.write(nibbles[2] << 6 | nibbles[3]);
                    s = 0;
                }
            }
        }
        return bout.toByteArray();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            B64Code.rfc1421nibbles[i] = -1;
        }
        for (int b = 0; b < 64; b = (int)((byte)(b + 1))) {
            B64Code.rfc1421nibbles[(byte)B64Code.rfc1421alphabet[b]] = b;
        }
        B64Code.rfc1421nibbles[61] = 0;
    }
}

