/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NCSARequestLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger LOG = Log.getLogger(NCSARequestLog.class);
    private String _filename;
    private boolean _extended = true;
    private boolean _append = true;
    private int _retainDays = 31;
    private boolean _closeOut;
    private boolean _preferProxiedForAddress;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss Z";
    private String _filenameDateFormat = null;
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = "GMT";
    private String[] _ignorePaths;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private boolean _logServer = false;
    private boolean _logDispatch = false;
    private transient OutputStream _out;
    private transient OutputStream _fileOut;
    private transient DateCache _logDateCache;
    private transient PathMap _ignorePathMap;
    private transient Writer _writer;

    public NCSARequestLog() {
    }

    public NCSARequestLog(String filename) {
        this.setFilename(filename);
    }

    public void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._filename = filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._fileOut instanceof RolloverFileOutputStream) {
            return ((RolloverFileOutputStream)this._fileOut).getDatedFilename();
        }
        return null;
    }

    public void setLogDateFormat(String format) {
        this._logDateFormat = format;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogLocale(Locale logLocale) {
        this._logLocale = logLocale;
    }

    public Locale getLogLocale() {
        return this._logLocale;
    }

    public void setLogTimeZone(String tz) {
        this._logTimeZone = tz;
    }

    public String getLogTimeZone() {
        return this._logTimeZone;
    }

    public void setRetainDays(int retainDays) {
        this._retainDays = retainDays;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setExtended(boolean extended) {
        this._extended = extended;
    }

    public boolean isExtended() {
        return this._extended;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this._ignorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setLogCookies(boolean logCookies) {
        this._logCookies = logCookies;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public void setLogServer(boolean logServer) {
        this._logServer = logServer;
    }

    public boolean getLogServer() {
        return this._logServer;
    }

    public void setLogLatency(boolean logLatency) {
        this._logLatency = logLatency;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    public void setPreferProxiedForAddress(boolean preferProxiedForAddress) {
        this._preferProxiedForAddress = preferProxiedForAddress;
    }

    public boolean getPreferProxiedForAddress() {
        return this._preferProxiedForAddress;
    }

    public void setFilenameDateFormat(String logFileDateFormat) {
        this._filenameDateFormat = logFileDateFormat;
    }

    public String getFilenameDateFormat() {
        return this._filenameDateFormat;
    }

    public void setLogDispatch(boolean value) {
        this._logDispatch = value;
    }

    public boolean isLogDispatch() {
        return this._logDispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Request request, Response response) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getRequestURI()) != null) {
                return;
            }
            if (this._fileOut == null) {
                return;
            }
            StringBuilder buf = new StringBuilder(256);
            if (this._logServer) {
                buf.append(request.getServerName());
                buf.append(' ');
            }
            String addr = null;
            if (this._preferProxiedForAddress) {
                addr = request.getHeader("X-Forwarded-For");
            }
            if (addr == null) {
                addr = request.getRemoteAddr();
            }
            buf.append(addr);
            buf.append(" - ");
            Authentication authentication = request.getAuthentication();
            if (authentication instanceof Authentication.User) {
                buf.append(((Authentication.User)authentication).getUserIdentity().getUserPrincipal().getName());
            } else {
                buf.append(" - ");
            }
            buf.append(" [");
            if (this._logDateCache != null) {
                buf.append(this._logDateCache.format(request.getTimeStamp()));
            } else {
                buf.append(request.getTimeStampBuffer().toString());
            }
            buf.append("] \"");
            buf.append(request.getMethod());
            buf.append(' ');
            buf.append(request.getUri().toString());
            buf.append(' ');
            buf.append(request.getProtocol());
            buf.append("\" ");
            if (request.getAsyncContinuation().isInitial()) {
                int status = response.getStatus();
                if (status <= 0) {
                    status = 404;
                }
                buf.append((char)(48 + status / 100 % 10));
                buf.append((char)(48 + status / 10 % 10));
                buf.append((char)(48 + status % 10));
            } else {
                buf.append("Async");
            }
            long responseLength = response.getContentCount();
            if (responseLength >= 0L) {
                buf.append(' ');
                if (responseLength > 99999L) {
                    buf.append(responseLength);
                } else {
                    if (responseLength > 9999L) {
                        buf.append((char)(48L + responseLength / 10000L % 10L));
                    }
                    if (responseLength > 999L) {
                        buf.append((char)(48L + responseLength / 1000L % 10L));
                    }
                    if (responseLength > 99L) {
                        buf.append((char)(48L + responseLength / 100L % 10L));
                    }
                    if (responseLength > 9L) {
                        buf.append((char)(48L + responseLength / 10L % 10L));
                    }
                    buf.append((char)(48L + responseLength % 10L));
                }
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            if (this._extended) {
                this.logExtended(request, response, buf);
            }
            if (this._logCookies) {
                Cookie[] cookies = request.getCookies();
                if (cookies == null || cookies.length == 0) {
                    buf.append(" -");
                } else {
                    buf.append(" \"");
                    for (int i = 0; i < cookies.length; ++i) {
                        if (i != 0) {
                            buf.append(';');
                        }
                        buf.append(cookies[i].getName());
                        buf.append('=');
                        buf.append(cookies[i].getValue());
                    }
                    buf.append('\"');
                }
            }
            if (this._logDispatch || this._logLatency) {
                long now2 = System.currentTimeMillis();
                if (this._logDispatch) {
                    long d = request.getDispatchTime();
                    buf.append(' ');
                    buf.append(now2 - (d == 0L ? request.getTimeStamp() : d));
                }
                if (this._logLatency) {
                    buf.append(' ');
                    buf.append(now2 - request.getTimeStamp());
                }
            }
            buf.append(StringUtil.__LINE_SEPARATOR);
            String log = buf.toString();
            NCSARequestLog nCSARequestLog = this;
            synchronized (nCSARequestLog) {
                if (this._writer == null) {
                    return;
                }
                this._writer.write(log);
                this._writer.flush();
            }
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
    }

    protected void logExtended(Request request, Response response, StringBuilder b) throws IOException {
        String referer = request.getHeader("Referer");
        if (referer == null) {
            b.append("\"-\" ");
        } else {
            b.append('\"');
            b.append(referer);
            b.append("\" ");
        }
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            b.append("\"-\" ");
        } else {
            b.append('\"');
            b.append(agent);
            b.append('\"');
        }
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (this._logDateFormat != null) {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
            this._logDateCache.setTimeZoneID(this._logTimeZone);
        }
        if (this._filename != null) {
            this._fileOut = new RolloverFileOutputStream(this._filename, this._append, this._retainDays, TimeZone.getTimeZone(this._logTimeZone), this._filenameDateFormat, null);
            this._closeOut = true;
            LOG.info("Opened " + this.getDatedFilename(), new Object[0]);
        } else {
            this._fileOut = System.err;
        }
        this._out = this._fileOut;
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMap();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        this._writer = new OutputStreamWriter(this._out);
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        NCSARequestLog nCSARequestLog = this;
        synchronized (nCSARequestLog) {
            super.doStop();
            try {
                if (this._writer != null) {
                    this._writer.flush();
                }
            }
            catch (IOException e2) {
                LOG.ignore(e2);
            }
            if (this._out != null && this._closeOut) {
                try {
                    this._out.close();
                }
                catch (IOException e3) {
                    LOG.ignore(e3);
                }
            }
            this._out = null;
            this._fileOut = null;
            this._closeOut = false;
            this._logDateCache = null;
            this._writer = null;
        }
    }
}

