/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;

public class RedirectListener
extends HttpEventListenerWrapper {
    private final HttpExchange _exchange;
    private HttpDestination _destination;
    private String _location;
    private int _attempts;
    private boolean _requestComplete;
    private boolean _responseComplete;
    private boolean _redirected;

    public RedirectListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._destination = destination;
        this._exchange = ex;
    }

    @Override
    public void onResponseStatus(Buffer version2, int status, Buffer reason) throws IOException {
        boolean bl = this._redirected = (status == 301 || status == 302) && this._attempts < this._destination.getHttpClient().maxRedirects();
        if (this._redirected) {
            this.setDelegatingRequests(false);
            this.setDelegatingResponses(false);
        }
        super.onResponseStatus(version2, status, reason);
    }

    @Override
    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._redirected) {
            int header = HttpHeaders.CACHE.getOrdinal(name);
            switch (header) {
                case 45: {
                    this._location = value.toString();
                }
            }
        }
        super.onResponseHeader(name, value);
    }

    @Override
    public void onRequestComplete() throws IOException {
        this._requestComplete = true;
        if (this.checkExchangeComplete()) {
            super.onRequestComplete();
        }
    }

    @Override
    public void onResponseComplete() throws IOException {
        this._responseComplete = true;
        if (this.checkExchangeComplete()) {
            super.onResponseComplete();
        }
    }

    public boolean checkExchangeComplete() throws IOException {
        if (this._redirected && this._requestComplete && this._responseComplete) {
            if (this._location != null) {
                if (this._location.indexOf("://") > 0) {
                    this._exchange.setURL(this._location);
                } else {
                    this._exchange.setRequestURI(this._location);
                }
                boolean isHttps = "https".equals(String.valueOf(this._exchange.getScheme()));
                HttpDestination destination = this._destination.getHttpClient().getDestination(this._exchange.getAddress(), isHttps);
                if (this._destination == destination) {
                    this._destination.resend(this._exchange);
                } else {
                    HttpEventListener listener = this;
                    while (listener instanceof HttpEventListenerWrapper) {
                        listener = ((HttpEventListenerWrapper)listener).getEventListener();
                    }
                    this._exchange.getEventListener().onRetry();
                    this._exchange.reset();
                    this._exchange.setEventListener(listener);
                    Address address = this._exchange.getAddress();
                    int port = address.getPort();
                    StringBuilder hostHeader = new StringBuilder(64);
                    hostHeader.append(address.getHost());
                    if (!(port == 80 && !isHttps || port == 443 && isHttps)) {
                        hostHeader.append(':');
                        hostHeader.append(port);
                    }
                    this._exchange.setRequestHeader("Host", hostHeader.toString());
                    destination.send(this._exchange);
                }
                return false;
            }
            this.setDelegationResult(false);
        }
        return true;
    }

    @Override
    public void onRetry() {
        this._redirected = false;
        ++this._attempts;
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        this._requestComplete = false;
        this._responseComplete = false;
        super.onRetry();
    }

    @Override
    public void onConnectionFailed(Throwable ex) {
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        super.onConnectionFailed(ex);
    }

    @Override
    public void onException(Throwable ex) {
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        super.onException(ex);
    }
}

