/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.other.GLib;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterConst;

public abstract class TurtleShell {
    protected final IndentedWriter out;
    protected final NodeFormatter nodeFmt;
    protected final PrefixMap prefixMap;
    protected final String baseURI;
    private static Comparator<Node> compPredicates = new ComparePredicates();

    protected TurtleShell(IndentedWriter out, PrefixMap pmap, String baseURI) {
        this.out = out;
        if (pmap == null) {
            pmap = PrefixMapFactory.emptyPrefixMap();
        }
        this.nodeFmt = new NodeFormatterTTL(baseURI, pmap, NodeToLabel.createScopeByDocument());
        this.prefixMap = pmap;
        this.baseURI = baseURI;
    }

    protected void writeBase(String base) {
        RiotLib.writeBase(this.out, base);
    }

    protected void writePrefixes(PrefixMap prefixMap) {
        RiotLib.writePrefixes(this.out, prefixMap);
    }

    protected void writeGraphTTL(Graph graph) {
        ShellGraph x = new ShellGraph(graph);
        x.writeGraph();
    }

    protected final void writeNode(Node node) {
        this.nodeFmt.format(this.out, node);
    }

    private void print(String x) {
        this.out.print(x);
    }

    private void gap(int gap) {
        this.out.print(' ', gap);
    }

    private void println() {
        this.out.println();
    }

    private static final class ComparePredicates
    implements Comparator<Node> {
        private ComparePredicates() {
        }

        private static int classification(Node p) {
            if (p.equals(WriterConst.RDF_type)) {
                return 0;
            }
            if (p.getURI().startsWith(RDF.getURI()) || p.getURI().startsWith(RDFS.getURI())) {
                return 1;
            }
            return 2;
        }

        @Override
        public int compare(Node t1, Node t2) {
            int class2;
            int class1 = ComparePredicates.classification(t1);
            if (class1 != (class2 = ComparePredicates.classification(t2))) {
                if (class1 < class2) {
                    return -1;
                }
                if (class1 > class2) {
                    return 1;
                }
                return 0;
            }
            String p1 = t1.getURI();
            String p2 = t2.getURI();
            return p1.compareTo(p2);
        }
    }

    private final class ShellGraph {
        private final Graph graph;
        private final Set<Node> nestedObjects;
        private final Set<Node> freeBnodes;
        private final Map<Node, List<Node>> lists;
        private final Map<Node, List<Node>> freeLists;
        private final Map<Node, List<Node>> nLinkedLists;
        private final Collection<Node> listElts;

        private ShellGraph(Graph graph) {
            this.graph = graph;
            this.nestedObjects = new HashSet<Node>();
            this.freeBnodes = new HashSet<Node>();
            this.lists = new HashMap<Node, List<Node>>();
            this.freeLists = new HashMap<Node, List<Node>>();
            this.nLinkedLists = new HashMap<Node, List<Node>>();
            this.listElts = new HashSet<Node>();
            this.findLists();
            this.findBNodesSyntax();
            this.nestedObjects.removeAll(this.listElts);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findBNodesSyntax() {
            HashSet rejects = new HashSet();
            ExtendedIterator<Triple> iter = this.graph.find(Node.ANY, Node.ANY, Node.ANY);
            try {
                while (iter.hasNext()) {
                    int connectivity;
                    Node obj;
                    int sConn;
                    Triple t = (Triple)iter.next();
                    Node subj = t.getSubject();
                    if (subj.isBlank() && !this.lists.containsKey(subj) && (sConn = this.inLinks(subj)) == 0) {
                        this.freeBnodes.add(subj);
                    }
                    if (!(obj = t.getObject()).isBlank() || rejects.contains(obj) || (connectivity = this.inLinks(obj)) != 1) continue;
                    this.nestedObjects.add(obj);
                }
            }
            finally {
                iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int inLinks(Node obj) {
            ExtendedIterator<Triple> iter = this.graph.find(Node.ANY, Node.ANY, obj);
            boolean count = false;
            try {
                if (!iter.hasNext()) {
                    int n = 0;
                    return n;
                }
                iter.next();
                if (!iter.hasNext()) {
                    int n = 1;
                    return n;
                }
                int n = 2;
                return n;
            }
            finally {
                iter.close();
            }
        }

        private void findLists() {
            List<Triple> tails = RiotLib.triples(this.graph, Node.ANY, WriterConst.RDF_Rest, WriterConst.RDF_Nil);
            for (Triple t : tails) {
                HashSet<Node> listElts2 = new HashSet<Node>();
                Pair<Node, List<Node>> p = this.followTailToHead(t.getSubject(), listElts2);
                if (p == null) continue;
                Node headElt = p.getLeft();
                List<Node> elts = p.getRight();
                long numLinks = RiotLib.countTriples(this.graph, null, null, headElt);
                if (numLinks == 1L) {
                    this.lists.put(headElt, elts);
                } else if (numLinks == 0L) {
                    this.freeLists.put(headElt, elts);
                } else {
                    this.nLinkedLists.put(headElt, elts);
                }
                this.listElts.addAll(listElts2);
            }
        }

        private Pair<Node, List<Node>> followTailToHead(Node lastListElt, Collection<Node> listElts) {
            ArrayList<Node> listCells = new ArrayList<Node>();
            ArrayList<Node> eltsReversed = new ArrayList<Node>();
            ArrayList<Triple> acc = new ArrayList<Triple>();
            Node x = lastListElt;
            while (true) {
                if (!this.validListElement(x, acc)) {
                    if (listCells.size() == 0) {
                        return null;
                    }
                    x = (Node)listCells.remove(listCells.size() - 1);
                    break;
                }
                Triple t = RiotLib.triple1(this.graph, x, WriterConst.RDF_First, null);
                if (t == null) {
                    return null;
                }
                eltsReversed.add(t.getObject());
                listCells.add(x);
                List<Triple> acc2 = RiotLib.triples(this.graph, null, null, x);
                long numRest = RiotLib.countTriples(this.graph, null, WriterConst.RDF_Rest, x);
                if (numRest != 1L) {
                    listCells.add(x);
                    break;
                }
                int numLinks = acc2.size();
                if (numLinks > 1) break;
                Triple tLink = acc2.get(0);
                x = tLink.getSubject();
            }
            listElts.addAll(listCells);
            Collections.reverse(eltsReversed);
            return Pair.create(x, eltsReversed);
        }

        private boolean validListElement(Node x, List<Triple> acc) {
            Triple t1 = RiotLib.triple1(this.graph, x, WriterConst.RDF_Rest, null);
            if (t1 == null) {
                return false;
            }
            Triple t2 = RiotLib.triple1(this.graph, x, WriterConst.RDF_First, null);
            if (t2 == null) {
                return false;
            }
            long N = RiotLib.countTriples(this.graph, x, null, null);
            if (N != 2L) {
                return false;
            }
            acc.add(t1);
            acc.add(t2);
            return true;
        }

        private void writeGraph() {
            Iterator<Node> subjects = GLib.listSubjects(this.graph);
            boolean somethingWritten = this.writeBySubject(subjects);
            if (!this.nLinkedLists.isEmpty()) {
                somethingWritten = this.writeNLinkedLists(somethingWritten);
            }
            if (!this.freeLists.isEmpty()) {
                somethingWritten = this.writeFreeLists(somethingWritten);
            }
        }

        private boolean writeNLinkedLists(boolean somethingWritten) {
            for (Node n : this.nLinkedLists.keySet()) {
                if (somethingWritten) {
                    TurtleShell.this.out.println();
                }
                somethingWritten = true;
                List<Node> x = this.nLinkedLists.get(n);
                TurtleShell.this.writeNode(n);
                if (TurtleShell.this.out.getCol() > 20) {
                    TurtleShell.this.println();
                } else {
                    TurtleShell.this.gap(2);
                }
                TurtleShell.this.out.incIndent(8);
                TurtleShell.this.out.pad();
                TurtleShell.this.writeNode(WriterConst.RDF_First);
                TurtleShell.this.print(" ");
                TurtleShell.this.writeNode(x.get(0));
                TurtleShell.this.print(" ;");
                TurtleShell.this.println();
                TurtleShell.this.writeNode(WriterConst.RDF_Rest);
                TurtleShell.this.print("  ");
                x = x.subList(1, x.size());
                this.list(x);
                TurtleShell.this.print(" .");
                TurtleShell.this.out.decIndent(8);
                TurtleShell.this.println();
            }
            return somethingWritten;
        }

        private boolean writeFreeLists(boolean somethingWritten) {
            for (Node n : this.freeLists.keySet()) {
                if (somethingWritten) {
                    TurtleShell.this.out.println();
                }
                somethingWritten = true;
                List<Node> x = this.freeLists.get(n);
                TurtleShell.this.out.print("[ ");
                TurtleShell.this.writeNode(WriterConst.RDF_First);
                TurtleShell.this.print(" ");
                TurtleShell.this.writeNode(x.get(0));
                TurtleShell.this.print(" ; ");
                TurtleShell.this.writeNode(WriterConst.RDF_Rest);
                TurtleShell.this.print(" ");
                x = x.subList(1, x.size());
                this.list(x);
                TurtleShell.this.out.println(" ] .");
            }
            return somethingWritten;
        }

        private boolean writeBySubject(Iterator<Node> subjects) {
            boolean first = true;
            while (subjects.hasNext()) {
                Node subj = subjects.next();
                if (this.nestedObjects.contains(subj) || this.listElts.contains(subj)) continue;
                if (!first) {
                    TurtleShell.this.out.println();
                }
                first = false;
                if (this.freeBnodes.contains(subj)) {
                    this.nestedObject(subj);
                    TurtleShell.this.out.println(" .");
                    continue;
                }
                Collection<Triple> cluster = RiotLib.triplesOfSubject(this.graph, subj);
                this.writeCluster(subj, cluster);
            }
            return !first;
        }

        private void writeCluster(Node subject, Collection<Triple> cluster) {
            if (cluster.isEmpty()) {
                return;
            }
            TurtleShell.this.writeNode(subject);
            if (TurtleShell.this.out.getCol() > 20) {
                TurtleShell.this.out.println();
            } else {
                TurtleShell.this.gap(2);
            }
            TurtleShell.this.out.incIndent(8);
            TurtleShell.this.out.pad();
            this.writePredicateObjectList(cluster);
            TurtleShell.this.out.decIndent(8);
            TurtleShell.this.print(" .");
            TurtleShell.this.println();
        }

        private void writePredicateObjectList(Collection<Triple> cluster) {
            Map<Node, List<Node>> pGroups = this.groupByPredicates(cluster);
            Set<Node> predicates = pGroups.keySet();
            int predicateMaxWidth = RiotLib.calcWidth(TurtleShell.this.prefixMap, TurtleShell.this.baseURI, predicates, 4, 30);
            boolean first = true;
            if (!WriterConst.OBJECT_LISTS) {
                for (Node p : predicates) {
                    for (Node o : pGroups.get(p)) {
                        this.writePredicateObject(p, o, predicateMaxWidth, first);
                        first = false;
                    }
                }
                return;
            }
            for (Node p : predicates) {
                ArrayList<Node> rdfLiterals = new ArrayList<Node>();
                ArrayList<Node> rdfSimpleNodes = new ArrayList<Node>();
                ArrayList<Node> rdfComplexNodes = new ArrayList<Node>();
                for (Node o : pGroups.get(p)) {
                    if (o.isLiteral()) {
                        rdfLiterals.add(o);
                        continue;
                    }
                    if (this.isPrettyNode(o)) {
                        rdfComplexNodes.add(o);
                        continue;
                    }
                    rdfSimpleNodes.add(o);
                }
                if (rdfLiterals.size() != 0) {
                    this.writePredicateObjectList(p, rdfLiterals, predicateMaxWidth, first);
                    first = false;
                }
                if (rdfSimpleNodes.size() != 0) {
                    this.writePredicateObjectList(p, rdfSimpleNodes, predicateMaxWidth, first);
                    first = false;
                }
                for (Node o : rdfComplexNodes) {
                    this.writePredicateObject(p, o, predicateMaxWidth, first);
                    first = false;
                }
            }
        }

        private void writePredicateObject(Node p, Node obj, int predicateMaxWidth, boolean first) {
            this.writePredicate(p, predicateMaxWidth, first);
            TurtleShell.this.out.incIndent(8);
            this.writeNodePretty(obj);
            TurtleShell.this.out.decIndent(8);
        }

        private void writePredicateObjectList(Node p, List<Node> objects, int predicateMaxWidth, boolean first) {
            this.writePredicate(p, predicateMaxWidth, first);
            TurtleShell.this.out.incIndent(8);
            boolean firstObject = true;
            for (Node o : objects) {
                if (!firstObject) {
                    TurtleShell.this.out.print(" , ");
                } else {
                    firstObject = false;
                }
                TurtleShell.this.writeNode(o);
            }
            TurtleShell.this.out.decIndent(8);
        }

        private void writePredicate(Node p, int predicateMaxWidth, boolean first) {
            if (first) {
                first = false;
            } else {
                TurtleShell.this.print(" ;");
                TurtleShell.this.println();
            }
            int colPredicateStart = TurtleShell.this.out.getAbsoluteIndent();
            if (!TurtleShell.this.prefixMap.contains(WriterConst.rdfNS) && WriterConst.RDF_type.equals(p)) {
                TurtleShell.this.print("a");
            } else {
                TurtleShell.this.writeNode(p);
            }
            int colPredicateFinish = TurtleShell.this.out.getCol();
            int wPredicate = colPredicateFinish - colPredicateStart;
            if (wPredicate > 30) {
                TurtleShell.this.println();
            } else {
                TurtleShell.this.out.pad(predicateMaxWidth);
                TurtleShell.this.gap(2);
            }
        }

        private Map<Node, List<Node>> groupByPredicates(Collection<Triple> cluster) {
            TreeMap<Node, List<Node>> x = new TreeMap<Node, List<Node>>(compPredicates);
            for (Triple t : cluster) {
                Node p = t.getPredicate();
                if (!x.containsKey(p)) {
                    x.put(p, new ArrayList());
                }
                ((List)x.get(p)).add(t.getObject());
            }
            return x;
        }

        private int countPredicates(Collection<Triple> cluster) {
            HashSet<Node> x = new HashSet<Node>();
            for (Triple t : cluster) {
                Node p = t.getPredicate();
                x.add(p);
            }
            return x.size();
        }

        private void nestedObject(Node node) {
            Collection<Triple> x = RiotLib.triplesOfSubject(this.graph, node);
            if (x.isEmpty()) {
                TurtleShell.this.print("[] ");
                return;
            }
            int pCount = this.countPredicates(x);
            if (pCount == 1) {
                TurtleShell.this.print("[ ");
                TurtleShell.this.out.incIndent(2);
                this.writePredicateObjectList(x);
                TurtleShell.this.out.decIndent(2);
                TurtleShell.this.print(" ]");
                return;
            }
            int indent0 = TurtleShell.this.out.getAbsoluteIndent();
            int here = TurtleShell.this.out.getCol();
            TurtleShell.this.out.setAbsoluteIndent(here);
            TurtleShell.this.print("[ ");
            TurtleShell.this.out.incIndent(2);
            this.writePredicateObjectList(x);
            TurtleShell.this.out.decIndent(2);
            TurtleShell.this.println();
            TurtleShell.this.print("]");
            TurtleShell.this.out.setAbsoluteIndent(indent0);
        }

        private void list(List<Node> elts) {
            if (elts.size() == 0) {
                TurtleShell.this.out.print("()");
                return;
            }
            TurtleShell.this.out.print("(");
            for (Node n : elts) {
                TurtleShell.this.out.print(" ");
                this.writeNodePretty(n);
            }
            TurtleShell.this.out.print(" )");
        }

        private boolean isPrettyNode(Node n) {
            if (this.lists.containsKey(n)) {
                return true;
            }
            if (this.nestedObjects.contains(n)) {
                return true;
            }
            return WriterConst.RDF_Nil.equals(n);
        }

        private void writeNodePretty(Node obj) {
            if (this.lists.containsKey(obj)) {
                this.list(this.lists.get(obj));
            } else if (this.nestedObjects.contains(obj)) {
                this.nestedObject(obj);
            } else if (WriterConst.RDF_Nil.equals(obj)) {
                TurtleShell.this.out.println("()");
            } else {
                TurtleShell.this.writeNode(obj);
            }
        }
    }
}

