/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.validation.ValidatorBase;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.riot.system.IRIResolver;

public class IRIValidator
extends ValidatorBase {
    static final String paramIRI = "iri";
    static IRIFactory iriFactory = IRIResolver.iriFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String[] args = httpRequest.getParameterValues(paramIRI);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(new PrintStream(outStream));
            System.setErr(new PrintStream(outStream));
            IRIValidator.setHeaders(httpResponse);
            outStream.println("<html>");
            IRIValidator.printHead(outStream, "Jena IRI Validator Report");
            outStream.println("<body>");
            outStream.println("<h1>IRI Report</h1>");
            IRIValidator.startFixed(outStream);
            try {
                boolean first = true;
                for (String iriStr : args) {
                    if (!first) {
                        System.out.println();
                    }
                    first = false;
                    IRI iri2 = iriFactory.create(iriStr);
                    System.out.println(iriStr + " ==> " + iri2);
                    if (iri2.isRelative()) {
                        System.out.println("Relative IRI: " + iriStr);
                    }
                    Iterator<Violation> vIter = iri2.violations(true);
                    while (vIter.hasNext()) {
                        String str2 = vIter.next().getShortMessage();
                        str2 = IRIValidator.htmlQuote(str2);
                        System.out.println(str2);
                    }
                }
            }
            finally {
                IRIValidator.finishFixed(outStream);
                System.out.flush();
                System.err.flush();
                System.setOut(stdout);
                System.setErr(stdout);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

