/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.log.NullLogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVelocity {
    private static LogChute velocityLogChute = new NullLogChute();
    private static Logger velocityLog = LoggerFactory.getLogger("Velocity");

    public static void process(String base, String path, Writer out, Map<String, Object> params) {
        SimpleVelocity.process(base, path, out, SimpleVelocity.createContext(params));
    }

    public static void process(String base, String path, Writer out, VelocityContext context) {
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("runtime.log.logsystem", velocityLogChute);
        velocity.setProperty("input.encoding", "UTF-8");
        velocity.setProperty("file.resource.loader.path", base);
        velocity.init();
        try {
            Template temp = velocity.getTemplate(path);
            temp.merge(context, out);
            out.flush();
        }
        catch (ResourceNotFoundException ex) {
            velocityLog.error("Resource not found: " + ex.getMessage());
        }
        catch (ParseErrorException ex) {
            velocityLog.error("Parse error (" + path + ") : " + ex.getMessage());
        }
        catch (MethodInvocationException ex) {
            velocityLog.error("Method invocation exception (" + path + ") : " + ex.getMessage());
        }
        catch (IOException ex) {
            velocityLog.warn("IOException", ex);
        }
    }

    public static VelocityContext createContext(Map<String, Object> params) {
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, Object> e2 : params.entrySet()) {
            context.put(e2.getKey(), e2.getValue());
        }
        return context;
    }
}

