/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_ServletBase;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class SPARQL_Upload
extends SPARQL_ServletBase {
    private static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(log);

    public SPARQL_Upload(boolean verbose_debug) {
        super(verbose_debug);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionUpload action = new HttpActionUpload(id, desc, request, response, this.verbose_debug);
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (!isMultipart) {
            SPARQL_Upload.error(400, "Not a file upload");
        }
        long tripleCount = -1L;
        action.beginWrite();
        try {
            Graph graphTmp = GraphFactory.createDefaultGraph();
            String graphName = SPARQL_Upload.upload(action, graphTmp, "http://example/upload-base/");
            tripleCount = graphTmp.size();
            log.info(String.format("[%d] Upload: Graph: %s (%d triple(s))", action.id, graphName, tripleCount));
            Node gn = graphName.equals("default") ? Quad.defaultGraphNodeGenerated : NodeFactory.createURI(graphName);
            FusekiLib.addDataInto(graphTmp, action.getActiveDSG(), gn);
            tripleCount = graphTmp.size();
            action.commit();
        }
        catch (RuntimeException ex) {
            try {
                action.abort();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            SPARQL_Upload.errorOccurred(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
        try {
            response.setContentType("text/plain");
            response.getOutputStream().print("Triples = " + tripleCount);
            SPARQL_Upload.success(action);
        }
        catch (Exception ex) {
            SPARQL_Upload.errorOccurred(ex);
        }
    }

    public static Graph upload(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, String destination) {
        HttpActionUpload action = new HttpActionUpload(id, desc, request, response, false);
        Graph graphTmp = GraphFactory.createDefaultGraph();
        String graphName = SPARQL_Upload.upload(action, graphTmp, destination);
        return graphTmp;
    }

    private static String upload(HttpActionUpload action, Graph graphDst, String base) {
        ServletFileUpload upload = new ServletFileUpload();
        String graphName = null;
        String name = null;
        ContentType ct = null;
        Lang lang = null;
        boolean tripleCount = false;
        try {
            FileItemIterator iter = upload.getItemIterator(action.request);
            while (iter.hasNext()) {
                String contentTypeHeader;
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString(stream, "UTF-8");
                    if (fieldName.equals("graph")) {
                        graphName = value;
                        if (graphName == null || graphName.equals("default")) continue;
                        IRI iri2 = IRIResolver.parseIRI(value);
                        if (iri2.hasViolation(false)) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: " + graphName);
                        }
                        if (iri2.getScheme() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no IRI scheme name: " + graphName);
                        }
                        if (!iri2.getScheme().equalsIgnoreCase("http") && !iri2.getScheme().equalsIgnoreCase("https")) continue;
                        if (iri2.getRawHost() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no host name: " + graphName);
                        }
                        if (iri2.getRawPath() == null || iri2.getRawPath().length() == 0) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no path: " + graphName);
                        }
                        if (iri2.getRawPath().charAt(0) == '/') continue;
                        SPARQL_Upload.errorBadRequest("Bad IRI: Path does not start '/': " + graphName);
                        continue;
                    }
                    if (fieldName.equals("default-graph-uri")) {
                        graphName = null;
                        continue;
                    }
                    log.info(String.format("[%d] Upload: Field=%s ignored", action.id, fieldName));
                    continue;
                }
                name = item.getName();
                if (name == null || name.equals("") || name.equals("UNSET FILE NAME")) {
                    SPARQL_Upload.errorBadRequest("No name for content - can't determine RDF syntax");
                }
                if ((lang = WebContent.contentTypeToLang((ct = ContentType.parse(contentTypeHeader = item.getContentType())).getContentType())) == null) {
                    lang = RDFLanguages.filenameToLang(name);
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                StreamRDF dest = StreamRDFLib.graph(graphDst);
                LangRIOT parser = RiotReader.createParser(stream, lang, base, dest);
                parser.getProfile().setHandler(errorHandler);
                log.info(String.format("[%d] Upload: Filename: %s, Content-Type=%s, Charset=%s => %s", action.id, name, ct.getContentType(), ct.getCharset(), lang.getName()));
                try {
                    parser.parse();
                }
                catch (RiotException ex) {
                    SPARQL_Upload.errorBadRequest("Parse error: " + ex.getMessage());
                }
            }
            if (graphName == null) {
                graphName = "default";
            }
            return graphName;
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SPARQL_Upload.errorOccurred(ex);
            return null;
        }
    }

    @Override
    protected void validate(HttpServletRequest request) {
    }

    private static class HttpActionUpload
    extends HttpAction {
        public HttpActionUpload(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, desc, request, response, verbose);
        }
    }
}

