/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.fuseki.migrate.GraphLoadUtils;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.SPARQL_Query;
import org.apache.jena.riot.RiotException;

public class SPARQL_QueryGeneral
extends SPARQL_Query {
    static final int MaxTriples = 100000;

    public SPARQL_QueryGeneral(boolean verbose) {
        super(verbose);
    }

    public SPARQL_QueryGeneral() {
        this(false);
    }

    @Override
    protected void validateRequest(HttpServletRequest request) {
    }

    @Override
    protected void validateQuery(SPARQL_Query.HttpActionQuery action, Query query2) {
    }

    @Override
    protected String mapRequestToDataset(String uri) {
        return null;
    }

    @Override
    protected Dataset decideDataset(SPARQL_Query.HttpActionQuery action, Query query2, String queryStringLog) {
        action.datasetDesc = SPARQL_QueryGeneral.getDatasetDescription(action);
        DatasetDescription datasetDesc = action.datasetDesc;
        if (datasetDesc == null) {
            datasetDesc = SPARQL_QueryGeneral.getDatasetDescription(query2);
        }
        if (datasetDesc == null) {
            SPARQL_QueryGeneral.errorBadRequest("No dataset description in protocol request or in the query string");
        }
        return SPARQL_QueryGeneral.datasetFromDescription(action, datasetDesc);
    }

    protected static Dataset datasetFromDescription(SPARQL_Query.HttpActionQuery action, DatasetDescription datasetDesc) {
        try {
            if (datasetDesc == null) {
                return null;
            }
            if (datasetDesc.isEmpty()) {
                return null;
            }
            List<String> graphURLs = datasetDesc.getDefaultGraphURIs();
            List<String> namedGraphs = datasetDesc.getNamedGraphURIs();
            if (graphURLs.size() == 0 && namedGraphs.size() == 0) {
                return null;
            }
            Dataset dataset = DatasetFactory.createMem();
            Model model = ModelFactory.createDefaultModel();
            for (String uri : graphURLs) {
                if (uri == null || uri.equals("")) {
                    throw new InternalErrorException("Default graph URI is null or the empty string");
                }
                try {
                    GraphLoadUtils.loadModel(model, uri, 100000);
                    log.info(String.format("[%d] Load (default graph) %s", action.id, uri));
                }
                catch (RiotException ex) {
                    log.info(String.format("[%d] Parsing error loading %s: %s", action.id, uri, ex.getMessage()));
                    SPARQL_QueryGeneral.errorBadRequest("Failed to load URL (parse error) " + uri + " : " + ex.getMessage());
                }
                catch (Exception ex) {
                    log.info(String.format("[%d] Failed to load (default) %s: %s", action.id, uri, ex.getMessage()));
                    SPARQL_QueryGeneral.errorBadRequest("Failed to load URL " + uri);
                }
            }
            dataset.setDefaultModel(model);
            if (namedGraphs != null) {
                for (String uri : namedGraphs) {
                    if (uri == null || uri.equals("")) {
                        throw new InternalErrorException("Named graph URI is null or the empty string");
                    }
                    try {
                        Model model2 = ModelFactory.createDefaultModel();
                        GraphLoadUtils.loadModel(model2, uri, 100000);
                        log.info(String.format("[%d] Load (named graph) %s", action.id, uri));
                        dataset.addNamedModel(uri, model2);
                    }
                    catch (RiotException ex) {
                        log.info(String.format("[%d] Parsing error loading %s: %s", action.id, uri, ex.getMessage()));
                        SPARQL_QueryGeneral.errorBadRequest("Failed to load URL (parse error) " + uri + " : " + ex.getMessage());
                    }
                    catch (Exception ex) {
                        log.info(String.format("[%d] Failed to load (named graph) %s: %s", action.id, uri, ex.getMessage()));
                        SPARQL_QueryGeneral.errorBadRequest("Failed to load URL " + uri);
                    }
                }
            }
            return dataset;
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.info(String.format("[%d] SPARQL parameter error: " + ex.getMessage(), action.id, ex));
            SPARQL_QueryGeneral.errorBadRequest("Parameter error: " + ex.getMessage());
            return null;
        }
    }
}

