/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.sparql.core.Prologue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.SPARQL_Query;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseResultSet {
    private static Logger xlog = LoggerFactory.getLogger(ResponseResultSet.class);
    private static Logger slog = ServletBase.log;
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputSPARQL = "sparql";
    private static final String contentOutputText = "text";
    private static final String contentOutputCSV = "csv";
    private static final String contentOutputTSV = "tsv";
    public static Map<String, String> shortNamesResultSet = new HashMap<String, String>();
    static AcceptList prefContentTypeResultSet;
    static AcceptList prefContentTypeRDF;

    public static void doResponseResultSet(SPARQL_Query.HttpActionQuery action, Boolean booleanResult) {
        ResponseResultSet.doResponseResultSet$(action, null, booleanResult, null);
    }

    public static void doResponseResultSet(SPARQL_Query.HttpActionQuery action, ResultSet resultSet, Prologue qPrologue) {
        ResponseResultSet.doResponseResultSet$(action, resultSet, null, qPrologue);
    }

    private static void doResponseResultSet$(SPARQL_Query.HttpActionQuery action, final ResultSet resultSet, final Boolean booleanResult, final Prologue qPrologue) {
        String forceAccept;
        String outputField;
        HttpServletRequest request = action.request;
        HttpServletResponse response = action.response;
        long id = action.id;
        if (resultSet == null && booleanResult == null) {
            xlog.warn("doResponseResult: Both result set and boolean result are null");
            throw new FusekiException("Both result set and boolean result are null");
        }
        if (resultSet != null && booleanResult != null) {
            xlog.warn("doResponseResult: Both result set and boolean result are set");
            throw new FusekiException("Both result set and boolean result are set");
        }
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rsOffer, DEF.acceptRSXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request, shortNamesResultSet)) != null) {
            mimeType = outputField;
        }
        String serializationType = mimeType;
        String contentType = mimeType;
        final String stylesheetURL = ResponseOps.paramStylesheet(request);
        if (stylesheetURL != null && Lib.equal(serializationType, "application/sparql-results+xml")) {
            contentType = "application/xml";
        }
        if ((forceAccept = ResponseOps.paramForceAccept(request)) != null) {
            contentType = "text/plain";
        }
        if (Lib.equal(serializationType, "application/sparql-results+xml")) {
            try {
                ResponseResultSet.sparqlXMLOutput(action, contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, resultSet, stylesheetURL);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, booleanResult, stylesheetURL);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ServletBase.log.debug("Exception [SELECT/XML]" + ex, ex);
            }
            return;
        }
        if (Lib.equal(serializationType, "application/sparql-results+json")) {
            try {
                ResponseResultSet.jsonOutput(action, contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, booleanResult);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ServletBase.log.info(String.format("[%d] Exception [SELECT/JSON] %s", id, ex), ex);
            }
            return;
        }
        if (Lib.equal(serializationType, "text/plain")) {
            try {
                final ResultSetRewindable rs = resultSet != null ? ResultSetFactory.makeRewindable(resultSet) : null;
                ResponseResultSet.textOutput(action, contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (rs != null) {
                            ResultSetFormatter.out((OutputStream)out, rs, qPrologue);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.out((OutputStream)out, booleanResult);
                        }
                    }
                });
            }
            catch (QueryCancelledException ex) {
                slog.info("[%d] SELECT/Text : Query timeout during execution", id);
                try {
                    response.sendError(503, "Query timeout during execution");
                }
                catch (IOException ex2) {
                    IO.exception(ex2);
                }
            }
            catch (Exception ex) {
                xlog.debug("[%d] Exception [SELECT/Text] " + ex, ex, (Object)id);
            }
            return;
        }
        if (Lib.equal(serializationType, "text/csv") || Lib.equal(serializationType, "text/tab-separated-values")) {
            try {
                OutputContent output = serializationType.equals("text/csv") ? new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, booleanResult);
                        }
                    }
                } : new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, booleanResult);
                        }
                    }
                };
                ResponseResultSet.textOutput(action, contentType, output);
                response.flushBuffer();
            }
            catch (Exception ex) {
                ServletBase.log.debug(String.format("[%d] Exception [SELECT/CSV-TSV] %s", id, ex), ex);
            }
            return;
        }
        ServletBase.errorBadRequest("Can't determine output serialization: " + serializationType);
    }

    private static void output(HttpAction action, String contentType, String charset, OutputContent proc) {
        try {
            ResponseResultSet.setHttpResponse(action.request, action.response, contentType, charset);
            action.response.setStatus(200);
            ServletOutputStream out = action.response.getOutputStream();
            try {
                proc.output(out);
                out.flush();
            }
            catch (QueryCancelledException ex) {
                slog.info(String.format("[%d] Query Cancelled - results truncated (but 200 already sent)", action.id));
                out.println();
                out.println("##  Query cancelled due to timeout during execution   ##");
                out.println("##  ****          Incomplete results           ****   ##");
                out.flush();
            }
        }
        catch (IOException ex) {
            ServletBase.errorOccurred(ex);
        }
    }

    public static void setHttpResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String contentType, String charset) {
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Pragma", "no-cache");
        if (contentType != null) {
            if (charset != null && !ResponseResultSet.isXML(contentType)) {
                contentType = contentType + "; charset=" + charset;
            }
            ServletBase.log.trace("Content-Type for response: " + contentType);
            httpResponse.setContentType(contentType);
        }
    }

    private static boolean isXML(String contentType) {
        return contentType.equals("application/rdf+xml") || contentType.equals("application/sparql-results+xml") || contentType.equals("application/xml");
    }

    private static void sparqlXMLOutput(HttpAction action, String contentType, OutputContent proc) {
        ResponseResultSet.output(action, contentType, null, proc);
    }

    private static void jsonOutput(HttpAction action, String contentType, OutputContent proc) {
        try {
            String callback = ResponseOps.paramCallback(action.request);
            ServletOutputStream out = action.response.getOutputStream();
            if (callback != null) {
                callback = StringUtils.replaceChars(callback, "\r", "");
                callback = StringUtils.replaceChars(callback, "\n", "");
                out.print(callback);
                out.println("(");
            }
            ResponseResultSet.output(action, contentType, "utf-8", proc);
            if (callback != null) {
                out.println(")");
            }
        }
        catch (IOException ex) {
            ServletBase.errorOccurred(ex);
        }
    }

    private static void textOutput(HttpAction action, String contentType, OutputContent proc) {
        ResponseResultSet.output(action, contentType, "utf-8", proc);
    }

    static {
        ResponseOps.put(shortNamesResultSet, contentOutputJSON, "application/sparql-results+json");
        ResponseOps.put(shortNamesResultSet, contentOutputSPARQL, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputXML, "application/sparql-results+xml");
        ResponseOps.put(shortNamesResultSet, contentOutputText, "text/plain");
        ResponseOps.put(shortNamesResultSet, contentOutputCSV, "text/csv");
        ResponseOps.put(shortNamesResultSet, contentOutputTSV, "text/tab-separated-values");
        prefContentTypeResultSet = DEF.rsOffer;
        prefContentTypeRDF = DEF.rdfOffer;
    }

    static interface OutputContent {
        public void output(ServletOutputStream var1);
    }
}

