/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.conneg.WebLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseOps;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.WebContent;
import org.slf4j.Logger;

public class ResponseModel {
    private static Logger slog = ServletBase.log;
    private static final String contentOutputJSON = "json";
    private static final String contentOutputXML = "xml";
    private static final String contentOutputText = "text";
    private static final String contentOutputTTL = "ttl";
    private static final String contentOutputNT = "nt";
    public static Map<String, String> shortNamesModel = new HashMap<String, String>();

    public static void doResponseModel(HttpAction action, Model model) {
        Lang lang;
        String outputField;
        HttpServletRequest request = action.request;
        HttpServletResponse response = action.response;
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseOps.paramOutput(request, shortNamesModel)) != null) {
            mimeType = outputField;
        }
        String writerMimeType = mimeType;
        if (mimeType == null) {
            Fuseki.requestLog.warn("Can't find MIME type for response");
            String x = WebLib.getAccept(request);
            String msg = x == null ? "No Accept: header" : "Accept: " + x + " : Not understood";
            ServletBase.error(406, msg);
        }
        String contentType = mimeType;
        String charset = "utf-8";
        String forceAccept = ResponseOps.paramForceAccept(request);
        if (forceAccept != null) {
            contentType = "text/plain";
            charset = "utf-8";
        }
        if ((lang = WebContent.contentTypeToLang(contentType)) == null) {
            ServletBase.errorBadRequest("Can't determine output content type: " + contentType);
        }
        try {
            ResponseResultSet.setHttpResponse(request, response, contentType, charset);
            response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            RDFDataMgr.write((OutputStream)out, model, lang);
            out.flush();
        }
        catch (Exception ex) {
            slog.info("Exception while writing the response model: " + ex.getMessage(), ex);
            ServletBase.errorOccurred(ex);
        }
    }

    static {
        ResponseOps.put(shortNamesModel, contentOutputJSON, "application/rdf+json");
        ResponseOps.put(shortNamesModel, contentOutputXML, "application/rdf+xml");
        ResponseOps.put(shortNamesModel, contentOutputText, "text/turtle");
        ResponseOps.put(shortNamesModel, contentOutputTTL, "text/turtle");
        ResponseOps.put(shortNamesModel, contentOutputNT, "application/n-triples");
    }
}

