/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import com.hp.hpl.jena.sparql.core.Transactional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DatasetRef;

public class HttpAction {
    public final long id;
    private DatasetGraph dsg;
    private final Transactional transactional;
    private final boolean isTransactional;
    private final DatasetRef desc;
    private DatasetGraph activeDSG;
    private ReadWrite activeMode;
    public final HttpServletRequest request;
    public final HttpServletResponse response;
    public final boolean verbose;

    public HttpAction(long id, DatasetRef desc, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
        this.id = id;
        this.desc = desc;
        this.dsg = desc.dataset;
        if (this.dsg instanceof Transactional) {
            this.transactional = (Transactional)((Object)this.dsg);
            this.isTransactional = true;
        } else {
            DatasetGraphWithLock dsglock = new DatasetGraphWithLock(this.dsg);
            this.transactional = dsglock;
            this.isTransactional = false;
            this.dsg = dsglock;
        }
        this.request = request;
        this.response = response;
        this.verbose = verbose;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void beginRead() {
        this.activeMode = ReadWrite.READ;
        this.transactional.begin(ReadWrite.READ);
        this.activeDSG = this.dsg;
        this.desc.startTxn(ReadWrite.READ);
    }

    public void endRead() {
        this.desc.finishTxn(ReadWrite.READ);
        this.activeMode = null;
        this.transactional.end();
        this.activeDSG = null;
    }

    public void beginWrite() {
        this.transactional.begin(ReadWrite.WRITE);
        this.activeMode = ReadWrite.WRITE;
        this.activeDSG = this.dsg;
        this.desc.startTxn(ReadWrite.WRITE);
    }

    public void commit() {
        this.transactional.commit();
        this.activeDSG = null;
    }

    public void abort() {
        this.transactional.abort();
        this.activeDSG = null;
    }

    public void endWrite() {
        this.desc.finishTxn(ReadWrite.WRITE);
        this.activeMode = null;
        if (this.transactional.isInTransaction()) {
            Log.warn(this, "Transaction still active in endWriter - no commit or abort seen (forced abort)");
            try {
                this.transactional.abort();
            }
            catch (RuntimeException ex) {
                Log.warn(this, "Exception in forced abort (trying to continue)", (Throwable)ex);
            }
        }
        this.transactional.end();
        this.activeDSG = null;
    }

    public final DatasetGraph getActiveDSG() {
        return this.activeDSG;
    }

    public final DatasetRef getDatasetRef() {
        return this.desc;
    }

    private void enter(DatasetGraph dsg, Lock lock, boolean readLock) {
        if (lock == null && dsg == null) {
            return;
        }
        if (lock == null) {
            lock = dsg.getLock();
        }
        if (lock == null) {
            return;
        }
        lock.enterCriticalSection(readLock);
    }

    private void leave(DatasetGraph dsg, Lock lock, boolean readLock) {
        if (lock == null && dsg == null) {
            return;
        }
        if (lock == null) {
            lock = dsg.getLock();
        }
        if (lock == null) {
            return;
        }
        lock.leaveCriticalSection();
    }

    public void sync() {
        SystemARQ.sync(this.dsg);
    }

    public static MediaType contentNegotationRDF(HttpAction action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    public static MediaType contentNegotationQuads(HttpAction action) {
        return ConNeg.chooseContentType(action.request, DEF.quadsOffer, DEF.acceptNQuads);
    }
}

