/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DatasetRef {
    public String name = null;
    public List<String> queryEP = new ArrayList<String>();
    public List<String> updateEP = new ArrayList<String>();
    public List<String> uploadEP = new ArrayList<String>();
    public List<String> readGraphStoreEP = new ArrayList<String>();
    public List<String> readWriteGraphStoreEP = new ArrayList<String>();
    public DatasetGraph dataset = null;
    public AtomicLong activeReadTxn = new AtomicLong(0L);
    public AtomicLong activeWriteTxn = new AtomicLong(0L);
    public AtomicLong totalReadTxn = new AtomicLong(0L);
    public AtomicLong totalWriteTxn = new AtomicLong(0L);
    public boolean allowDatasetUpdate = false;
    public boolean allowTimeoutOverride = false;
    public long maximumTimeoutOverride = Long.MAX_VALUE;

    public void startTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.getAndIncrement();
                this.totalReadTxn.getAndIncrement();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.getAndIncrement();
                this.totalWriteTxn.getAndIncrement();
            }
        }
    }

    public void finishTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.decrementAndGet();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.decrementAndGet();
            }
        }
    }

    public boolean isReadOnly() {
        return this.updateEP.size() == 0 && this.uploadEP.size() == 0 && this.readWriteGraphStoreEP.size() == 0 && !this.allowDatasetUpdate;
    }
}

