/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

public class ActionBackup
extends ServletBase {
    public static final ExecutorService backupService = Executors.newFixedThreadPool(1);
    static final String BackupArea = "backups";

    public ActionBackup() {
        super(false);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean known;
        String dataset = FusekiLib.safeParameter(request, "dataset");
        if (dataset == null) {
            response.sendError(400, "Required parameter missing: ?dataset=");
            return;
        }
        if (!dataset.startsWith("/")) {
            dataset = "/" + dataset;
        }
        if (!(known = DatasetRegistry.get().isRegistered(dataset))) {
            response.sendError(400, "No such dataset: " + dataset);
            return;
        }
        DatasetRef ref = (DatasetRef)DatasetRegistry.get().get(dataset);
        long id = this.allocRequestId(request, response);
        HttpAction action = new HttpAction(id, ref, request, response, false);
        this.scheduleBackup(action, dataset);
    }

    private void scheduleBackup(final HttpAction action, String dataset) {
        final String ds = dataset.startsWith("/") ? dataset : "/" + dataset;
        String timestamp = Utils.nowAsString("yyyy-MM-dd_HH-mm-ss");
        final String filename = BackupArea + dataset + "_" + timestamp;
        FileOps.ensureDir(BackupArea);
        try {
            Callable<Boolean> task = new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    log.info(String.format("[%d] Start backup %s to '%s'", action.id, ds, filename));
                    action.beginRead();
                    try {
                        ActionBackup.backup(action.getActiveDSG(), filename);
                        log.info(String.format("[%d] Finish backup %s to '%s'", action.id, ds, filename));
                    }
                    catch (RuntimeException ex) {
                        log.info(String.format("[%d] Exception during backup: ", action.id, ex.getMessage()), ex);
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    finally {
                        action.endRead();
                    }
                    return Boolean.TRUE;
                }
            };
            log.info(String.format("[%d] Schedule backup %s to '%s'", action.id, dataset, filename));
            backupService.submit(task);
        }
        catch (RuntimeException ex) {
            log.warn("Unanticipated exception", ex);
            try {
                action.response.sendError(500, ex.getMessage());
            }
            catch (IOException e2) {
                IO.exception(e2);
            }
            return;
        }
        ActionBackup.successPage(action, "Backup scheduled - see server log for details");
    }

    protected static void successPage(HttpAction action, String message) {
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            if (message != null) {
                out.println("<p>");
                out.println(message);
                out.println("</p>");
            }
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backup(DatasetGraph dsg, String backupfile) {
        if (!backupfile.endsWith(".nq")) {
            backupfile = backupfile + ".nq";
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(backupfile + ".gz");
            out = new GZIPOutputStream(out, 8192);
            out = new BufferedOutputStream(out);
            RDFDataMgr.write(out, dsg, Lang.NQUADS);
            out.close();
            out = null;
        }
        catch (FileNotFoundException e2) {
            Log.warn(ActionBackup.class, "File not found: " + backupfile);
            throw new FusekiException("File not found: " + backupfile);
        }
        catch (IOException e3) {
            IO.exception(e3);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

