/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Convert;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.web.MediaType;

public class FusekiLib {
    public static MediaType contentType(HttpServletRequest request) {
        String x = request.getHeader("Content-Type");
        if (x == null) {
            return null;
        }
        return MediaType.create(x);
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm(request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm(tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiMap<String, String> parseQueryString(HttpServletRequest req) {
        MultiMap<String, String> map = MultiMap.createMapList();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put(name, value);
            }
        }
        return map;
    }

    public static String safeParameter(HttpServletRequest request, String pName) {
        String value = request.getParameter(pName);
        value = StringUtils.replaceChars(value, "\r", "");
        value = StringUtils.replaceChars(value, "\n", "");
        return value;
    }

    public static void addDataInto(Graph data, DatasetGraph dsg, Node graphName) {
        if (graphName == null) {
            graphName = Quad.defaultGraphNodeGenerated;
        }
        ExtendedIterator<Triple> iter = data.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            dsg.add(graphName, t.getSubject(), t.getPredicate(), t.getObject());
        }
    }
}

