/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSet;
import org.apache.commons.lang.StringUtils;

public class CharSetUtils {
    public static CharSet evaluateSet(String[] set) {
        if (set == null) {
            return null;
        }
        return new CharSet(set);
    }

    public static String squeeze(String str2, String set) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(set)) {
            return str2;
        }
        String[] strs = new String[]{set};
        return CharSetUtils.squeeze(str2, strs);
    }

    public static String squeeze(String str2, String[] set) {
        if (StringUtils.isEmpty(str2) || ArrayUtils.isEmpty(set)) {
            return str2;
        }
        CharSet chars = CharSet.getInstance(set);
        StringBuffer buffer = new StringBuffer(str2.length());
        char[] chrs = str2.toCharArray();
        int sz = chrs.length;
        int lastChar = 32;
        int ch = 32;
        for (int i = 0; i < sz; ++i) {
            ch = chrs[i];
            if (chars.contains((char)ch) && ch == lastChar && i != 0) continue;
            buffer.append((char)ch);
            lastChar = ch;
        }
        return buffer.toString();
    }

    public static int count(String str2, String set) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(set)) {
            return 0;
        }
        String[] strs = new String[]{set};
        return CharSetUtils.count(str2, strs);
    }

    public static int count(String str2, String[] set) {
        if (StringUtils.isEmpty(str2) || ArrayUtils.isEmpty(set)) {
            return 0;
        }
        CharSet chars = CharSet.getInstance(set);
        int count = 0;
        char[] chrs = str2.toCharArray();
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (!chars.contains(chrs[i])) continue;
            ++count;
        }
        return count;
    }

    public static String keep(String str2, String set) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() == 0 || StringUtils.isEmpty(set)) {
            return "";
        }
        String[] strs = new String[]{set};
        return CharSetUtils.keep(str2, strs);
    }

    public static String keep(String str2, String[] set) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() == 0 || ArrayUtils.isEmpty(set)) {
            return "";
        }
        return CharSetUtils.modify(str2, set, true);
    }

    public static String delete(String str2, String set) {
        if (StringUtils.isEmpty(str2) || StringUtils.isEmpty(set)) {
            return str2;
        }
        String[] strs = new String[]{set};
        return CharSetUtils.delete(str2, strs);
    }

    public static String delete(String str2, String[] set) {
        if (StringUtils.isEmpty(str2) || ArrayUtils.isEmpty(set)) {
            return str2;
        }
        return CharSetUtils.modify(str2, set, false);
    }

    private static String modify(String str2, String[] set, boolean expect) {
        CharSet chars = CharSet.getInstance(set);
        StringBuffer buffer = new StringBuffer(str2.length());
        char[] chrs = str2.toCharArray();
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (chars.contains(chrs[i]) != expect) continue;
            buffer.append(chrs[i]);
        }
        return buffer.toString();
    }

    public static String translate(String str2, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str2)) {
            return str2;
        }
        StringBuffer buffer = new StringBuffer(str2.length());
        char[] chrs = str2.toCharArray();
        char[] withChrs = replaceChars.toCharArray();
        int sz = chrs.length;
        int withMax = replaceChars.length() - 1;
        for (int i = 0; i < sz; ++i) {
            int idx = searchChars.indexOf(chrs[i]);
            if (idx != -1) {
                if (idx > withMax) {
                    idx = withMax;
                }
                buffer.append(withChrs[idx]);
                continue;
            }
            buffer.append(chrs[i]);
        }
        return buffer.toString();
    }
}

