/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader2;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.ColumnMap;

public class RecordLib {
    public static void main(String ... argv) {
        RecordFactory rf = new RecordFactory(8, 4);
        Record r = rf.create();
        Bytes.setLong(1311768467463790320L, r.getKey());
        Bytes.setInt(573785173, r.getValue());
        ColumnMap cMap = new ColumnMap("XYAB", "BYXA");
        Record r2 = RecordLib.copyRecord(rf, r, cMap);
        System.out.println(r);
        System.out.println(r2);
    }

    public static Record copyRecord(RecordFactory recordFactory, Record record, ColumnMap colMap) {
        int N;
        int vLen;
        int kLen = record.getKey().length;
        int n = vLen = record.getValue() == null ? 0 : record.getValue().length;
        if (recordFactory == null) {
            recordFactory = new RecordFactory(kLen, vLen);
        }
        if (kLen % (N = colMap.length()) != 0) {
            throw new RecordException("Key length is not a multiple of the number of slots");
        }
        int itemLen = kLen / N;
        Record record2 = recordFactory.create();
        byte[] k = record2.getKey();
        for (int i = 0; i < N; ++i) {
            int j = colMap.mapSlotIdx(i);
            System.arraycopy(record.getKey(), i * itemLen, record2.getKey(), j * itemLen, itemLen);
        }
        if (vLen != 0) {
            System.arraycopy(record.getValue(), 0, record2.getValue(), 0, vLen);
        }
        return record2;
    }
}

