/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.graph.BulkUpdateHandlerTDB;
import com.hp.hpl.jena.tdb.graph.TransactionHandlerTDB;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Tuple;
import org.slf4j.Logger;

public abstract class GraphTDBBase
extends GraphBase
implements GraphTDB {
    private final TransactionHandler transactionHandler = new TransactionHandlerTDB(this);
    private final BulkUpdateHandler bulkUpdateHandler = new BulkUpdateHandlerTDB(this);
    protected final DatasetGraphTDB dataset;
    protected final Node graphNode;
    private static final int sliceSize = 1000;

    public GraphTDBBase(DatasetGraphTDB dataset, Node graphName) {
        this.dataset = dataset;
        this.graphNode = graphName;
    }

    @Override
    public final Node getGraphNode() {
        return this.graphNode;
    }

    @Override
    public final DatasetGraphTDB getDataset() {
        return this.dataset;
    }

    @Override
    public final void performAdd(Triple triple) {
        this.startUpdate();
        this._performAdd(triple);
        this.finishUpdate();
    }

    @Override
    public final void performDelete(Triple triple) {
        this.startUpdate();
        this._performDelete(triple);
        this.finishUpdate();
    }

    @Override
    protected final ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        if (GraphTDBBase.isDefaultGraph(this.graphNode)) {
            return GraphTDBBase.graphBaseFindDft(this.getDataset(), m);
        }
        return GraphTDBBase.graphBaseFindNG(this.getDataset(), this.graphNode, m);
    }

    protected final void _performAdd(Triple t) {
        if (Quad.isUnionGraph(this.graphNode)) {
            throw new TDBException("Can't add a triple to the RDF merge of all named graphs");
        }
        this.dataset.add(this.graphNode(), t.getSubject(), t.getPredicate(), t.getObject());
    }

    protected final void _performDelete(Triple t) {
        if (Quad.isUnionGraph(this.graphNode)) {
            throw new TDBException("Can't delete triple from the RDF merge of all named graphs");
        }
        this.dataset.delete(this.graphNode(), t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public final void sync() {
        this.dataset.sync();
    }

    @Override
    public final void close() {
        this.sync();
    }

    @Override
    public abstract String toString();

    private Node graphNode() {
        return this.graphNode != null ? this.graphNode : Quad.defaultGraphNodeGenerated;
    }

    protected static boolean isDefaultGraph(Node g) {
        return g == null || Quad.isDefaultGraph(g);
    }

    protected void duplicate(Triple t) {
        if (TDB.getContext().isTrue(SystemTDB.symLogDuplicates) && this.getLog().isInfoEnabled()) {
            String $ = NodeFmtLib.displayStr(t, this.getPrefixMapping());
            this.getLog().info("Duplicate: (" + $ + ")");
        }
    }

    protected static ExtendedIterator<Triple> graphBaseFindDft(DatasetGraphTDB dataset, TripleMatch m) {
        Iterator<Quad> iterQuads = dataset.find(Quad.defaultGraphIRI, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iterQuads == null) {
            return NullIterator.instance();
        }
        ProjectQuadsToTriples iterTriples = new ProjectQuadsToTriples(Quad.defaultGraphIRI, iterQuads);
        return WrappedIterator.createNoRemove(iterTriples);
    }

    protected static ExtendedIterator<Triple> graphBaseFindNG(DatasetGraphTDB dataset, Node graphNode, TripleMatch m) {
        Iterator<Quad> iter;
        Node gn = graphNode;
        if (Quad.isUnionGraph(gn)) {
            gn = Node.ANY;
        }
        if ((iter = dataset.getQuadTable().find(gn, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) == null) {
            return NullIterator.instance();
        }
        Iterator<Triple> iterTriples = new ProjectQuadsToTriples(gn == Node.ANY ? null : gn, iter);
        if (gn == Node.ANY) {
            iterTriples = Iter.distinct(iterTriples);
        }
        return WrappedIterator.createNoRemove(iterTriples);
    }

    protected abstract Logger getLog();

    protected abstract Iterator<?> countThis();

    public void startRead() {
        this.dataset.startRead();
    }

    public void finishRead() {
        this.dataset.finishRead();
    }

    public final void startUpdate() {
        this.dataset.startUpdate();
    }

    public final void finishUpdate() {
        this.dataset.finishUpdate();
    }

    @Override
    protected final int graphBaseSize() {
        Iterator<?> iter = this.countThis();
        return (int)Iter.count(iter);
    }

    @Override
    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.bulkUpdateHandler;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                @Override
                public boolean sizeAccurate() {
                    return true;
                }

                @Override
                public boolean addAllowed() {
                    return true;
                }

                @Override
                public boolean addAllowed(boolean every) {
                    return true;
                }

                @Override
                public boolean deleteAllowed() {
                    return true;
                }

                @Override
                public boolean deleteAllowed(boolean every) {
                    return true;
                }

                @Override
                public boolean canBeEmpty() {
                    return true;
                }

                @Override
                public boolean iteratorRemoveAllowed() {
                    return false;
                }

                @Override
                public boolean findContractSafe() {
                    return true;
                }

                @Override
                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return super.getCapabilities();
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    @Override
    public void clear() {
        GraphTDBBase.removeWorker(this, Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        if (this.getEventManager().listening()) {
            super.remove(s, p, o);
            return;
        }
        GraphTDBBase.removeWorker(this, s, p, o);
    }

    public static void removeWorker(GraphTDBBase g, Node s, Node p, Node o) {
        int len;
        g.startUpdate();
        NodeTupleTable t = g.getNodeTupleTable();
        Node gn = g.getGraphNode();
        Tuple[] array = new Tuple[1000];
        do {
            Iterator<Tuple<NodeId>> iter = null;
            iter = gn == null ? t.findAsNodeIds(s, p, o) : t.findAsNodeIds(gn, s, p, o);
            if (iter == null) {
                return;
            }
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                t.getTupleTable().delete(array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
        g.finishUpdate();
    }

    static class ProjectQuadsToTriples
    implements Iterator<Triple> {
        private final Iterator<Quad> iter;
        private final Node graphNode;

        ProjectQuadsToTriples(Node graphNode, Iterator<Quad> iter) {
            this.graphNode = graphNode;
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Triple next() {
            Quad q = this.iter.next();
            if (this.graphNode != null && !q.getGraph().equals(this.graphNode)) {
                throw new InternalError("ProjectQuadsToTriples: Quads from unexpected graph (expected=" + this.graphNode + ", got=" + q.getGraph() + ")");
            }
            return q.asTriple();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

