/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.TDBInternal;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphNamedTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphNamedTDB.class);
    private NodeId graphNodeId = null;
    private static Transform<Tuple<NodeId>, Tuple<NodeId>> project4TupleTo3Tuple = new Transform<Tuple<NodeId>, Tuple<NodeId>>(){

        @Override
        public Tuple<NodeId> convert(Tuple<NodeId> item) {
            if (item.size() != 4) {
                throw new TDBException("Expected a Tuple of 4, got: " + item);
            }
            return Tuple.create(item.get(1), item.get(2), item.get(3));
        }
    };

    public GraphNamedTDB(DatasetGraphTDB dataset, Node graphName) {
        super(dataset, graphName);
        if (graphName != null && !graphName.isURI()) {
            throw new TDBException("GraphNamedTDB: Graph name not a URI - " + graphName.toString());
        }
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        if (this.isDefaultGraph()) {
            return this.dataset.getPrefixes().getPrefixMapping();
        }
        return this.dataset.getPrefixes().getPrefixMapping(this.graphNode.getURI());
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        NodeId gn;
        if (this.isDefaultGraph()) {
            return this.dataset.getTripleTable().getNodeTupleTable().findAll();
        }
        NodeId nodeId = gn = Quad.isUnionGraph(this.graphNode) ? null : this.getGraphNodeId();
        if (NodeId.isDoesNotExist(gn)) {
            return Iter.nullIterator();
        }
        Iterator<Tuple<NodeId>> iter = this.dataset.getQuadTable().getNodeTupleTable().find(gn, null, null, null);
        if (Quad.isUnionGraph(this.graphNode)) {
            iter = Iter.map(iter, project4TupleTo3Tuple);
            iter = Iter.distinct(iter);
        }
        return iter;
    }

    private final NodeId getGraphNodeId() {
        if (this.graphNodeId == null || this.graphNodeId == NodeId.NodeDoesNotExist) {
            NodeId n;
            this.graphNodeId = n = TDBInternal.getNodeId(this.dataset, this.graphNode);
        }
        return this.graphNodeId;
    }

    private boolean isDefaultGraph() {
        return GraphNamedTDB.isDefaultGraph(this.graphNode);
    }

    @Override
    protected final Logger getLog() {
        return log;
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        if (this.isDefaultGraph()) {
            return this.dataset.getTripleTable().getNodeTupleTable();
        }
        return this.dataset.getQuadTable().getNodeTupleTable();
    }

    @Override
    public String toString() {
        String x = ":defaultGraph";
        if (this.graphNode != null) {
            x = ":<" + this.graphNode + ">";
        }
        return Utils.className(this) + x;
    }
}

