/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.atlas.lib.Pair;

public class NodeTableNative
implements NodeTable {
    protected ObjectFile objects;
    protected Index nodeHashToId;
    private boolean syncNeeded = false;

    protected NodeTableNative() {
    }

    public NodeTableNative(Index nodeToId, ObjectFile objectFile) {
        this();
        this.init(nodeToId, objectFile);
    }

    protected void init(Index nodeToId, ObjectFile objectFile) {
        this.nodeHashToId = nodeToId;
        this.objects = objectFile;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        Node n = this.readNodeFromTable(id);
        return n;
    }

    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeId nodeId = this.accessIndex(node, allocate);
        return nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NodeId accessIndex(Node node, boolean create) {
        Hash hash = new Hash(this.nodeHashToId.getRecordFactory().keyLength());
        NodeLib.setHash(hash, node);
        byte[] k = hash.getBytes();
        Record r = this.nodeHashToId.getRecordFactory().create(k);
        NodeTableNative nodeTableNative = this;
        synchronized (nodeTableNative) {
            Record r2 = this.nodeHashToId.find(r);
            if (r2 != null) {
                NodeId id = NodeId.create(r2.getValue(), 0);
                return id;
            }
            if (!create) {
                return NodeId.NodeDoesNotExist;
            }
            NodeId id = this.writeNodeToTable(node);
            id.toBytes(r.getValue(), 0);
            if (!this.nodeHashToId.add(r)) {
                throw new TDBException("NodeTableBase::nodeToId - record mysteriously appeared");
            }
            return id;
        }
    }

    private final NodeId writeNodeToTable(Node node) {
        this.syncNeeded = true;
        long x = NodeLib.encodeStore(node, this.getObjects());
        return NodeId.create(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node readNodeFromTable(NodeId id) {
        NodeTableNative nodeTableNative = this;
        synchronized (nodeTableNative) {
            if (id.getId() >= this.getObjects().length()) {
                return null;
            }
            return NodeLib.fetchDecode(id.getId(), this.getObjects());
        }
    }

    @Override
    public synchronized void close() {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.close();
            this.nodeHashToId = null;
        }
        if (this.getObjects() != null) {
            this.getObjects().close();
            this.objects = null;
        }
    }

    @Override
    public NodeId allocOffset() {
        return NodeId.create(this.getObjects().length());
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return this.all2();
    }

    private Iterator<Pair<NodeId, Node>> all1() {
        Iterator<Record> iter = this.nodeHashToId.iterator();
        Transform<Record, Pair<NodeId, Node>> transform = new Transform<Record, Pair<NodeId, Node>>(){

            @Override
            public Pair<NodeId, Node> convert(Record item) {
                NodeId id = NodeId.create(item.getValue(), 0);
                Node n = NodeLib.fetchDecode(id.getId(), NodeTableNative.this.getObjects());
                return new Pair<NodeId, Node>(id, n);
            }
        };
        return Iter.map(iter, transform);
    }

    private Iterator<Pair<NodeId, Node>> all2() {
        Iterator<Pair<Long, ByteBuffer>> objs = this.objects.all();
        Transform<Pair<Long, ByteBuffer>, Pair<NodeId, Node>> transform = new Transform<Pair<Long, ByteBuffer>, Pair<NodeId, Node>>(){

            @Override
            public Pair<NodeId, Node> convert(Pair<Long, ByteBuffer> item) {
                NodeId id = NodeId.create(item.car());
                ByteBuffer bb = item.cdr();
                Node n = NodeLib.decode(bb);
                return new Pair<NodeId, Node>(id, n);
            }
        };
        return Iter.map(objs, transform);
    }

    @Override
    public void sync() {
        if (this.syncNeeded) {
            if (this.nodeHashToId != null) {
                this.nodeHashToId.sync();
            }
            if (this.getObjects() != null) {
                this.getObjects().sync();
            }
            this.syncNeeded = false;
        }
    }

    public ObjectFile getObjects() {
        return this.objects;
    }

    public String toString() {
        return this.objects.getLabel();
    }

    @Override
    public boolean isEmpty() {
        return this.getObjects().isEmpty();
    }
}

