/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class GraphMemPlain
extends GraphBase {
    private Set<Triple> triples = new HashSet<Triple>();

    @Override
    public void performAdd(Triple t) {
        this.triples.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.triples.remove(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean graphBaseContains(Triple t) {
        if (t.isConcrete()) {
            return this.triples.contains(t);
        }
        ExtendedIterator<Triple> it = this.find(t);
        try {
            while (it.hasNext()) {
                Triple t2 = (Triple)it.next();
                if (!GraphMemPlain.tripleContained(t, t2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            it.close();
        }
        return false;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        Iterator<Triple> iter = this.triples.iterator();
        return SimpleEventManager.notifyingRemove(this, iter).filterKeep(new TripleMatchFilterEquality(m.asTriple()));
    }

    static boolean tripleContained(Triple patternTriple, Triple dataTriple) {
        return GraphMemPlain.equalNode(patternTriple.getSubject(), dataTriple.getSubject()) && GraphMemPlain.equalNode(patternTriple.getPredicate(), dataTriple.getPredicate()) && GraphMemPlain.equalNode(patternTriple.getObject(), dataTriple.getObject());
    }

    private static boolean equalNode(Node m, Node n) {
        n = GraphMemPlain.fixupNode(n);
        return (m = GraphMemPlain.fixupNode(m)) == null || m == Node.ANY || m.equals(n);
    }

    private static Node fixupNode(Node node) {
        String lang;
        if (node == null || node == Node.ANY) {
            return node;
        }
        if (node.isLiteral() && (lang = node.getLiteralLanguage()) != null && !lang.equals("")) {
            node = NodeFactory.createLiteral(node.getLiteralLexicalForm(), lang.toLowerCase(Locale.ENGLISH), node.getLiteralDatatype());
        }
        return node;
    }

    static class TripleMatchFilterEquality
    extends Filter<Triple> {
        protected final Triple tMatch;

        public TripleMatchFilterEquality(Triple tMatch) {
            this.tMatch = tMatch;
        }

        @Override
        public boolean accept(Triple t) {
            return GraphMemPlain.tripleContained(this.tMatch, t);
        }
    }
}

