/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.LoggerLog;
import org.eclipse.jetty.util.log.StdErrLog;

public class Log {
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED ";
    protected static Properties __props;
    public static String __logClass;
    public static boolean __ignored;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static Logger LOG;
    private static boolean __initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialized() {
        if (LOG != null) {
            return true;
        }
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOG != null;
            }
            __initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                Class log_class = Loader.loadClass(Log.class, __logClass);
                if (LOG == null || !LOG.getClass().equals(log_class)) {
                    LOG = (Logger)log_class.newInstance();
                    LOG.debug("Logging to {} via {}", LOG, log_class.getName());
                }
            }
            catch (Throwable e2) {
                Log.initStandardLogging(e2);
            }
            return LOG != null;
        }
    }

    private static void initStandardLogging(Throwable e2) {
        if (e2 != null && __ignored) {
            e2.printStackTrace();
        }
        if (LOG == null) {
            Class<StdErrLog> log_class = StdErrLog.class;
            LOG = new StdErrLog();
            LOG.debug("Logging to {} via {}", LOG, log_class.getName());
        }
    }

    public static void setLog(Logger log) {
        LOG = log;
    }

    @Deprecated
    public static Logger getLog() {
        Log.initialized();
        return LOG;
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static void setLogToParent(String name) {
        ClassLoader loader = Log.class.getClassLoader();
        if (loader.getParent() != null) {
            try {
                Class<?> uberlog = loader.getParent().loadClass("org.eclipse.jetty.util.log.Log");
                Method getLogger = uberlog.getMethod("getLogger", String.class);
                Object logger = getLogger.invoke(null, name);
                Log.setLog(new LoggerLog(logger));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else {
            Log.setLog(Log.getLogger(name));
        }
    }

    @Deprecated
    public static void debug(Throwable th) {
        if (!Log.isDebugEnabled()) {
            return;
        }
        LOG.debug(EXCEPTION, th);
    }

    @Deprecated
    public static void debug(String msg) {
        if (!Log.initialized()) {
            return;
        }
        LOG.debug(msg, new Object[0]);
    }

    @Deprecated
    public static void debug(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        LOG.debug(msg, arg);
    }

    @Deprecated
    public static void debug(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        LOG.debug(msg, arg0, arg1);
    }

    @Deprecated
    public static void ignore(Throwable thrown) {
        if (!Log.initialized()) {
            return;
        }
        LOG.ignore(thrown);
    }

    @Deprecated
    public static void info(String msg) {
        if (!Log.initialized()) {
            return;
        }
        LOG.info(msg, new Object[0]);
    }

    @Deprecated
    public static void info(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        LOG.info(msg, arg);
    }

    @Deprecated
    public static void info(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        LOG.info(msg, arg0, arg1);
    }

    @Deprecated
    public static boolean isDebugEnabled() {
        if (!Log.initialized()) {
            return false;
        }
        return LOG.isDebugEnabled();
    }

    @Deprecated
    public static void warn(String msg) {
        if (!Log.initialized()) {
            return;
        }
        LOG.warn(msg, new Object[0]);
    }

    @Deprecated
    public static void warn(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        LOG.warn(msg, arg);
    }

    @Deprecated
    public static void warn(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        LOG.warn(msg, arg0, arg1);
    }

    @Deprecated
    public static void warn(String msg, Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        LOG.warn(msg, th);
    }

    @Deprecated
    public static void warn(Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        LOG.warn(EXCEPTION, th);
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        if (!Log.initialized()) {
            return null;
        }
        if (name == null) {
            return LOG;
        }
        Logger logger = (Logger)__loggers.get(name);
        if (logger == null) {
            logger = LOG.getLogger(name);
        }
        return logger;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    static {
        __loggers = new ConcurrentHashMap<String, Logger>();
        __props = new Properties();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                URL testProps = Log.class.getClassLoader().getResource("jetty-logging.properties");
                if (testProps != null) {
                    InputStream in = null;
                    try {
                        in = testProps.openStream();
                        __props.load(in);
                    }
                    catch (IOException e2) {
                        System.err.println("Unable to load " + testProps);
                        e2.printStackTrace(System.err);
                    }
                    finally {
                        IO.close(in);
                    }
                }
                Enumeration<?> systemKeyEnum = System.getProperties().propertyNames();
                while (systemKeyEnum.hasMoreElements()) {
                    String key = (String)systemKeyEnum.nextElement();
                    String val = System.getProperty(key);
                    if (val == null) continue;
                    __props.setProperty(key, val);
                }
                __logClass = __props.getProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }
}

